######################################################################
######################################################################

proc mouse_navigate {port dimensions modifier ratiox {ratioy {}}} {

  # left-right	<None>	- rotate <n,v> about y-axis
  # left-right	<Ctrl>	- rotate <n,v> about z-axis
  # up-down	<Ctrl>	- rotate <n,v> about x-axis

  # up-down	<None>	- translate vrp along z-axis
  # up-down	<Shift>	- translate vrp along y-axis
  # left-right	<Shift>	- translate vrp along x-axis

  set pointerxy [winfo pointerxy $port];
  set pointerx [lindex $pointerxy 0];
  set pointery [lindex $pointerxy 1];

  if {($pointerx == -1) && ($pointery == -1)} {
    return;
  }

  set rootx [winfo rootx $port];
  set rooty [winfo rooty $port];

  if ![string compare $ratioy {}] {
    set ratioy $ratiox;
  }

  $port navigate $pointerx $pointery [winfo rootx $port] [winfo rooty $port] $ratiox $ratioy $dimensions $modifier;
}


######################################################################
######################################################################

proc kbd_navigate {port dimensions modifier ratiox {ratioy {}}} {

  # left-right	<None>	- rotate <n,v> about y-axis
  # left-right	<Ctrl>	- rotate <n,v> about z-axis
  # up-down	<Ctrl>	- rotate <n,v> about x-axis

  # up-down	<None>	- translate vrp along z-axis
  # up-down	<Shift>	- translate vrp along y-axis
  # left-right	<Shift>	- translate vrp along x-axis

  if ![string compare $ratioy {}] {
    set ratioy $ratiox;
  }

  $port navigate 1 1 1 1 $ratiox $ratioy $dimensions $modifier;
}


######################################################################
######################################################################

proc start_navigation {port dimensions modifiers ratio {update 0}} {

  global __NAVIGATING;

  set __NAVIGATING 1;

  while {$__NAVIGATING == 1} {
    mouse_navigate $port $dimensions $modifiers $ratio;
    if $update {
      $port update;
    }
    update;
  }
}


######################################################################
######################################################################

proc stop_navigation {} {

  global __NAVIGATING;

  set __NAVIGATING 0;
}


######################################################################
######################################################################
