######################################################################
######################################################################

#
# smscene:
#
# display a simple scene that consists of a few objects of simple
# geometric shapes.
#

proc smscene {{colormap ""} {visual ""}} {

  if {$visual == ""} {
    set visual [getvisual widget];
    if {$visual == ""} {
      error "no OpenGL visual available";
    }
  }

  if {$colormap == ""} {
    if {([winfo visual .] == [lindex $visual 0]) && ([winfo depth .] == [lindex $visual 1])} {
      set colormap .;
    } else {
      set colormap new;
    }
  }
  set image [image create photo -file floor.ppm];

  set width [image width $image];
  set height [image height $image];

  set texture [texture create image 0 0 $width $height 0 $image];

  catch {scene destroy};
  cell create scene

  vport scene .scene $colormap $visual	-vrp {100 100 100} \
					-vpn {1 1 1} \
					-prp {0 0 0.5} \
					-maxu 0.5 \
					-maxv 0.5 \
					-minu -0.5 \
					-minv -0.5;
				 

  #
  # ground
  #

  scene create poly ground -vertices {{ 100 0  100} \
				      { 100 0 -100} \
				      {-100 0 -100} \
				      {-100 0  100} \
				      } \
			   -surfaces {{1 2 3 4 1}} \
			   -pos {0 0 0} \
			   -fwd {0 0 1} \
			   -up {0 1 0} \
			   -color white \
			   -emissive {0 0 0} \
			   -diffuse {0.7 0.7 0.7} \
			   -ambient {0.3 0.3 0.3} \
			   -specular {0.0 0.0 0.0 0} \
			   -cull none \
			   -shading smooth \
			   -average off \
			   -texture [list [list 1 $texture 3 modulate \
						repeat repeat nearest nearest \
						{0 0 0} {{0 10} {10 10} {10 0} {0 0}}] \
					  ];

  # column 1

  set column1 [make_column scene column1 blue];
  scene modelconfigure $column1 -pos {-80 0 -80};

  # column 2

  set column2 [make_column scene column2 cadetblue];
  scene modelconfigure $column2 -pos {80 0 -80};

  # column 3

  set column3 [make_column scene column3 slategray];
  scene modelconfigure $column3 -pos {80 0 80};

  # column 4

  set column4 [make_column scene column4 forestgreen];
  scene modelconfigure $column4 -pos {-80 0 80};

  # sphere

  scene create sphere orb -radius 20 \
			  -pos {0 40 0} \
			  -fwd {0 1 0} \
			  -up {0 0 -1} \
			  -stacks 10 \
			  -slices 15 \
			  -color orange \
			  -emissive {0.8 0.8 0.8} \
			  -diffuse {0.0 0.0 0.0} \
			  -ambient {0.0 0.0 0.0} \
			  -specular {1.0 0.0 0.0 20} \
			  -cull none \
			  -shading smooth \
			  -normals smooth;

  # arrow 1

  set arrow1 [make_arrow scene arrow1 brown 8 15 14 10 5];
  scene modelconfigure $arrow1 -pos {40 40 0} -fwd {1 0 0} -up {0 1 0};

  # arrow 2

  set arrow2 [make_arrow scene arrow2 brown 8 15 14 10 5];
  scene modelconfigure $arrow2 -pos {-40 40 0} -fwd {-1 0 0} -up {0 1 0};

  # arrow 3

  set arrow3 [make_arrow scene arrow3 brown 8 15 14 10 5];
  scene modelconfigure $arrow3 -pos {0 40 40} -fwd {0 0 1} -up {0 1 0};

  # arrow 4

  set arrow4 [make_arrow scene arrow4 brown 8 15 14 10 5];
  scene modelconfigure $arrow4 -pos {0 40 -40} -fwd {0 0 -1} -up {0 1 0};

}


######################################################################
######################################################################

#
# make_column:
#
# create a column object
#

proc make_column {cell label color} {

  # column base

  $cell create cylinder $label -baseradius 16 \
			       -topradius 10 \
			       -height 6 \
			       -pos {0 0 0} \
			       -fwd {0 1 0} \
			       -up {0 0 -1} \
			       -stacks 20 \
			       -slices 20 \
			       -color $color \
			       -emissive {0 0 0} \
			       -diffuse {0.6 0.6 0.6} \
			       -ambient {0.2 0.2 0.2} \
			       -specular {1.0 1.0 1.0 20} \
			       -cull none \
			       -shading smooth \
			       -normals smooth;

  $cell create cylinder $label:top -baseradius 10 \
				   -topradius 12 \
				   -height 6 \
				   -pos {0 0 42} \
				   -fwd {0 0 1} \
				   -up {0 1 0} \
				   -stacks 20 \
				   -slices 20 \
				   -color $color \
				   -emissive {0 0 0} \
				   -diffuse {0.6 0.6 0.6} \
				   -ambient {0.2 0.2 0.2} \
				   -specular {1.0 1.0 1.0 10} \
				   -cull none \
				   -shading smooth \
				   -normals smooth \
				   -parent $label;

  $cell create cylinder $label:shaft -baseradius 10 \
				     -topradius 10 \
				     -height 36 \
				     -pos {0 0 6} \
				     -fwd {0 0 1} \
				     -up {0 1 0} \
				     -stacks 20 \
				     -slices 20 \
				     -color $color \
				     -emissive {0 0 0} \
				     -diffuse {0.6 0.6 0.6} \
				     -ambient {0.2 0.2 0.2} \
				     -specular {1.0 1.0 1.0 10} \
				     -cull none \
				     -shading smooth \
				     -normals smooth \
				     -parent $label;

  $cell create poly $label:cube -vertices {{-12 -8 -12} {12 -8 -12} {12 -8 12} {-12 -8 12} \
					   {-12 8 -12} {12 8 -12} {12 8 12} {-12 8 12}} \
				-surfaces {{1 2 3 4 1} {8 7 6 5 8} {1 4 8 5 1} \
					   {2 6 7 3 2} {1 5 6 2 1} {3 7 8 4 3}} \
				-pos {0 0 56} \
				-fwd {0 1 0} \
				-up {0 0 1} \
				-color $color \
				-emissive {0 0 0} \
				-diffuse {0.6 0.6 0.6} \
				-ambient {0.2 0.2 0.2} \
				-specular {1.0 1.0 1.0 20} \
				-cull none \
				-shading smooth \
				-average off \
				-parent $label;
  return $label;
}

#
# make_arrow:
#
# create an arrow object
#

proc make_arrow {cell label color sw sl hw hl d} {

  $cell create poly $label -vertices [list [list $sw $d 0] \
					   [list $sw $d $sl] \
					   [list $hw $d $sl] \
					   [list 0 $d [expr $sl + $hl]] \
					   [list -$hw $d $sl] \
					   [list -$sw $d $sl] \
					   [list -$sw $d 0] \
					   [list $sw -$d 0] \
					   [list $sw -$d $sl] \
					   [list $hw -$d $sl] \
					   [list 0 -$d [expr $sl + $hl]] \
					   [list -$hw -$d $sl] \
					   [list -$sw -$d $sl] \
					   [list -$sw -$d 0] \
					   ] \
			   -surfaces [list [list 1 7 6 2 1] \
					   [list 6 5 4 3 2 6] \
					   [list 8 9 13 14 8] \
					   [list 9 10 11 12 13 9] \
					   [list 1 2 9 8 1] \
					   [list 2 3 10 9 2] \
					   [list 3 4 11 10 3] \
					   [list 4 5 12 11 4] \
					   [list 5 6 13 12 5] \
					   [list 6 7 14 13 6] \
					   [list 7 1 8 14 7] \
				           ] \
			   -pos {0 0 0} \
			   -fwd {0 0 1} \
			   -up {0 1 0} \
			   -color $color \
			   -emissive {0 0 0} \
			   -diffuse {0.8 0.8 0.8} \
			   -ambient {0.2 0.2 0.2} \
			   -specular {1.0 1.0 1.0 20} \
			   -cull none \
			   -shading smooth;
  return $label;
}
