######################################################################
######################################################################

#
# display primitive geometric objects in a canvas viewport
#

proc smcanvas {{cell c} {top .canvas} {colormap ""} {visual ""}} {

  if {$visual == ""} {
    set visual [getvisual canvas];
    if {$visual == ""} {
      error "no OpenGL visual available";
    }
  }

  if {$colormap == ""} {
    if {([winfo visual .] == [lindex $visual 0]) && ([winfo depth .] == [lindex $visual 1])} {
      set colormap .;
    } else {
      set colormap new;
    }
  }

  set objs [primitives $cell];
  cport $cell $top $colormap $visual	-maxu 5 \
					-minu -5 \
					-maxv 3 \
					-minv -3 \
					-vrp {0 0 100} \
					-vpn {0 0 1};

  button $top.c.b0	-relief raised \
			-bd 2 \
			-text points \
			-padx 0 \
			-pady 0 \
			-anchor nw \
			-font -*-helvetica-medium-r-normal-*-8-*-*-*-*-*-*-* \
			-highlightthickness 0;

  button $top.c.b1	-relief raised \
			-bd 2 \
			-text sphere \
			-padx 0 \
			-pady 0 \
			-anchor nw \
			-font -*-helvetica-medium-r-normal-*-8-*-*-*-*-*-*-* \
			-highlightthickness 0;

  button $top.c.b2	-relief raised \
			-bd 2 \
			-text cylinder \
			-padx 0 \
			-pady 0 \
			-anchor nw \
			-font -*-helvetica-medium-r-normal-*-8-*-*-*-*-*-*-* \
			-highlightthickness 0;

  button $top.c.b3	-relief raised \
			-bd 2 \
			-text disk \
			-padx 0 \
			-pady 0 \
			-anchor nw \
			-font -*-helvetica-medium-r-normal-*-8-*-*-*-*-*-*-* \
			-highlightthickness 0;

  button $top.c.b4	-relief raised \
			-bd 2 \
			-text polygon \
			-padx 0 \
			-pady 0 \
			-anchor nw \
			-font -*-helvetica-medium-r-normal-*-8-*-*-*-*-*-*-* \
			-highlightthickness 0;

  button $top.c.b5	-relief raised \
			-bd 2 \
			-text lines \
			-padx 0 \
			-pady 0 \
			-anchor nw \
			-font -*-helvetica-medium-r-normal-*-8-*-*-*-*-*-*-* \
			-highlightthickness 0;

  $top.c create window 70 190 -window $top.c.b0;
  $top.c create window 117 190 -window $top.c.b1;
  $top.c create window 166 190 -window $top.c.b2;
  $top.c create window 213 190 -window $top.c.b3;
  $top.c create window 260 190 -window $top.c.b4;
  $top.c create window 310 190 -window $top.c.b5;
}


######################################################################
######################################################################

#
# display primitive geometric objects in a viewport widget
#

proc smviewport {{cell c} {top .viewport} {colormap ""} {visual ""}} {

  if {$visual == ""} {
    set visual [getvisual widget];
    if {$visual == ""} {
      error "no OpenGL visual available";
    }
  }

  if {$colormap == ""} {
    if {([winfo visual .] == [lindex $visual 0]) && ([winfo depth .] == [lindex $visual 1])} {
      set colormap .;
    } else {
      set colormap new;
    }
  }

  set objs [primitives $cell];
  vport $cell $top $colormap $visual	-vrp {10 0 100} \
					-maxu 5 \
					-minu -5 \
					-maxv 2 \
					-minv -2;
}

######################################################################
######################################################################
