######################################################################

proc smvrml {{file demo.wrl} {colormap {}} {visual {}}} {

  vrml $file $colormap $visual;
}


######################################################################
######################################################################

proc vrml {file {colormap {}} {visual {}} {cell c} {prefix model}} {

  catch {$cell destroy};
  catch {destroy .vrml};

  if {$visual == ""} {
    set visual [getvisual widget];
    if {$visual == ""} {
      error "no OpenGL visual available";
    }
  }

  if {$colormap == ""} {
    if {([winfo visual .] == [lindex $visual 0]) && ([winfo depth .] == [lindex $visual 1])} {
      set colormap .;
    } else {
      set colormap new;
    }
  }

  set output [read_vrml $file $cell $prefix];
  if {$output == {}} {
    catch {$cell destroy};
    return;
  }
  set views [lindex $output 5];

  vport $cell .vrml $colormap $visual
  if {$views != {}} {

    set lights [lindex $output 6];
    set firstview [lindex $views 0];

    if [string compare $lights {}] {
      set i 0;
      foreach l $lights {
        .vrml.c configure -light$i [lrange $l 1 end];
        incr i;
      }
      for {} {$i < 8} {incr i} {
        .vrml.c configure -light$i {};
      }
    }

    set projection [lindex $firstview 1];
    set vrp [lindex $firstview 2];
    set vpn [lindex $firstview 3];
    set vup [lindex $firstview 4];
    set prp [lindex $firstview 5];
    set near [lindex $firstview 6];
    set far [lindex $firstview 7];
    set width [expr [lindex $firstview 8] / 2];
    set height [expr [lindex $firstview 9] / 2];

    .vrml.c configure -projection $projection \
		      -vrp $vrp \
		      -vpn $vpn \
		      -vup $vup \
		      -prp $prp \
		      -maxu $width \
		      -maxv $height \
		      -minu -$width \
		      -minv -$height;
  }
  return $output;
}


######################################################################
######################################################################

proc photo2rgb {image file} {

  set f [open $file w];

  set width [image width $image];
  set height [image height $image];

  puts $f "$width $height 3";
  for {set row [expr $height - 1]} {$row >= 0} {incr row -1} {

    for {set col 0} {$col < $width} {incr col} {

      set rgb [$image get $col $row];
      set value [expr [lindex $rgb 0] * 65536 + \
		      [lindex $rgb 1] * 256 + \
		      [lindex $rgb 0]];
      puts -nonewline $f [format "0x%x " $value];
    }
    puts $f {};
  }
  close $f;
}
