######################################################################
######################################################################

#
# smtexture:
#
# display a texture-mapped cube that the user can inspect
#

proc smtexture {{colormap ""} {visual ""}} {

  if {$visual == ""} {
    set visual [getvisual widget];
    if {$visual == ""} {
      error "no OpenGL visual available";
    }
  }

  if {$colormap == ""} {
    if {([winfo visual .] == [lindex $visual 0]) && ([winfo depth .] == [lindex $visual 1])} {
      set colormap .;
    } else {
      set colormap new;
    }
  }

  set image [image create photo -file texture.ppm];

  set width [image width $image];
  set height [image height $image];

  set texture0 [texture create data 2 2 0 {{255 0 0} {0 255 0} {0 0 255} {255 255 255}}];
  set texture1 [texture create image 0 0 $width $height 0 $image];

  catch {tex destroy}
  cell create tex;

  tex create polygon cube1 -vertices [list {-20 -20 -20} \
					   { 20 -20 -20} \
					   { 20 -20  20} \
				           {-20 -20  20} \
					   {-20  20 -20} \
					   { 20  20 -20} \
					   { 20  20  20} \
					   {-20  20  20} \
					   ] \
			   -surfaces [list {1 2 3 4} \
					   {8 7 6 5} \
					   {1 4 8 5} \
					   {2 6 7 3} \
					   {1 5 6 2} \
					   {3 7 8 4} \
					   ] \
			   -color white \
			   -fwd {0 1 1} \
			   -average off \
			   -shading smooth;

  vport tex .texture $colormap $visual -maxu 2 -maxv 2 -minu -2 -minv -2 -vpn {0 0 1} -vrp {0 0 100};

  set map1 [list 1 $texture0 3 decal repeat clamp linear nearest \
		 {0 0 0} {{0 0} {0 2} {2 2} {2 0}}];
  set map2 [list 2 $texture0 3 decal clamp repeat linear linear \
		 {0 0 0} {{3 0} {3 3} {0 3} {0 0}}];
  set map3 [list 3 $texture0 3 {blend 0.5 0.5 0.5} repeat repeat linear linear \
		 {0 0 0} {{10 0} {10 10} {0 10} {0 0}}];
  set map4 [list 4 $texture1 3 {blend 0.6 0.6 0.6} repeat repeat linear linear \
		 {0 0 0} {{0 0} {4 0} {4 4} {0 4}}];
  set map5 [list 5 $texture1 3 modulate repeat repeat nearest nearest \
		 {0 0 0} {{1 2} {1 0} {0 0} {0 2}}];
  set map6 [list 6 $texture1 3 modulate repeat repeat nearest nearest \
		 {0 0 0} {{1 1} {1 0} {0 0} {0 1}}];

  tex modelconfigure cube1 -texture [list $map1 $map2 $map3 $map4 $map5 $map6];

  # override vport's default mouse bindings for navigation
  # with our own bindings for manipulating models

  bind .texture.c       <Button-1>	[list manipulate-mark %W tex cube1 %x %y __MANIPULATE];
  bind .texture.c       <B1-Motion>	[list manipulate-drag %W tex cube1 %x %y __MANIPULATE];
}
