/********************************************************************************
 *
 * asciitext.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_AsciiText
 *
 * Read in an AsciiText node.
 *
 * fields:	string		""	MFString
 *		spacing		1	SFFloat
 *		justification	LEFT	SFEnum
 *		width		0	MFFloat
 *
 * justification:	LEFT, CENTER, RIGHT
 *
 *******************************************************************************/

Node *
Vrml_read_AsciiText(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    int i;
    char *field;
    NodeAsciiText *asciitext;
    
    asciitext = &node->node.asciiText;
    asciitext->string = NULL;
    asciitext->stringlen = 0;
    asciitext->spacing = 1;
    asciitext->width = (float *) ckalloc(sizeof(float));
    asciitext->width[0] = 0;
    asciitext->widthlen = 1;
    asciitext->justification = ENUM_LEFT;

    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {
	
      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading AsciiText", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading AsciiText", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_OPEN_CURLY:
	break;
	
      case TOKEN_WORD:
	Vrml_free_token(field);
	
      default:
	Tcl_AppendResult(interp, argv, ": bad AsciiText format", (char *) NULL);
	return (Node *) -1;
    }
    
    /* parse all fields until close curly bracket */
    while (1) {
	
	switch(Vrml_get_token(channel, &field)) {
	    
	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading AsciiText", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading AsciiText", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_CLOSE_CURLY:
	    return node;
	    
	  case TOKEN_WORD:
	    break;
	    
	  default:
	    Tcl_AppendResult(interp, argv, ": bad AsciiText format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "string")) {
	    if (asciitext->string) {
		for (i = 0; i < asciitext->stringlen; i++) {
		    Vrml_free_token(asciitext->string[i]);
		}
		(void) ckfree((void *) asciitext->string);
		asciitext->string = NULL;
		asciitext->stringlen = 0;
	    }
	    if (Vrml_read_MFString(interp, channel, argv, &asciitext->string, &asciitext->stringlen) != TCL_OK) {
		goto err;
	    }
	}
	else if (!strcmp(field, "spacing")) {
	    if (Vrml_read_SFFloat(interp, channel, argv, &asciitext->spacing, NULL, NULL) != TCL_OK) {
		goto err;
	    }
	}
	else if (!strcmp(field, "width")) {
	    if (asciitext->width) {
		(void) ckfree((void *) asciitext->width);
		asciitext->width = NULL;
		asciitext->widthlen = 0;
	    }
	    
	    if (Vrml_read_MFFloat(interp, channel, argv, &asciitext->width, &asciitext->widthlen) != TCL_OK) {
		goto err;
	    }
	    
	    for (i = 0; i < asciitext->widthlen; i++) {
		if (asciitext->width[i] < 0) {
		    Tcl_AppendResult(interp, argv, ": negative AsciiText width", (char *) NULL);
		    goto err;
		}
	    }
	}
	else if (!strcmp(field, "justification")) {
	    if (Vrml_read_SFEnum(interp, channel, argv, (unsigned long) (ENUM_LEFT | ENUM_CENTER | ENUM_RIGHT), &asciitext->justification) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad AsciiText field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }
    
  err:
    Vrml_free_token(field);
    Vrml_free_AsciiText(node);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_free_AsciiText
 *
 * Free an AsciiText node.
 *
 * fields:	string		""	MFString
 *		spacing		1	SFFloat
 *		justification	LEFT	SFEnum
 *		width		0	MFFloat
 *
 * justification:	LEFT, CENTER, RIGHT
 *
 *******************************************************************************/

void
Vrml_free_AsciiText(node)
     Node *node;
{
    int i;
    NodeAsciiText *asciitext;
    
    asciitext = &node->node.asciiText;
    for (i = 0; i < asciitext->stringlen; i++) {
	Vrml_free_token(asciitext->string[i]);
    }
    (void) ckfree((void *) asciitext->string);
    
    if (asciitext->width) (void) ckfree((void *) asciitext->width);
}


/********************************************************************************
 *
 * Vrml_render_AsciiText
 *
 * Render an AsciiText node.
 *
 * fields:	string		""	MFString
 *		spacing		1	SFFloat
 *		justification	LEFT	SFEnum
 *		width		0	MFFloat
 *
 * justification:	LEFT, CENTER, RIGHT
 *
 *******************************************************************************/

int
Vrml_render_AsciiText(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    node->objects = state->objects;
    state->objects = node;

    return 0;
}
