/********************************************************************************
 *
 * coordinate3.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_Coordinate3
 *
 * Read in a Coordinate3 node.
 *
 * fields:	point		0 0 0	MFVec3f
 *
 *******************************************************************************/

Node *
Vrml_read_Coordinate3(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node, **inlines, **textures;
     Node **names;
{
    char *field;
    NodeCoordinate3 *coord;

    coord = &node->node.coordinate3;
    coord->point = (SFVec3f *) ckalloc(sizeof(SFVec3f));
    coord->point->v[0] = coord->point->v[1] = coord->point->v[2] = 0;
    coord->pointlen = 1;
    
    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {
	
      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading Coordinate3", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading Coordinate3", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_OPEN_CURLY:
	break;
	
      case TOKEN_WORD:
	Vrml_free_token(field);
	
      default:
	Tcl_AppendResult(interp, argv, ": bad Coordinate3 format", (char *) NULL);
	return (Node *) -1;
    }

    /* parse all fields until close curly bracket */
    while (1) {
	
	switch(Vrml_get_token(channel, &field)) {
	    
	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading Coordinate3", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading Coordinate3", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_CLOSE_CURLY:
	    return node;
	    
	  case TOKEN_WORD:
	    break;
	    
	  default:
	    Tcl_AppendResult(interp, argv, ": bad Coordinate3 format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "point")) {
	    if (coord->point) {
		(void) ckfree((void *) coord->point);
		coord->point = NULL;
		coord->pointlen = 0;
	    }
	    if (Vrml_read_MFVec3f(interp, channel, argv, &coord->point, &coord->pointlen) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad Coordinate3 field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }
    
  err:
    Vrml_free_token(field);
    Vrml_free_Coordinate3(node);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_free_Coordinate3
 *
 * Free a Coordinate3 node.
 *
 * fields:	point		0 0 0	MFVec3f
 *
 *******************************************************************************/

void
Vrml_free_Coordinate3(node)
     Node *node;
{
    NodeCoordinate3 *coord;

    coord = &node->node.coordinate3;
    
    if (coord->point) (void) ckfree((void *) coord->point);
}


/********************************************************************************
 *
 * Vrml_render_Coordinate3
 *
 * Render a Coordinate3 node.
 *
 * fields:	point		0 0 0	MFVec3f
 *
 *******************************************************************************/

int
Vrml_render_Coordinate3(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    state->surface->coord3 = node->node.coordinate3.point;
    state->surface->coord3len = node->node.coordinate3.pointlen;

    return 0;
}
