/********************************************************************************
 *
 * fontstyle.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_FontStyle
 *
 * Read in a FontStyle node.
 *
 * fields:	family		SERIF	SFEnum
 *		size		10	SFFloat
 *		style		NONE	SFBitMask
 *
 * family:	SERIF, SANS, TYPEWRITER
 *
 *******************************************************************************/

Node *
Vrml_read_FontStyle(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    char *field;
    NodeFontStyle *font;

    font = &node->node.fontStyle;
    font->style = MASK_NONE;
    font->size = 10;
    font->family = ENUM_SERIF;
    
    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {
	
      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading FontStyle", (char *) NULL);
	return (Node *) -1;

      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading FontStyle", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_OPEN_CURLY:
	break;
	
      case TOKEN_WORD:
	Vrml_free_token(field);
	
      default:
	Tcl_AppendResult(interp, argv, ": bad FontStyle format", (char *) NULL);
	return (Node *) -1;
    }
    
    /* parse all fields until close curly bracket */
    while (1) {
	
	switch(Vrml_get_token(channel, &field)) {
	    
	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading FontStyle", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading FontStyle", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_CLOSE_CURLY:
	    return node;

	  case TOKEN_WORD:
	    break;
	    
	  default:
	    Tcl_AppendResult(interp, argv, ": bad FontStyle format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "size")) {
	    if (Vrml_read_SFFloat(interp, channel, argv, &font->size, NULL, NULL) != TCL_OK) {
		goto err;
	    }
	    if (font->size < 1) {
		Tcl_AppendResult(interp, argv, ": FontStyle size must be positive", (char *) NULL);
		goto err;
	    }
	}
	else if (!strcmp(field, "family")) {
	    if (Vrml_read_SFEnum(interp, channel, argv, (unsigned long) (ENUM_SERIF | ENUM_SANS | ENUM_TYPEWRITER), &font->family) != TCL_OK) {
		goto err;
	    }
	}
	else if (!strcmp(field, "style")) {
	    if (Vrml_read_SFBitMask(interp, channel, argv, (unsigned int) (MASK_NONE | MASK_BOLD | MASK_ITALIC), &font->style) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad FontStyle field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }
    
  err:
    Vrml_free_token(field);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_render_FontStyle
 *
 * Render a FontStyle node.
 *
 * fields:	family		SERIF	SFEnum
 *		size		10	SFFloat
 *		style		NONE	SFBitMask
 *
 * family:	SERIF, SANS, TYPEWRITER
 *
 *******************************************************************************/

int
Vrml_render_FontStyle(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    return 0;
}
