/********************************************************************************
 *
 * info.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_Info
 *
 * Read in an Info node.
 *
 * fields:	string		""	MFString
 *
 *******************************************************************************/

Node *
Vrml_read_Info(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node, **inlines, **textures;
     Node **names;
{
    int i;
    char *field;
    NodeInfo *info;

    info = &node->node.info;
    info->string = NULL;
    info->stringlen = 0;
    
    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {

      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading Info", (char *) NULL);
	return (Node *) -1;

      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading Info", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_OPEN_CURLY:
	break;

      case TOKEN_WORD:
	Vrml_free_token(field);
	
      default:
	Tcl_AppendResult(interp, argv, ": bad Info format", (char *) NULL);
	return (Node *) -1;
    }
    
    /* parse all fields until close curly bracket */
    while (1) {
	
	switch(Vrml_get_token(channel, &field)) {
	    
	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading Info", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading Info", (char *) NULL);
	    return (Node *) -1;

	  case TOKEN_CLOSE_CURLY:
	    return node;
	    
	  case TOKEN_WORD:
	    break;

	  default:
	    Tcl_AppendResult(interp, argv, ": bad Info format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "string")) {
	    if (info->string) {
		for (i = 0; i < info->stringlen; i++) {
		    Vrml_free_token(info->string[i]);
		}
		(void) ckfree((void *) info->string);
		info->string = NULL;
		info->stringlen = 0;
	    }
	    if (Vrml_read_MFString(interp, channel, argv, &info->string, &info->stringlen) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad Info field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }
    
  err:
    Vrml_free_token(field);
    Vrml_free_Info(node);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_free_Info
 *
 * Free an Info node.
 *
 * fields:	string		""	MFString
 *
 *******************************************************************************/

void
Vrml_free_Info(node)
     Node *node;
{
    int i;
    NodeInfo *info;
    
    info = &node->node.info;
    if (info->string) {
	for (i = 0; i < info->stringlen; i++) {
	    Vrml_free_token(info->string[i]);
	}
	(void) ckfree((void *) info->string);
    }
}


/********************************************************************************
 *
 * Vrml_render_Info
 *
 * Render an Info node.
 *
 * fields:	string		""	MFString
 *
 *******************************************************************************/

int
Vrml_render_Info(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    node->infos = state->infos;
    state->infos = node;

    return 0;
}
