/********************************************************************************
 *
 * materialbinding.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_MaterialBinding
 *
 * Read in a MaterialBinding node.
 *
 * fields:	value		DEFAULT		SFEnum
 *
 * value:	DEFAULT, OVERALL, PER_PART, PER_PART_INDEXED,
 *		PER_FACE, PER_FACE_INDEXED, PER_VERTEX, PER_VERTEX_INDEXED
 *
 *******************************************************************************/

Node *
Vrml_read_MaterialBinding(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    char *field;
    unsigned long legal;
    NodeMaterialBinding *binding;

    binding = &node->node.materialBinding;
    binding->value = ENUM_DEFAULT;

    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {
	
      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading MaterialBinding", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading MaterialBinding", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_OPEN_CURLY:
	break;
	
      case TOKEN_WORD:
	Vrml_free_token(field);
	
      default:
	Tcl_AppendResult(interp, argv, ": bad MaterialBinding format", (char *) NULL);
	return (Node *) -1;
    }
    
    /* parse all fields until close curly bracket */
    while (1) {

	switch(Vrml_get_token(channel, &field)) {
	    
	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading MaterialBinding", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading MaterialBinding", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_CLOSE_CURLY:
	    return node;

	  case TOKEN_WORD:
	    break;
	    
	  default:
	    Tcl_AppendResult(interp, argv, ": bad MaterialBinding format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "value")) {
	    legal = ENUM_DEFAULT | ENUM_OVERALL | ENUM_PER_PART | ENUM_PER_PART_INDEXED |
		    ENUM_PER_FACE | ENUM_PER_FACE_INDEXED | ENUM_PER_VERTEX | ENUM_PER_VERTEX_INDEXED;
	    if (Vrml_read_SFEnum(interp, channel, argv, legal, &binding->value) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad MaterialBinding field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }
    
  err:
    Vrml_free_token(field);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_render_MaterialBinding
 *
 * Render a MaterialBinding node.
 *
 * fields:	value		DEFAULT		SFEnum
 *
 * value:	DEFAULT, OVERALL, PER_PART, PER_PART_INDEXED,
 *		PER_FACE, PER_FACE_INDEXED, PER_VERTEX, PER_VERTEX_INDEXED
 *
 *******************************************************************************/

int
Vrml_render_MaterialBinding(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    state->surface->materialBinding = node->node.materialBinding.value;

    return 0;
}
