/********************************************************************************
 *
 * matrixtransform.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_MatrixTransform
 *
 * Read in a MatrixTransform node.
 *
 * fields:	matrix		1 0 0 0		SFMatrix
 *				0 1 0 0
 *				0 0 1 0
 *				0 0 0 1
 *
 *******************************************************************************/

Node *
Vrml_read_MatrixTransform(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    int row, col;
    char *field;
    NodeMatrixTransform *mat;

    mat = &node->node.matrixTransform;
    for (row = 0; row < 4; row++) {
	for (col = 0; col < 4; col++) {
	    mat->matrix[row][col] = (row == col);
	}
    }
    
    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {
	
      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading MatrixTransform", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading MatrixTransform", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_OPEN_CURLY:
	break;

      case TOKEN_WORD:
	Vrml_free_token(field);
	
      default:
	Tcl_AppendResult(interp, argv, ": bad MatrixTransform format", (char *) NULL);
	return (Node *) -1;
    }

    /* parse all fields until close curly bracket */
    while (1) {

	switch(Vrml_get_token(channel, &field)) {

	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading MatrixTransform", (char *) NULL);
	    return (Node *) -1;

	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading MatrixTransform", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_CLOSE_CURLY:
	    return node;
	    
	  case TOKEN_WORD:
	    break;
	    
	  default:
	    Tcl_AppendResult(interp, argv, ": bad MatrixTransform format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "matrix")) {
	    if (Vrml_read_SFMatrix(interp, channel, argv, mat->matrix) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad MatrixTransform field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }
    
  err:
    Vrml_free_token(field);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_render_MatrixTransform
 *
 * Render a MatrixTransform node.
 *
 * fields:	matrix		1 0 0 0		SFMatrix
 *				0 1 0 0
 *				0 0 1 0
 *				0 0 0 1
 *
 *******************************************************************************/

int
Vrml_render_MatrixTransform(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    int i, j, k;
    float gsum, lsum;
    float (*c)[4], (*d)[4], (*m)[4];
    float r[4][4], s[4][4];

    c = state->transform->global;
    d = state->transform->local;
    m = node->node.matrixTransform.matrix;

    /* multiply c into m */
    for (i = 0; i < 4; i++) {
	for (j = 0; j < 4; j++) {
	    gsum = lsum = 0;
	    for (k = 0; k < 4; k++) {
		gsum += c[i][k] * m[k][j];
		lsum += d[i][k] * m[k][j];
	    }
	    r[i][j] = gsum;
	    s[i][j] = lsum;
	}
    }

    /* copy r back to c */
    for (i = 0; i < 4; i++) {
	for (j = 0; j < 4; j++) {
	    c[i][j] = r[i][j];
	    d[i][j] = s[i][j];
	}
    }

    return 0;
}
