/********************************************************************************
 *
 * normal.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_Normal
 *
 * Read in a Normal node.
 *
 * fields:	vector		0 0 0	MFVec3f
 *
 *******************************************************************************/

Node *
Vrml_read_Normal(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    char *field;
    NodeNormal *normal;

    normal = &node->node.normal;
    normal->vector = (SFVec3f *) ckalloc(sizeof(SFVec3f));
    normal->vector->v[0] = normal->vector->v[1] = normal->vector->v[2] = 0;
    normal->vectorlen = 1;

    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {

      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading Normal", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading Normal", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_OPEN_CURLY:
	break;
	
      case TOKEN_WORD:
	Vrml_free_token(field);

      default:
	Tcl_AppendResult(interp, argv, ": bad Normal format", (char *) NULL);
	return (Node *) -1;
    }

    /* parse all fields until close curly bracket */
    while (1) {

	switch(Vrml_get_token(channel, &field)) {

	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading Normal", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading Normal", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_CLOSE_CURLY:
	    return node;

	  case TOKEN_WORD:
	    break;
	    
	  default:
	    Tcl_AppendResult(interp, argv, ": bad Normal format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "vector")) {
	    if (normal->vector) {
		(void) ckfree((void *) normal->vector);
		normal->vector = NULL;
		normal->vectorlen = 0;
	    }
	    if (Vrml_read_MFVec3f(interp, channel, argv, &normal->vector, &normal->vectorlen) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad Normal field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }

  err:
    Vrml_free_token(field);
    Vrml_free_Normal(node);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_free_Normal
 *
 * Free a Normal node.
 *
 * fields:	vector		0 0 0	MFVec3f
 *
 *******************************************************************************/

void
Vrml_free_Normal(node)
     Node *node;
{
    NodeNormal *normal;
    
    normal = &node->node.normal;
    
    if (normal->vector) (void) ckfree((void *) normal->vector);
}


/********************************************************************************
 *
 * Vrml_render_Normal
 *
 * Render a Normal node.
 *
 * fields:	vector		0 0 0	MFVec3f
 *
 *******************************************************************************/

int
Vrml_render_Normal(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    state->surface->normal = node->node.normal.vector;
    state->surface->normallen = node->node.normal.vectorlen;

    return 0;
}
