/********************************************************************************
 *
 * rotation.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_Rotation
 *
 * Vrml_Read in a Rotation node.
 *
 * fields:	rotation	0 0 1 0		SFRotation
 *
 *******************************************************************************/

Node *
Vrml_read_Rotation(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    char *field;
    NodeRotation *rot;

    rot = &node->node.rotation;
    rot->rotation[0] = rot->rotation[1] = rot->rotation[3] = 0;
    rot->rotation[2] = 1;

    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {

      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while Vrml_reading Rotation", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while Vrml_reading Rotation", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_OPEN_CURLY:
	break;
	
      case TOKEN_WORD:
	Vrml_free_token(field);

      default:
	Tcl_AppendResult(interp, argv, ": bad Rotation format", (char *) NULL);
	return (Node *) -1;
    }

    /* parse all fields until close curly bracket */
    while (1) {

	switch(Vrml_get_token(channel, &field)) {

	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while Vrml_reading Rotation", (char *) NULL);
	    return (Node *) -1;

	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while Vrml_reading Rotation", (char *) NULL);
	    return (Node *) -1;

	  case TOKEN_CLOSE_CURLY:

	    /* make sure field values are legal */
	    if ((rot->rotation[0] == 0) && (rot->rotation[1] == 0) && (rot->rotation[2] == 0)) {
		Tcl_AppendResult(interp, argv, ": null rotation axis specified for Rotation node", (char *) NULL);
		goto err;
	    }
	    return node;
	    
	  case TOKEN_WORD:
	    break;

	  default:
	    Tcl_AppendResult(interp, argv, ": bad Rotation format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "rotation")) {
	    if (Vrml_read_SFRotation(interp, channel, argv, rot->rotation) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad Rotation field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }
    
  err:
    Vrml_free_token(field);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_render_Rotation
 *
 * Render a Rotation node.
 *
 * fields:	rotation	0 0 1 0		SFRotation
 *
 *******************************************************************************/

int
Vrml_render_Rotation(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    Vrml_apply_rotation(state, node->node.rotation.rotation);
    return 0;
}
