/********************************************************************************
 *
 * scale.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_Scale
 *
 * Read in a Scale node.
 *
 * fields:	scaleFactor	1 1 1	SFVec3f
 *
 *******************************************************************************/

Node *
Vrml_read_Scale(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    char *field;
    NodeScale *scale;

    scale = &node->node.scale;
    scale->scaleFactor.v[0] = scale->scaleFactor.v[1] = scale->scaleFactor.v[2] = 1;

    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {

      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading Scale", (char *) NULL);
	return (Node *) -1;

      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading Scale", (char *) NULL);
	return (Node *) -1;

      case TOKEN_OPEN_CURLY:
	break;

      case TOKEN_WORD:
	Vrml_free_token(field);

      default:
	Tcl_AppendResult(interp, argv, ": bad Scale format", (char *) NULL);
	return (Node *) -1;
    }
    
    /* parse all fields until close curly bracket */
    while (1) {

	switch(Vrml_get_token(channel, &field)) {

	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading Scale", (char *) NULL);
	    return (Node *) -1;

	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading Scale", (char *) NULL);
	    return (Node *) -1;

	  case TOKEN_CLOSE_CURLY:
	    return node;

	  case TOKEN_WORD:
	    break;

	  default:
	    Tcl_AppendResult(interp, argv, ": bad Scale format", (char *) NULL);
	    return (Node *) -1;
	}

	if (!strcmp(field, "scaleFactor")) {
	    if (Vrml_read_SFVec3f(interp, channel, argv, &scale->scaleFactor, NULL, NULL) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad Scale field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }

  err:
    Vrml_free_token(field);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_render_Scale
 *
 * Render a Scale node.
 *
 * fields:	scaleFactor	1 1 1	SFVec3f
 *
 *******************************************************************************/

int
Vrml_render_Scale(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    Vrml_apply_scale(state, &node->node.scale.scaleFactor);
    return 0;
}
