/********************************************************************************
 *
 * script.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_Script
 *
 * Read in a Script node.
 *
 * fields:	language	""	SFString
 *		script		""	SFString
 *
 *******************************************************************************/

Node *
Vrml_read_Script(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node, **inlines, **textures;
     Node **names;
{
    char *field;
    NodeScript *script;

    script = &node->node.script;
    script->script = NULL;
    script->language = NULL;
    
    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {

      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading Script", (char *) NULL);
	return (Node *) -1;

      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading Script", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_OPEN_CURLY:
	break;

      case TOKEN_WORD:
	Vrml_free_token(field);
	
      default:
	Tcl_AppendResult(interp, argv, ": bad Script format", (char *) NULL);
	return (Node *) -1;
    }
    
    /* parse all fields until close curly bracket */
    while (1) {
	
	switch(Vrml_get_token(channel, &field)) {
	    
	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading Script", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading Script", (char *) NULL);
	    return (Node *) -1;

	  case TOKEN_CLOSE_CURLY:
	    return node;
	    
	  case TOKEN_WORD:
	    break;

	  default:
	    Tcl_AppendResult(interp, argv, ": bad Script format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "script")) {
	    if (script->script) {
		Vrml_free_token(script->script);
		script->script = NULL;
	    }
	    if (Vrml_read_SFString(interp, channel, argv, &script->script, NULL, NULL) != TCL_OK) {
		goto err;
	    }
	}
	else if (!strcmp(field, "language")) {
	    if (script->language) {
		Vrml_free_token(script->language);
		script->language = NULL;
	    }
	    if (Vrml_read_SFString(interp, channel, argv, &script->language, NULL, NULL) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad Script field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }
    
  err:
    Vrml_free_token(field);
    Vrml_free_Script(node);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_free_Script
 *
 * Free a Script node.
 *
 * fields:	language	""	SFString
 *		script		""	SFString
 *
 *******************************************************************************/

void
Vrml_free_Script(node)
     Node *node;
{
    NodeScript *script;
    
    script = &node->node.script;
    if (script->language) {
	Vrml_free_token(script->language);
    }
    if (script->script) {
	Vrml_free_token(script->script);
    }
}


/********************************************************************************
 *
 * Vrml_render_Script
 *
 * Render a Script node.
 *
 * fields:	language	""	SFString
 *		script		""	SFString
 *
 *******************************************************************************/

int
Vrml_render_Script(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    node->scripts = state->scripts;
    state->scripts = node;

    return 0;
}
