/********************************************************************************
 *
 * fontstyle.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_ShapeHints
 *
 * Read in a ShapeHints node.
 *
 * fields:	vertexOrdering	UNKNOWN_ORDERING	SFEnum
 *		shapeType	UNKNOWN_SHAPE_TYPE	SFEnum
 *		faceType	CONVEX			SFEnum
 *		creaseAngle	0.5			SFFloat
 *
 * vertexOrdering:	UNKNOWN_ORDERING, CLOCKWISE, COUNTERCLOCKWISE
 * shapeType:		UNKNOWN_SHAPE_TYPE, SOLID
 * faceType:		UNKNOWN_FACE_TYPE, CONVEX
 *
 *******************************************************************************/

Node *
Vrml_read_ShapeHints(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    char *field;
    NodeShapeHints *hint;

    hint = &node->node.shapeHints;
    hint->vertexOrdering = ENUM_UNKNOWN_ORDERING;
    hint->shapeType = ENUM_UNKNOWN_SHAPE_TYPE;
    hint->faceType = ENUM_CONVEX;
    hint->creaseAngle = 0.5;

    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {
	
      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading ShapeHints", (char *) NULL);
	return (Node *) -1;
	
      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading ShapeHints", (char *) NULL);
	return (Node *) -1;

      case TOKEN_OPEN_CURLY:
	break;

      case TOKEN_WORD:
	Vrml_free_token(field);

      default:
	Tcl_AppendResult(interp, argv, ": bad ShapeHints format", (char *) NULL);
	return (Node *) -1;
    }

    /* parse all fields until close curly bracket */
    while (1) {

	switch(Vrml_get_token(channel, &field)) {

	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading ShapeHints", (char *) NULL);
	    return (Node *) -1;

	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading ShapeHints", (char *) NULL);
	    return (Node *) -1;

	  case TOKEN_CLOSE_CURLY:
	    return node;

	  case TOKEN_WORD:
	    break;

	  default:
	    Tcl_AppendResult(interp, argv, ": bad ShapeHints format", (char *) NULL);
	    return (Node *) -1;
	}

	if (!strcmp(field, "creaseAngle")) {
	    if (Vrml_read_SFFloat(interp, channel, argv, &hint->creaseAngle, NULL, NULL) != TCL_OK) {
		goto err;
	    }
	    if (hint->creaseAngle < 0) {
		Tcl_AppendResult(interp, argv, ": negative ShapeHints creaseAngle", (char *) NULL);
		goto err;
	    }
	}
	else if (!strcmp(field, "vertexOrdering")) {
	    if (Vrml_read_SFEnum(interp, channel, argv, (unsigned long) (ENUM_UNKNOWN_ORDERING |
							      ENUM_CLOCKWISE |
							      ENUM_COUNTERCLOCKWISE),
			    &hint->vertexOrdering) != TCL_OK) {
		goto err;
	    }
	}
	else if (!strcmp(field, "shapeType")) {
	    if (Vrml_read_SFEnum(interp, channel, argv, (unsigned long) (ENUM_UNKNOWN_SHAPE_TYPE |
							      ENUM_SOLID),
			    &hint->shapeType) != TCL_OK) {
		goto err;
	    }
	}
	else if (!strcmp(field, "faceType")) {
	    if (Vrml_read_SFEnum(interp, channel, argv, (unsigned long) (ENUM_UNKNOWN_FACE_TYPE |
							      ENUM_CONVEX),
			    &hint->faceType) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad ShapeHints field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
  }

  err:
    Vrml_free_token(field);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_render_ShapeHints
 *
 * Render a ShapeHints node.
 *
 * fields:	vertexOrdering	UNKNOWN_ORDERING	SFEnum
 *		shapeType	UNKNOWN_SHAPE_TYPE	SFEnum
 *		faceType	CONVEX			SFEnum
 *		creaseAngle	0.5			SFFloat
 *
 * vertexOrdering:	UNKNOWN_ORDERING, CLOCKWISE, COUNTERCLOCKWISE
 * shapeType:		UNKNOWN_SHAPE_TYPE, SOLID
 * faceType:		UNKNOWN_FACE_TYPE, CONVEX
 *
  *******************************************************************************/

int
Vrml_render_ShapeHints(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    NodeShapeHints *hints = &node->node.shapeHints;
    SurfaceProperties *s = state->surface;

    s->vertexOrdering = hints->vertexOrdering;
    s->shapeType = hints->shapeType;
    s->faceType = hints->faceType;
    
    return 0;
}
