/*
 * sm.h
 *
 */

#if !defined(_SM_INT_)
	#define	_SM_INT_
#endif


/****************************************************************************************************/
/*                                                                                                  */
/* Constant definitions                                                                             */
/*                                                                                                  */
/****************************************************************************************************/

#define	SM_VERSION		"1.3"

#define	SM_TYPE_POINT		0
#define	SM_TYPE_LINE		1
#define	SM_TYPE_POLYGON		10
#define	SM_TYPE_SPHERE		11
#define	SM_TYPE_DISK		12
#define	SM_TYPE_PARTDISK	13
#define	SM_TYPE_CYLINDER	14

#define	SM_PORT_VRP		0
#define SM_PORT_VPN		1
#define	SM_PORT_VUP		2
#define	SM_PORT_PRP		3

#define SM_PORT_PARALLEL	0
#define SM_PORT_PERSPECTIVE	1

#define	SM_MODEL_FWD		10
#define	SM_MODEL_UP		11
#define	SM_MODEL_POS		12
#define	SM_MODEL_EMISSIVE	13
#define	SM_MODEL_AMBIENT	14
#define	SM_MODEL_DIFFUSE	15
#define	SM_MODEL_SPECULAR	16
#define	SM_MODEL_BF_EMISSIVE	17
#define	SM_MODEL_BF_AMBIENT	18
#define	SM_MODEL_BF_DIFFUSE	19
#define	SM_MODEL_BF_SPECULAR	20

#define	SM_MODEL_UPDATE_NORMALS		1
#define	SM_MODEL_UPDATE_POSITION	2
#define	SM_MODEL_UPDATE_AMBIENT		4
#define	SM_MODEL_UPDATE_DIFFUSE		8
#define	SM_MODEL_UPDATE_EMISSIVE	16
#define	SM_MODEL_UPDATE_BF_AMBIENT	64
#define	SM_MODEL_UPDATE_BF_DIFFUSE	128
#define	SM_MODEL_UPDATE_BF_EMISSIVE	256
#define	SM_MODEL_UPDATE_TEXTURES	1024
#define	SM_MODEL_UPDATE_MATERIALS	2048
#define	SM_MODEL_UPDATE_WIDTHS		4096
#define	SM_MODEL_UPDATE_STIPPLES	8192
#define	SM_MODEL_UPDATE_SIZES		16384
#define	SM_MODEL_UPDATE_BBOX		32768

#define	SM_VERTEX_NORMAL_DEFAULT	0
#define	SM_VERTEX_NORMAL_USER		1

#define	SM_LIGHT_SOURCE_0		0
#define	SM_LIGHT_SOURCE_1		1
#define	SM_LIGHT_SOURCE_2		2
#define	SM_LIGHT_SOURCE_3		3
#define	SM_LIGHT_SOURCE_4		4
#define	SM_LIGHT_SOURCE_5		5
#define	SM_LIGHT_SOURCE_6		6
#define	SM_LIGHT_SOURCE_7		7

#define	SM_HINT_FOG			0
#define	SM_HINT_PERSPECTIVE		1


/****************************************************************************************************/
/*                                                                                                  */
/* Types and Structure definitions                                                                  */
/*                                                                                                  */
/****************************************************************************************************/


#ifdef USE_DOUBLE
typedef double DOUBLE;
#else
typedef float DOUBLE;
#endif


typedef struct DepthCue {
    int		on;
    int		mode;			/* depth-cue mode */
    float	RGBA[4];		/* depth-cue background color */
    DOUBLE	start, end, density;	/* depth-cue parameters */
} DepthCue;


typedef struct SpecularReflection {
    float	RGBA[4];		/* specular RGBA */
    DOUBLE	exponent;		/* specular exponent */
} SpecularReflection;


typedef struct LightSource {
    int		on;			/* whether this light source exists */
    float	ambientRGBA[4];		/* ambient color */
    float	diffuseRGBA[4];		/* diffuse color */
    float	specularRGBA[4];	/* specular color */
    float	position[4];		/* position of light */
    float	direction[3];		/* direction of spotlight */
    float	ndirection[3];		/* normalized direction of spotlight */
    float	exponent;		/* spotlight exponent */
    float	cutoff;			/* spotlight cut-off */
    float	attenuation[3];		/* attenuation factors */
    struct Model *model;		/* model associated with the light source */
} LightSource;


typedef struct Material {
    float		ambientRGBA[4];
    float		diffuseRGBA[4];
    float		specularRGBA[4];
    float		emissiveRGBA[4];
    double		shininess;
} Material;


typedef struct Normal3D {		/* three-dimensional normal vector */
    DOUBLE	v[3];
} Normal3D;


typedef struct TexCoords {		/* s-t texture coordinates */
    DOUBLE	v[2];
} TexCoords;


typedef struct Vertex {
    DOUBLE		lv[3];		/* local coordinates */
    struct Normal3D	lvn;		/* vertex normal in local coordinates system */
} Vertex;


typedef struct Surface {
    int			id;		/* surface id */
    int			vcnt;		/* number of vertices */
    int			*index;		/* pointer to array of vertex indices */
    int			normal;		/* vertex normal flag */

    double		lineWidth;	/* line width */
    int			lineStipple;	/* line stipple */
    int			lineFactor;	/* line stipple factor */

    int			defaultWidth;
    int			defaultStipple;

    double		pointSize;	/* point size */

    GLint		component;	/* texture component selected */
    GLenum		func;		/* texture mapping function */
    GLfloat		texColor[4];	/* RGBA color used in blending */
    GLenum		smode;		/* wrap mode for s coordinate */
    GLenum		tmode;		/* wrap mode for t coordinate */
    GLenum		magFilter;	/* magnification filter */
    GLenum		minFilter;	/* minification filter */
    GLfloat		bdColor[4];	/* border color */
    struct Texture	*texture;	/* pointer to texture map */

    DOUBLE		ln[3];		/* surface normal in local coordinates system */
    struct Model	*model;		/* model that owns this surface */
    struct Material	*materials;	/* pointer to array of material records */
    struct Normal3D	*lvn;		/* pointer to array of vertex normals in local coordinates system */
    struct TexCoords	*texcoords;	/* pointer to array of texture coordinates */
} Surface;


typedef struct Model {
    struct Model	*next;			/* pointer to next model */
    struct Model	*parent;		/* pointer to parent model */
    struct Model	*child;			/* pointer to a child model */
    struct Model	*sibling;		/* pointer to a sibling model */
    struct Cell		*cell;			/* pointer to model cell */
    Tcl_HashEntry	*e;			/* this model's entry in the cell's hash table */

    GLuint		pickname;		/* name assigned to the model during picking */

    int			type;			/* model type */
    int			updateFlag;		/* misc. update flags */

    char		*label;	        	/* name of the model */
    int			invalid;		/* whether the model's geometric specs are valid */
    int			shading;		/* shading method */
    int			ccw;			/* counter-clockwise front-facing mode */

    int			visible;		/* whether the model should be visible */

    /* bounding box */
    int			empty;
    DOUBLE		x0, y0, z0;
    DOUBLE		x1, y1, z1;

    /* position and orientation vectors */
    DOUBLE		fwd[3];			/* forward vector */
    DOUBLE		up[3];			/* up vector */
    DOUBLE		pos[3];			/* position vector */
    DOUBLE		modelT[16];		/* model transform matrix */

    /* color and material properties */
    XColor		*color;			/* model's frontface color */
    XColor		*bfcolor;		/* model's backface color */

    DOUBLE		emissive[3];		/* emission coefficients */
    DOUBLE		ambient[3];		/* ambience coefficients */
    DOUBLE		diffuse[3];		/* diffuse coefficients */
    SpecularReflection	specular;		/* specular parameters */

    float		emissiveRGBA[4];	/* color of model modulated by emission coefficients */
    float		ambientRGBA[4];		/* color of model modulated by ambient coefficients */
    float		diffuseRGBA[4];		/* color of model modulated by diffuse coefficients */

    DOUBLE		bfemissive[3];		/* backface emission coefficients */
    DOUBLE		bfambient[3];		/* backface ambience coefficients */
    DOUBLE		bfdiffuse[3];		/* backface diffuse coefficients */
    SpecularReflection	bfspecular;		/* backface specular parameters */

    float		bfemissiveRGBA[4];	/* color of model modulated by backface emission coefficients */
    float		bfambientRGBA[4];	/* color of model modulated by backface ambient coefficients */
    float		bfdiffuseRGBA[4];	/* color of model modulated by backface diffuse coefficients */

    /* polygon, line, point parameters */
    int			nv;			/* number of vertices */
    int			ns;			/* number of surfaces */
    Vertex		*v;			/* pointer to array of vertices */
    Surface		*s;			/* pointer to array of surfaces */
    char		*normals;		/* user-specified vertex normals */
    char		*materials;		/* user-specified vertex material */
    char		*textures;		/* user-specified surface texture maps */

    /* polygon parameters */
    int			useAverage;		/* whether vertex normals should be based on surface normal averages */
    int			useTexture;		/* whether texture is enabled for this model */
    GLenum		cull;			/* whether backface culling should be enabled */
    GLenum		frontmode;		/* drawing mode for front-facing polygons */
    GLenum		backmode;		/* drawing mode for back-facing polygons */
    /* end polygon */

    /* line parameters */
    char		*widths;		/* user-specified line widths */
    char		*stipples;		/* user-specified line stipples */
    double		lineWidth;		/* line width */
    int			lineFactor;
    int			lineStipple;		/* line stipple */
    /* end line */

    /* point parameters */
    char		*sizes;
    double		pointSize;		/* default point size */
    DOUBLE		*pointSizes;		/* per-vertex point sizes */

    /* end point */

    /* quadric parameters */
    GLUquadricObj	*quadric;
    GLenum		quadNormals;		/* desired normals */
    GLenum		orientation;		/* desired inside/outside orientation */
    GLenum		drawStyle;		/* desired draw style */
    double		radius;
    double		baseRadius;
    double		topRadius;
    double		innerRadius;
    double		outerRadius;
    double		startAngle;
    double		sweepAngle;
    double		height;
    int			slices;
    int			loops;
    int			stacks;
    /* end quadric */

} Model;


typedef struct PortItem  {
    Tk_Item		header;			/* Generic stuff that's the same for all
						 * types.  MUST BE FIRST IN STRUCTURE. */
    double		bbox[4];		/* Coordinates of bounding box for viewport
						 * (x1, y1, x2, y2).  Item includes
						 * x1 and x2 but not y1 and y2. */

    int			w, h;			/* viewport width and height */
    int			depth;			/* screen depth */

    int			srcx, srcy;		/* area of viewport actually drawn */
    int			srcw, srch;

    Tk_Window		tkwin;			/* the window that contains the MESA/OpenGL widget */
    Tk_Canvas		canvas;			/* the canvas widget that owns this item */
    Display		*dpy;			/* X display */
    XVisualInfo		*visinfo;		/* Visual Info record */
    Tcl_Command		widgetCmd;		/* Token for viewport's widget command */
    Pixmap		pm;			/* pixmap to draw into */
    GC			pmGC;			/* graphics context for image buffer */
    GLXPixmap		glxpm;			/* Mesa/OpenGL pixmap associated with the X pixmap */
    GLXContext		glxpmGC;		/* graphics context for Mesa/OpenGL */
    XColor		*outlineColor;		/* outline color */
    XColor		*fillColor;		/* fill color */
    GC			outlineGC;		/* graphics context for outline */

    int			initialized;		/* whether this port has been initialized */
    int			redraw;			/* whether image needs to be redrawn */
    int			update;			/* whether image update has been scheduled */
    int			invalid;		/* whether one or more viewport parameters have invalid values */
    int			hsr;			/* whether hidden surface removal should be performed */
    int			doublebuffer;		/* whether this widget is double-buffered */
    int			async;			/* whether updates are done asynchronously */
    int			texture;		/* whether texture mapping is enabled */
    int			picking;		/* whether picking is taking place */
    int			width;			/* width of outline. */
    GLenum		fogHint;		/* hint for fog calculations: GL_NICEST, GL_FASTEST or GL_DONT_CARE */
    GLenum		perspHint;		/* hint for perspective correction: GL_NICEST, GL_FASTEST or GL_DONT_CARE */

    Tcl_Interp		*interp;		/* the TCL interpreter in which this canvas is created */
    double		epsilon;		/* used in computing transformation vectors and in backface culling */

    int			projection;		/* current projection type (0: parallel, 1: perspective) */
    DOUBLE		vrp[3];			/* view reference point (WC) */
    DOUBLE		vpn[3];			/* view plane normal (WC) */
    DOUBLE		vup[3];			/* view up vector (WC) */
    DOUBLE		prp[3];			/* projection reference point (VRC) */

    DOUBLE		mr[16];			/* rotation matrix */
    DOUBLE		msh[16];		/* shear matrix */

    double		minu, maxu;		/* width of projection window */
    double		minv, maxv;		/* height of projection window */

    double		bp;			/* backplane distance (z) for clipping */

    float		ambient[4];		/* ambient RGBA intensities */
    XColor		*ambientLight;		/* ambient light */
    LightSource		lights[8];		/* light sources */

    DepthCue		depthcue;		/* depth cue parameters */

    int			pick[5];		/* pick[0] == 1 */
						/* coordinates (x1, y1) and (x2, y2) describing the pick region */

    int			invertedVisibleMask;	/* whether visible-masking should be reversed */
    char		*visibleMaskStr;	/* configuration value for visibleMask */
    Tcl_HashTable	visibleHash;		/* hash table for looking up visible mask values */

    struct Cell		*cell;			/* pointer to viewport's cell */
    struct PortItem	*next;			/* ointer to next viewport in the cell */
} PortItem;


typedef struct Texture {
    struct Texture	*next;			/* pointer to next texture map */
    int			refCount;		/* reference count */
    char		*label;			/* name of texture map */
    GLsizei		width;			/* map width */
    GLsizei		height;			/* map height */
    GLint		border;			/* map border size */
    void		*data;			/* pointer to pixel data */
} Texture;


typedef struct CurrentTexture {			/* records the current texture	      */
    struct Texture	*texture;		/* associated with a graphics context */
    int			component;
    int			refCount;
} CurrentTexture;


typedef struct Cell {
    char		*label;			/* cell name */
    Model		*models;		/* list of models */
    PortItem		*ports;			/* list of viewports */
    struct Cell		*next;			/* pointer to next cell */
    Tcl_HashTable	hash;			/* hash table for looking up models */
    Tcl_Interp		*interp;		/* cell's TCL interpreter */
    double		epsilon;		/* used in computing surface normals */
} Cell;


typedef struct CellHeader {
    Tcl_HashTable	hash;
    Tcl_HashTable	glxGC;			/* maps openGL GCs with textures */
    Cell		*cells;
    Texture		*textures;		/* list of texture maps */
    unsigned long	id;			/* next id to be assigned to a new texture map */
} CellHeader;
