
#include <stdlib.h>
#include <string.h>
#include <tk.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>

#include "smInt.h"

typedef struct Image {
    Tk_Window tkwin;            /* Window passed to Tk_GetImage (needed to
                                 * "re-get" the image later if the manager
                                 * changes). */
    Display *display;           /* Display for tkwin.  Needed because when
                                 * the image is eventually freed tkwin may
                                 * not exist anymore. */
    struct ImageMaster *masterPtr;
                                /* Master for this image (identifiers image
                                 * manager, for example). */
    ClientData instanceData;
                                /* One word argument to pass to image manager
                                 * when dealing with this image instance. */
    Tk_ImageChangedProc *changeProc;
                                /* Code in widget to call when image changes
                                 * in a way that affects redisplay. */
    ClientData widgetClientData;
                                /* Argument to pass to changeProc. */
    struct Image *nextPtr;      /* Next in list of all image instances
                                 * associated with the same name. */

} Image;

typedef struct ImageMaster {
    Tk_ImageType *typePtr;      /* Information about image type.  NULL means
                                 * that no image manager owns this image:  the
                                 * image was deleted. */
    ClientData masterData;      /* One-word argument to pass to image mgr
                                 * when dealing with the master, as opposed
                                 * to instances. */
    int width, height;          /* Last known dimensions for image. */
    Tcl_HashTable *tablePtr;    /* Pointer to hash table containing image
                                 * (the imageTable field in some TkMainInfo
                                 * structure). */
    Tcl_HashEntry *hPtr;        /* Hash entry in mainPtr->imageTable for
                                 * this structure (used to delete the hash
                                 * entry). */
    Image *instancePtr;         /* Pointer to first in list of instances
                                 * derived from this name. */
} ImageMaster;


typedef struct PhotoMaster {
    Tk_ImageMaster tkMaster;    /* Tk's token for image master.  NULL means
                                 * the image is being deleted. */
    Tcl_Interp *interp;         /* Interpreter associated with the
                                 * application using this image. */
    Tcl_Command imageCmd;       /* Token for image command (used to delete
                                 * it when the image goes away).  NULL means
                                 * the image command has already been
                                 * deleted. */
    int flags;                  /* Sundry flags, defined below. */
    int width, height;          /* Dimensions of image. */
    int userWidth, userHeight;  /* User-declared image dimensions. */
    Tk_Uid palette;             /* User-specified default palette for
                                 * instances of this image. */
    double gamma;               /* Display gamma value to correct for. */
    char *fileString;           /* Name of file to read into image. */
    char *dataString;           /* String value to use as contents of image. */
    char *format;               /* User-specified format of data in image
                                 * file or string value. */
    unsigned char *pix24;       /* Local storage for 24-bit image. */
    int ditherX, ditherY;       /* Location of first incorrectly
                                 * dithered pixel in image. */
    Region validRegion;         /* X region indicating which parts of
                                 * the image have valid image data. */
    void *instancePtr;
                                /* First in the list of instances
                                 * associated with this master. */
} PhotoMaster;



/*
 *--------------------------------------------------------------
 *
 * SmImgCmd --
 *
 * process texture commands.
 *
 * valid commands are:
 *
 *		image startx starty endx endy
 *
 *--------------------------------------------------------------
 */

int
SmImgCmd(clientData, interp, argc, argv)
     ClientData clientData;	/* Main window associated with
				 * interpreter. */
     Tcl_Interp *interp;	/* Current interpreter. */
     int argc;			/* Number of arguments. */
     char **argv;		/* Argument strings. */
{
    int x, y, offset;
    int startx, endx;
    int starty, endy;
    char buf[20];
    Image *imagePtr;
    ImageMaster *masterPtr;
    PhotoMaster *photoMaster;
    unsigned char *pixelPtr, *pixelBasePtr;

    Tk_Window tkwin = (Tk_Window) clientData;

    if (argc != 6) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			 " image startx starty endx endy\"", (char *) NULL);
	return TCL_ERROR;
    }

    if ((Tcl_GetInt(interp, argv[2], &startx) != TCL_OK) ||
	(Tcl_GetInt(interp, argv[3], &starty) != TCL_OK) ||
	(Tcl_GetInt(interp, argv[4], &endx) != TCL_OK) ||
	(Tcl_GetInt(interp, argv[5], &endy) != TCL_OK)) {
	return TCL_ERROR;
    }
    
    if ((endx - startx < 1) || (endy - starty < 1)) {
	Tcl_AppendResult(interp, "negative image region specified", (char *) NULL);
	return TCL_ERROR;
    }

    if ((startx < 0) || (starty < 0)) {
	Tcl_AppendResult(interp, "image boundary must be positive", (char *) NULL);
	return TCL_ERROR;
    }

    if ((imagePtr = (Image *) Tk_GetImage(interp, tkwin, argv[1], NULL, NULL)) == (Image *) NULL) {
	return TCL_ERROR;
    }
    Tk_FreeImage((Tk_Image) imagePtr);
    
    masterPtr = imagePtr->masterPtr;
    if (strcmp(masterPtr->typePtr->name, "photo") != 0) {
	Tcl_AppendResult(interp, "wrong image type: ", masterPtr->typePtr->name, (char *) NULL);
	return TCL_ERROR;
    }
    
    if ((starty > masterPtr->height) || (startx > masterPtr->width) ||
	(endy > masterPtr->height) || (endx > masterPtr->width)) {
	Tcl_AppendResult(interp, "image boundary exceeded", (char *) NULL);
	return TCL_ERROR;
    }
    
    photoMaster = (PhotoMaster *) masterPtr->masterData;
    offset = photoMaster->width * 3;
    pixelBasePtr = photoMaster->pix24 + (starty * masterPtr->width);
    for (y = starty; y < endy; y++) {
	pixelPtr = pixelBasePtr + startx * 3;
	for (x = startx; x < endx; x++) {
	    sprintf(buf, "%d %d %d", *pixelPtr++, *pixelPtr++, *pixelPtr++);
	    Tcl_AppendElement(interp, buf);
	}
	pixelBasePtr += offset;
    }
    return TCL_OK;
}
