/*
 * smtexture.c --
 *
 *	This file implements (single level) texture maps.
 *
 */

#include <stdlib.h>
#include <string.h>
#include <tk.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glx.h>

#include "smInt.h"

typedef struct VisualClasses {
    int	id;
    char *name;
} VisualClasses;

static VisualClasses visualClasses[] = {
    {StaticGray,	"staticgray"},
    {GrayScale,		"grayscale"},
    {StaticColor,	"staticcolor"},
    {PseudoColor,	"pseudocolor"},
    {TrueColor,		"truecolor"},
    {DirectColor,	"directcolor"},
    {-1,		NULL},
};

/*
 * Prototypes for procedures defined externally:
 */

/*
 * Prototypes for procedures defined in this file that are exported:
 */

int		SmInfoCmd _ANSI_ARGS_ ((ClientData clientData, Tcl_Interp *interp, int argc, char **argv));


/*
 *--------------------------------------------------------------
 *
 * SmInfoCmd --
 *
 * process sminfo commands.
 *
 * valid commands are:
 *
 *		version		: return version number
 *		visuals		: return list of valid visuals
 *
 *--------------------------------------------------------------
 */

int
SmInfoCmd(clientData, interp, argc, argv)
     ClientData clientData;	/* Main window associated with
				 * interpreter. */
     Tcl_Interp *interp;	/* Current interpreter. */
     int argc;			/* Number of arguments. */
     char **argv;		/* Argument strings. */
{
    int i, nitems, length, widget, value;
    char c, buffer[128];
    Display *dpy = (Display *) clientData;
    XVisualInfo vinfo, *visinfo, *vis;
    VisualClasses *class;

    if (argc < 2) {
	Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			 " cmd ?options?\"", (char *) NULL);
	return TCL_ERROR;
    }

    c = argv[1][0];
    length = strlen(argv[1]);
    if ((c == 'v') && (strncmp(argv[1], "visuals", length) == 0) && (length >= 2)) {

	/* sminfo visuals */

	if (argc != 3) {
	    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			     " visuals viewport-type\"", (char *) NULL);
	    return TCL_ERROR;
	}

	c = argv[2][0];
	length = strlen(argv[2]);
	if ((c == 'w') && (strncmp(argv[2], "widget", length) == 0) && (length >= 2)) {
	    widget = 1;
	}
	else if ((c == 'c') && (strncmp(argv[2], "canvas", length) == 0) && (length >= 2)) {
	    widget = 0;
	}
	else {
	    Tcl_AppendResult(interp, "bad viewport type \"", argv[2],
			     "\": must be either canvas or widget", (char *) NULL);
	    return TCL_ERROR;
	}

	visinfo = XGetVisualInfo(dpy, (long) 0, &vinfo, &nitems);
	if (visinfo) {
	    for (i = 0, vis = visinfo; i < nitems; i++, vis++) {

		/* USE_GL */
		(void) glXGetConfig(dpy, vis, GLX_USE_GL, &value);
		if (value == False) continue;

		/* RGBA */
		(void) glXGetConfig(dpy, vis, GLX_RGBA, &value);
		if (value == False) continue;

		/* BUFFER_SIZE */
		(void) glXGetConfig(dpy, vis, GLX_BUFFER_SIZE, &value);
		if (value != vis->depth) continue;

		/* DEPTH_SIZE */
		(void) glXGetConfig(dpy, vis, GLX_DEPTH_SIZE, &value);
		if (value < 12) continue;

		/* DOUBLEBUFFER (viewport widgets only) */
		if (widget) {
		    (void) glXGetConfig(dpy, vis, GLX_DOUBLEBUFFER, &value);
		    if (value == False) continue;
		}

		for (class = visualClasses; class->name; class++) {
		    if (class->id == vis->class) break;
		}
		sprintf(buffer, "0x%x %s %d", (unsigned int) vis->visualid, class->name, vis->depth);
		Tcl_AppendElement(interp, buffer);
	    }
	    (void) XFree((char *) visinfo);
	}
	return TCL_OK;
    }
    else if ((c == 'v') && (strncmp(argv[1], "version", length) == 0) && (length >= 2)) {

	/* sminfo version */

	if (argc != 2) {
	    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
			     " version\"", (char *) NULL);
	    return TCL_ERROR;
	}
	strcpy(interp->result, SM_VERSION);
	return TCL_OK;
    }
    else {
	Tcl_AppendResult(interp, "bad command \"", argv[1],
			 "\": must be version or visuals", (char *) NULL);
	return TCL_ERROR;
    }
}

