/********************************************************************************
 *
 * texturecoord2.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_TextureCoordinate2
 *
 * Read in a TextureCoordinate2 node.
 *
 * fields:	point		0 0 	MFVec2f
 *
 *******************************************************************************/

Node *
Vrml_read_TextureCoordinate2(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    char *field;
    NodeTextureCoordinate2 *coord;

    coord = &node->node.textureCoordinate2;
    coord->point = (SFVec2f *) ckalloc(sizeof(SFVec2f));
    coord->point->v[0] = coord->point->v[1] = 0;
    coord->pointlen = 1;

    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {

      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading TextureCoordinate2", (char *) NULL);
	return (Node *) -1;

      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading TextureCoordinate2", (char *) NULL);
	return (Node *) -1;

      case TOKEN_OPEN_CURLY:
	break;

      case TOKEN_WORD:
	Vrml_free_token(field);

      default:
	Tcl_AppendResult(interp, argv, ": bad TextureCoordinate2 format", (char *) NULL);
	return (Node *) -1;
    }

    /* parse all fields until close curly bracket */
    while (1) {

	switch(Vrml_get_token(channel, &field)) {
	    
	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading TextureCoordinate2", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading TextureCoordinate2", (char *) NULL);
	    return (Node *) -1;

	  case TOKEN_CLOSE_CURLY:
	    return node;
	    
	  case TOKEN_WORD:
	    break;

	  default:
	    Tcl_AppendResult(interp, argv, ": bad TextureCoordinate2 format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "point")) {
	    if (coord->point) {
		(void) ckfree((void *) coord->point);
		coord->point = NULL;
		coord->pointlen = 0;
	    }
	    if (Vrml_read_MFVec2f(interp, channel, argv, &coord->point, &coord->pointlen) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad TextureCoordinate2 field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }

  err:
    Vrml_free_token(field);
    Vrml_free_TextureCoordinate2(node);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_free_TextureCoordinate2
 *
 * Free a TextureCoordinate2 node.
 *
 * fields:	point		0 0 	MFVec2f
 *
 *******************************************************************************/

void
Vrml_free_TextureCoordinate2(node)
     Node *node;
{
    NodeTextureCoordinate2 *coord;

    coord = &node->node.textureCoordinate2;
    
    if (coord->point) (void) ckfree((void *) coord->point);
}


/********************************************************************************
 *
 * Vrml_render_TextureCoordinate2
 *
 * Render a TextureCoordinate2 node.
 *
 * fields:	point		0 0 	MFVec2f
 *
 *******************************************************************************/

int
Vrml_render_TextureCoordinate2(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    state->surface->texcoord2 = node->node.textureCoordinate2.point;
    state->surface->texcoord2len = node->node.textureCoordinate2.pointlen;

    return 0;
}
