/********************************************************************************
 *
 * transformseparator.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_TransformSeparator
 *
 * Read in a TransformSeparator node.
 *
 *******************************************************************************/

Node *
Vrml_read_TransformSeparator(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    char *field;
    Node *child, *last;
    NodeTransformSeparator *sep;

    sep = &node->node.transformSeparator;

    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {

      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading TransformSeparator", (char *) NULL);
	return (Node *) -1;

      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading TransformSeparator", (char *) NULL);
	return (Node *) -1;

      case TOKEN_OPEN_CURLY:
	break;

      case TOKEN_WORD:
	Vrml_free_token(field);

      default:
	Tcl_AppendResult(interp, argv, ": bad TransformSeparator format", (char *) NULL);
	return (Node *) -1;
    }
    
    /* parse child nodes */
    last = NULL;
    child = Vrml_read_node(interp, channel, argv, names, inlines, textures, 1, NULL);
    while ((child != NULL) && (child != (Node *) -1)) {
	if (last) {
	    last->sibling = child;
	}
	else {
	    node->child = child;
	}
	last = child;
	child = Vrml_read_node(interp, channel, argv, names, inlines, textures, 1, NULL);
    }
    if (child == NULL) {
	return node;
    }
    else {
	Vrml_free_TransformSeparator(node);
	return (Node *) -1;
  }
}


/********************************************************************************
 *
 * Vrml_free_TransformSeparator
 *
 * Free a TransformSeparator node.
 *
 *******************************************************************************/

void
Vrml_free_TransformSeparator(node)
     Node *node;
{
    Node *child;

    for (child = node->child; child; child = child->sibling) {
	Vrml_free_node(child);
    }
}


/********************************************************************************
 *
 * Vrml_render_TransformSeparator
 *
 * Render a TransformSeparator node.
 *
 *******************************************************************************/

int
Vrml_render_TransformSeparator(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    SFVec3f pos, fwd, up, scale;

    node->objects = state->objects;
    state->objects = node;

    Vrml_object_state(state, &pos, &fwd, &up, &scale);

    if ((Vrml_new_object(interp, state, node, "polygon", &pos, &fwd, &up, 0, NULL) != TCL_OK) ||
	(Vrml_push_model(interp, state, node) != TCL_OK) ||
	(Vrml_push_transform(interp, state) != TCL_OK)) {
	return 2;
    }

    return 0;
}


/********************************************************************************
 *
 * Vrml_finish_TransformSeparator
 *
 * Finish rendering a TransformSeparator node.
 *
 *******************************************************************************/

int
Vrml_finish_TransformSeparator(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    Vrml_pop_model(state);
    Vrml_pop_transform(state);

    return 0;
}
