/********************************************************************************
 *
 * wwwinline.c
 *
 ********************************************************************************/

#include <stdlib.h>
#include <tk.h>

#include "vrml.h"


/********************************************************************************
 *
 * Vrml_read_WWWInline
 *
 * Read in an WWWInline node.
 *
 * fields:	name		""	SFString
 *		bboxSize	0 0 0	SFVec3f
 *		bboxCenter	0 0 0	SFVec3f
 *
 *******************************************************************************/

Node *
Vrml_read_WWWInline(interp, channel, argv, node, names, inlines, textures)
     Tcl_Interp *interp;
     Tcl_Channel channel;
     char *argv;
     Node *node;
     Node **names, **inlines, **textures;
{
    char *field;
    NodeWWWInline *www;

    www = &node->node.wwwInline;
    www->expanded = 0;
    www->name = NULL;
    www->bboxSize.v[0] = www->bboxSize.v[1] = www->bboxSize.v[2] = 0;
    www->bboxCenter.v[0] = www->bboxCenter.v[1] = www->bboxCenter.v[2] = 0;

    /* get open curly bracket */
    switch(Vrml_get_token(channel, &field)) {

      case TOKEN_OUT_OF_MEMORY:
	Tcl_AppendResult(interp, argv, ": out of memory while reading WWWWInline", (char *) NULL);
	return (Node *) -1;

      case TOKEN_EOF:
      case TOKEN_END:
	Tcl_AppendResult(interp, argv, ": unexpected end of input while reading WWWInline", (char *) NULL);
	return (Node *) -1;

      case TOKEN_OPEN_CURLY:
	break;
	
      case TOKEN_WORD:
	Vrml_free_token(field);

      default:
	Tcl_AppendResult(interp, argv, ": bad WWWInline format", (char *) NULL);
	return (Node *) -1;
    }

    /* parse all fields until close curly bracket */
    while (1) {
	
	switch(Vrml_get_token(channel, &field)) {
	    
	  case TOKEN_OUT_OF_MEMORY:
	    Tcl_AppendResult(interp, argv, ": out of memory while reading WWWInline", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_EOF:
	  case TOKEN_END:
	    Tcl_AppendResult(interp, argv, ": unexpected end of input while reading WWWInline", (char *) NULL);
	    return (Node *) -1;
	    
	  case TOKEN_CLOSE_CURLY:
	    return node;
	    
	  case TOKEN_WORD:
	    break;
	    
	  default:
	    Tcl_AppendResult(interp, argv, ": bad WWWInline format", (char *) NULL);
	    return (Node *) -1;
	}
	
	if (!strcmp(field, "name")) {
	    if (www->name) {
		Vrml_free_token(www->name);
		www->name = NULL;
	    }
	    if (Vrml_read_SFString(interp, channel, argv, &www->name, NULL, NULL) != TCL_OK) {
		goto err;
	    }
	}
	else if (!strcmp(field, "bboxSize")) {
	    if (Vrml_read_SFVec3f(interp, channel, argv, &www->bboxSize, NULL, NULL) != TCL_OK) {
		goto err;
	    }
	}
	else if (!strcmp(field, "bboxCenter")) {
	    if (Vrml_read_SFVec3f(interp, channel, argv, &www->bboxCenter, NULL, NULL) != TCL_OK) {
		goto err;
	    }
	}
	else {
	    Tcl_AppendResult(interp, argv, ": bad WWWInline field \"", field, "\"", (char *) NULL);
	    goto err;
	}
	Vrml_free_token(field);
    }

  err:
    Vrml_free_token(field);
    Vrml_free_WWWInline(node);
    return (Node *) -1;
}


/********************************************************************************
 *
 * Vrml_free_WWWInline
 *
 * Free an WWWInline node.
 *
 * fields:	name		""	SFString
 *		bboxSize	0 0 0	SFVec3f
 *		bboxCenter	0 0 0	SFVec3f
 *
 *******************************************************************************/

void
Vrml_free_WWWInline(node)
     Node *node;
{
    NodeWWWInline *www;

    www = &node->node.wwwInline;
    if (www->name) Vrml_free_token(www->name);
}



/********************************************************************************
 *
 * Vrml_render_WWWInline
 *
 * Render a WWWInline node.
 *
 * fields:	name		""	SFString
 *		bboxSize	0 0 0	SFVec3f
 *		bboxCenter	0 0 0	SFVec3f
 *
 *******************************************************************************/

int
Vrml_render_WWWInline(interp, node, state)
     Tcl_Interp *interp;
     Node *node;
     State *state;
{
    if (!node->node.wwwInline.expanded) {
	if (node->node.wwwInline.name) {
	    Tcl_AppendElement(interp, "WWWInline");
	    Tcl_AppendElement(interp, node->node.wwwInline.name);
	    node->node.wwwInline.expanded = 1;
	    return 1;
	}
    }
    return 0;
}
