#####
# about.show
#
# Displays program information.
#
proc about.show {} {
	global LIB_DIR logo

	if [winfo exists .about] {
		wm deiconify .about
		raise .about
		return
	}

	toplevel .about
	wm protocol .about WM_DELETE_WINDOW "about.close"
	wm resizable .about 0 0
	wm title .about "About Typewriter..."
	wm iconname .about "About Typewriter..."


	frame .about.f1
	set logo [image create photo -file $LIB_DIR/logo100.gif]
	label .about.f1.l -image $logo
	pack .about.f1.l -padx 8 -pady 8

	frame .about.f2
	label .about.f2.l1 -text Typewriter -width 15 -font "Lucidatypewriter 24"
	label .about.f2.l2 -text "The Tcl/Tk editor" -font "Helvetica 10"
	label .about.f2.l3 -text "Version 1.1" -font "Helvetica 10"
	pack .about.f2.l1 .about.f2.l2 .about.f2.l3 

	frame .about.f3
	label .about.f3.l1 -text "Copyright 1999 by Harald Simon" -font "Helvetica 10"
	pack .about.f3.l1

	grid .about.f1 .about.f2
	grid .about.f3 -sticky ew -columnspan 2
}



#####
# about.close
#
proc about.close {} {
	global logo

	image delete $logo
	destroy .about
}
