proc edit.text_search {win pattern {begin ""} {dir "-forward"} {opt1 ""} {opt2 ""} {opt3 ""}} {
	set start 1.0
	set end end

	if {$pattern == ""} {
		return 1
	}

	if {$dir == "-forward"} {
		catch {$win mark set insert sel.last}
	} else {
		catch {$win mark set insert sel.first}
		set start end
		set end 1.0
	}

	if {$begin != ""} {
		set start [$win index $begin]
	}

	# Clear current selection
	selection clear
	
	# Search pattern
	set cur [eval $win search $dir $opt1 $opt2 $opt3 -count length [list -- $pattern] $start $end]
	if {$cur == ""} {
		return 0
	}

	# Select the found pattern
	$win tag add sel $cur "$cur + $length chars"

	# Set selection anchor and cursor
	if {$dir == "-forward"} {
		$win mark set anchor sel.first
		catch {$win mark set insert sel.last}
	} else {
		$win mark set anchor sel.last
		catch {$win mark set insert sel.first}
	}

	$win see $cur
	return 1
}


proc edit.find_text {pattern} {
	global topWindow

	set begin [radiobox.get .find.rb1]
	set dir [radiobox.get .find.rb2]
	set opt1 [optionbox.get .find.ob1 1]
	set opt2 [optionbox.get .find.ob1 2]

	if [text_search $topWindow.text $pattern $begin $dir $opt1 $opt2] {
		after idle {radiobox.set .find.rb1 insert}
	} else {
		bell
	}
}

  

proc edit.replace_text {searchString replaceString} {
	global topWindow
	global winInfo

	if {$topWindow == ""} {
		return
	}

	if {$searchString == ""} {
		return
	}

	after idle {
		# Insert the search string into the popup list.
		if {[popup.get_index .replace.f1.dd1 $searchString] < 0} {
			popup.insert .replace.f1.dd1 0 $searchString
		}

		# Insert the replace string into the dropdown list.
		if {[popup.get_index .replace.f1.dd2 $replaceString] < 0} {
			popup.insert .replace.f1.dd2 0 $replaceString
		}

		# Trimm the dropdown lists to the last 100 entries.
		.replace.f1.dd1.top.lb delete 100 end
		.replace.f1.dd2.top.lb delete 100 end
	}

	set begin [radiobox.get .replace.rb1]
	set dir [radiobox.get .replace.rb2]
	set opt1 [optionbox.get .replace.ob1 1]
	set opt2 [optionbox.get .replace.ob1 2]

	if {$winInfo(.replace-state)} {
		catch {$topWindow.text delete sel.first sel.last}
		$topWindow.text insert insert $replaceString
		update idletasks
	}

	if [edit.text_search $topWindow.text $searchString $begin $dir $opt1 $opt2] {
		set winInfo(.replace-state) 1
		after idle {radiobox.set .replace.rb1 insert}
	} else {
		set winInfo(.replace-state) 0
		bell
	}
	
}



#####
# edit.find_and_replace
#
# This is the main procedure for the "Find and Replace"-dialog.
#
proc edit.find_and_replace {{win ""}} {
	global winInfo

	set win [window_check $win]
	if  {$win == ""} {
		return
	}
	
	set winInfo(.replace-state) 0
	set searchString ""
	set replaceString ""

	if [winfo exists .replace] {
		window_raise .replace
		focus .replace.f1.dd1.e1	
		return
	}		

	toplevel .replace
	wm protocol .replace WM_DELETE_WINDOW "wm withdraw .replace"
	wm group .replace .
	wm title .replace "Find & Replace..."
	wm iconname .replace "Find & Replace..."
	wm resizable .replace 1 0

	frame .replace.f1
	label .replace.f1.l1 -text "Find: " -anchor w
	popup.create .replace.f1.dd1
	.replace.f1.dd1.e1 configure -textvariable searchString -width 25

	label .replace.f1.l2 -text "Replace with: " -anchor w
	popup.create .replace.f1.dd2
	.replace.f1.dd2.e1 configure -textvariable replaceString

	grid .replace.f1.l1 .replace.f1.dd1 -sticky nesw
	grid .replace.f1.l2 .replace.f1.dd2 -sticky nesw
	grid columnconfigure .replace.f1 1 -weight 1

	radiobox.create .replace.rb1 "Start search at..." left
	lappend b [radiobox.add .replace.rb1 "Begin" 1.0 {radiobox.set .replace.rb2 "-forward"}]
	lappend b	[radiobox.add .replace.rb1 "Here" insert]
	lappend b	[radiobox.add .replace.rb1 "End" end {radiobox.set .replace.rb2 "-backward"}]

	radiobox.create .replace.rb2 "Search..." left
	lappend b [radiobox.add .replace.rb2 Forwards -forward]
	lappend b [radiobox.add .replace.rb2 Backwards -backward]

	foreach i $b {	
		bind $i <Double-ButtonPress-1> {tkButtonInvoke .replace.f2.b1}
	}

	optionbox.create .replace.ob1 "Options..." left
	optionbox.add .replace.ob1 "Ignore case" -nocase
	optionbox.add .replace.ob1 "Regular expression" -regexp

	frame .replace.sep -height 2 -borderwidth 1 -relief sunken

	frame .replace.f2
	button .replace.f2.b1 -width 8 -text "Find" -under 0 -default active -command {set winInfo(.replace-state) 0; edit.replace_text $searchString $replaceString}
	button .replace.f2.b2 -width 8 -text "Replace" -under 0 -command {edit.replace_text $searchString $replaceString}
	button .replace.f2.b3 -width 8 -text "Cancel" -under 0 -command {wm withdraw .replace}
	pack .replace.f2.b3 -side right -padx 2 -fill x -expand yes
	pack .replace.f2.b2 -side right -padx 2 -fill x -expand yes
	pack .replace.f2.b1 -side right -padx 2 -fill x -expand yes
	
	pack .replace.f1 -padx 4 -pady 4 -anchor w -fill x
	pack .replace.rb1 -padx 4 -pady 4 -anchor w -fill x
	pack .replace.rb2 -padx 4 -pady 4 -anchor w -fill x
	pack .replace.ob1 -padx 4 -pady 4 -anchor w -fill x
	pack .replace.sep -fill x
	pack .replace.f2 -padx 4 -pady 4 -fill x

	bind .replace <Return> {tkButtonInvoke .replace.f2.b1}
	bind .replace <Escape> {tkButtonInvoke .replace.f2.b3}
	bind .replace <Alt-KeyPress-f> {tkButtonInvoke .replace.f2.b1}
	bind .replace <Alt-KeyPress-r> {tkButtonInvoke .replace.f2.b2}
	bind .replace <Alt-KeyPress-c> {tkButtonInvoke .replace.f2.b3}

	update idletasks
	wm minsize .replace [winfo width .replace] [winfo height .replace]
	focus .replace.f1.dd1.e1
}



#####
# edit.goto
#
proc edit.goto {{win ""}} {
	set win [window_check $win]
	if  {$win == ""} {
		return
	}

	if [winfo exists .goto] {
		wm deiconify .goto
		window_raise .goto
		focus .goto.f1.e1	
		return
	}		

	toplevel .goto
	wm protocol .goto WM_DELETE_WINDOW "wm withdraw .goto"
	wm group .goto .
	wm title .goto "Goto..."
	wm iconname .goto "Goto..."
	wm resizable .goto 0 0

	frame .goto.f1
	label .goto.f1.l1 -text "Goto: " -anchor w
	entry .goto.f1.e1
	pack .goto.f1.l1 -side left 
	pack .goto.f1.e1 -side right -expand yes -fill x -padx 4 -pady 4

	frame .goto.sep -height 2 -borderwidth 1 -relief sunken
	
	frame .goto.f2
	button .goto.f2.b1 -width 6 -text "Goto" -under 0 -default active -command "edit.do_goto"
	button .goto.f2.b2 -width 6 -text "Cancel" -under 0 -command "focus $win.text; wm withdraw .goto"
	pack .goto.f2.b1 -side left -fill x -expand yes -padx 2
	pack .goto.f2.b2 -side right -fill x -expand yes -padx 2

	pack .goto.f1 -fill x -padx 4 -pady 4
	pack .goto.sep -fill x
	pack .goto.f2 -fill x -padx 4 -pady 4

	bind .goto <Return> {tkButtonInvoke .goto.f2.b1}
	bind .goto <Escape> {tkButtonInvoke .goto.f2.b2}
	bind .goto <Alt-KeyPress-g> {tkButtonInvoke .goto.f2.b1}
	bind .goto <Alt-KeyPress-c> {tkButtonInvoke .goto.f2.b2}

	focus .goto.f1.e1
}



#####
# edit.do_goto
#
proc edit.do_goto {{win ""}} {
	set win [window_check $win]

	if {[.goto.f1.e1 get] == ""} {
		return
	}

	if {[catch {set l [expr [.goto.f1.e1 get] + 0.0]}]} {
		set msg "Cannot go to index [.goto.f1.e1 get]."
		tk_messageBox -title "Typewriter: Goto..." -default ok -message $msg -icon error -type ok
		return
	}

	selection clear
	$win.text mark set insert $l
	$win.text tag add sel "$l linestart" "$l lineend"
	catch {$win.text mark set anchor sel.first}
	$win.text see insert

	focus $win.text
	wm withdraw .goto	
}
