###
# Globales
#
set fileTypeList { 
	{{All Files}  * } 
	{{Tcl/Tk} {*.tcl}} 
	{{HTML} {*.htm*}}
	{{Latex} {*.tex}}
	{{Text} {*.txt}} 
	{{C} {*.c*}}
}



###
# file.new {}
#
# Open a new typewriter window.
#
proc file.new {} {
	return [typewriter.open]
}



###
# file.open {args}
#
# args: win or -file filename
#
proc file.open {args} {
	global fileTypeList winInfo

	# File or window ?
	if {[lindex $args 0] == "-file"} {
		set filename [lindex $args 1]
		set win [typewriter.find $filename]
	} else {
		set filename ""
		set win [lindex $args 0]
	}

	if {$win == ""} {
		if {$filename == ""} {
			set filename [tk_getOpenFile -filetypes $fileTypeList]

			if {$filename == ""} {
				return ""
			}
		}
		return [typewriter.open -file $filename]
	}
	return [typewriter.open $win]
}



###
# file.close {args}
#
proc file.close {args} {
	# File or window ?
	if {[lindex $args 0] == "-file"} {
		set win [typewriter.find [lindex $args 1]]
	} else {
		set win [lindex $args 0]
	}

    return [typewriter.close $win]
}



###
# file.save {args}
#
proc file.save {args} {
	# File or window ?
	if {[lindex $args 0] == "-file"} {
		set win [typewriter.find [lindex $args 1]]
	} else {
		set win [lindex $args 0]
	}

    return [typewriter.save $win]
}



###
#  file.save_as 
#
proc file.save_as {args} {
	# File or window ?
	if {[lindex $args 0] == "-file"} {
		set win [typewriter.find [lindex $args 1]]
	} else {
		set win [lindex $args 0]
	}

    return [typewriter.save $win as]
}



###
# file.quit {}
#
proc file.quit { } {
	global winInfo

	foreach win [array names winInfo .*-dirty] {
		if ![typewriter.close [lindex [split $win -] 0]] {
			return 0;
		}
	}

	exit
}
