#####
# radiobox.create
#
proc radiobox.create {win {title ""} {orient top}} {
	global rbInfo

	set rbInfo($win-current) ""
	set rbInfo($win-count) 0
	set rbInfo($win-orient) $orient

	frame $win -class Radiobox

	if {$title !=""} {
		label $win.title -text $title
		pack $win.title -side top -anchor w
	}

	frame $win.border -borderwidth 2 -relief groove
	pack $win.border -expand yes -fill both

	bind $win <Destroy> "radiobox.destroy $win"
	return $win
}



#####
# radiobox.destroy
# 
# This procedure is called up in event <Destroy>. The binding is
# set up in radiobox.create.
#
proc radiobox.destroy {win} {
	global rbInfo

	unset rbInfo($win-count)
	unset rbInfo($win-current)
}



#####
# radiobox.add
#
proc radiobox.add {win text {value ""} {command ""}} {
	global rbInfo

	if {$value == ""} {
		set value $text
	}

	set name "$win.border.rb[incr rbInfo($win-count)]"
	radiobutton $name -width 6 -text "$text   " -command $command -variable rbInfo($win-current) -value $value -anchor w
	pack $name -side $rbInfo($win-orient) -anchor w -fill x -expand yes

	if {$rbInfo($win-count) == 1} {
		$name invoke
	}
	return $name
}



#####
# radiobox.set
#
proc radiobox.set {win choice} {
	global rbInfo

	set rbInfo($win-current) $choice
}



#####
# radiobox.get
#
proc radiobox.get {win} {
	global rbInfo

	return $rbInfo($win-current)
}
