###
# menu.init {}
#
proc menu.init {} {
	global topWindowWrapMode

	. configure -menu .mbar
	menu .mbar
	.mbar add cascade -label "File" -menu .mbar.file
	.mbar add cascade -label "Edit" -menu .mbar.edit
	.mbar add cascade -label "Options" -menu .mbar.options
	.mbar add cascade -label "Help" -menu .mbar.help

	menu .mbar.file -title File
	.mbar.file add command -label "New" -accelerator Ctrl+N -command {file.new}
	.mbar.file add command -label "Open..." -accelerator Ctrl+O -command {file.open}
	.mbar.file add command -label "Close" -accelerator Ctrl+U -command {file.close}
	.mbar.file add separator
	.mbar.file add command -label "Save" -accelerator Ctrl+S -command {file.save}
	.mbar.file add command -label "Save as..." -accelerator Alt+S -command {file.save_as}
	.mbar.file add separator
	.mbar.file add command -label "Quit" -accelerator Ctrl+Q -command {file.quit}

	menu .mbar.edit -title Edit
	.mbar.edit add command -label "Undo" -accelerator Ctrl+Z -command {undo}
	.mbar.edit add command -label "Redo" -accelerator Alt+Z -command {redo}
	.mbar.edit add separator
	.mbar.edit add command -label "Copy" -accelerator Ctrl+C -command {tk_textCopy $topWindow.text}
	.mbar.edit add command -label "Cut" -accelerator Ctrl+X -command {tk_textCut $topWindow.text}
	.mbar.edit add command -label "Paste" -accelerator Ctrl+V -command {tk_textPaste $topWindow.text}
	.mbar.edit add separator
	.mbar.edit add command -label "Find & Replace..." -accelerator Ctrl+F -command {edit.find_and_replace}
	.mbar.edit add command -label "Goto..." -accelerator Ctrl+G -command {edit.goto}

	menu .mbar.options -title Options
	.mbar.options add checkbutton -label "Word wrap" -variable topWindowWrapMode -offvalue none -onvalue word -command {typewriter.toggle_wrap_mode}
	.mbar.options add command -label "Character table..." -command {chrtbl.show}

	menu .mbar.help -title Help
	.mbar.help add command -label "About Typewriter..." -command {about.show}
}



###
# menu.update
#
# The procedure is called up via a trace every time the topWindow is changed.
# The variable trace is set in file tt while startup.
#
proc menu.update {args} {
	global topWindow topWindowWrapMode undo_buffer

	set state disabled

	# Any Typewriter with a focus?
	if {$topWindow != ""} {
		# Check the state of the undo_buffer
		if {!$undo_buffer($topWindow-undo_count)} {
			.mbar.edit entryconfigure Redo -state disabled
		}

		# Set the wrap mode
		set topWindowWrapMode [$topWindow.text cget -wrap]

		set state normal
	}

	# Dis-/enable menu entries
	foreach entry {Edit Options} {
		.mbar entryconfigure $entry -state $state
	}

	foreach entry {Close Save "Save as..."} {
		.mbar.file entryconfigure $entry -state $state
	}

	foreach entry {Undo Copy Cut Paste "Find & Replace..." "Goto..."} {
		.mbar.edit entryconfigure $entry -state $state
	}

	foreach entry {"Word wrap" "Character table..."} {
		.mbar.options entryconfigure $entry -state $state

		if {$state == "disabled"} {
			set topWindowWrapMode "none"
		}
	}
}
