#####
# optionbox.create
#
proc optionbox.create {win {title ""} {orient top}} {
	global obInfo

	set obInfo($win-count) 0
	set obInfo($win-orient) $orient

	frame $win -class Optionbox

	if {$title !=""} {
		label $win.title -text $title
		pack $win.title -side top -anchor w
	}

	frame $win.border -borderwidth 2 -relief groove
	pack $win.border -expand yes -fill both

	bind $win <Destroy> "optionbox.destroy $win"
	return $win
}



#####
# optionbox.destroy
#
proc optionbox.destroy {win} {
	global obInfo

	unset obInfo($win-count)
}



#####
# optionbox.add
#
proc optionbox.add {win text {on ""} {off ""} {command ""}} {
	global obInfo

	set name "$win.border.o[incr obInfo($win-count)]"
	checkbutton $name -width 6 -text "$text   " -variable obInfo($name) -onvalue $on -offvalue $off -command $command -anchor w
	pack $name -side $obInfo($win-orient) -anchor w -fill x -expand yes

	return $name
}


#####
# optionbox.get
#
proc optionbox.get {win option} {
	global obInfo

	return $obInfo($win.border.o$option)
}
