#####
# Globals
#

#####
# popup.create
#
#
proc popup.create {win} {
	# Create the entry and the button
	frame $win
	entry $win.e1
	button $win.b1 -padx 2 -pady 0 -text v -command "popup.show $win" -takefocus 0

	pack $win.e1 -side left -expand yes -fill x
	pack $win.b1 -side right

	bind $win.e1 <F4> "tkButtonInvoke $win.b1"
	bind $win.e1 <Tab> "popup.hide $win"
	bind $win.e1 <Escape> "popup.hide $win"

	# The above widgets must be packed to get the current width of $win
	update idletasks

	# Create the listbox
	toplevel $win.top -class Dropdown -relief raised -borderwidth 1
	wm group $win.top .
	wm withdraw $win.top
	wm transient $win.top
	wm overrideredirect $win.top 1
	bind $win <Button> "popup.hide $win"
	
	listbox $win.top.lb -yscrollcommand "$win.top.ysbar set"
	bind $win.top.lb <ButtonRelease-1> "popup.selected $win %x %y"
	bind $win.top.lb <Home> "$win.top.lb activate 0; $win.top.lb see 0"
	bind $win.top.lb <End> "$win.top.lb activate end; $win.top.lb see end"
	bind $win.top.lb <Tab> "popup.set_entry $win; popup.hide $win"
	bind $win.top.lb <Return> "popup.set_entry $win; popup.hide $win"
	bind $win.top.lb <Escape> "popup.hide $win"
	bind $win.top.lb <F4> "tkButtonInvoke $win.b1" 

	scrollbar $win.top.ysbar -orient vertical -command "$win.top.lb yview" -takefocus 0

	pack $win.top.lb -side left -expand yes -fill both
	pack $win.top.ysbar -side right -fill y

	return $win
}



#####
# popup.show
#
# Displays the dropdown list.
#
proc popup.show {win} {
	# Get the bottom left coordinates from the parent
	set x [winfo rootx $win]
	set y [expr [winfo rooty $win] + [winfo height $win]]

	update idletasks
	wm geometry $win.top [winfo width $win]x[expr [winfo reqheight $win.top.lb] + 2 * [$win.top.lb cget -borderwidth]]+$x+$y
	wm deiconify $win.top

	# Set the  selection to the value of the entry widget
	# if the value is in the list.
	popup.activate $win [popup.get_index $win [$win.e1 get]]

	raise $win.top
	grab set -global $win
	focus $win.top.lb

	$win.b1 configure -command "popup.hide $win"
}



#####
# popup.hide
#
# Hides the dropdown list.
#
proc popup.hide {win} {
	grab release $win
	wm withdraw $win.top

	focus $win.e1
	$win.b1 configure -command "popup.show $win"
}



#####
# popup.selected
#
# This procedure is the new binding for <ButtonRelease-1> for the listbox.
# The binding is set in popup.create.
#
proc popup.selected {win x y} {
	tkCancelRepeat
	$win.top.lb activate @$x,$y

	# Fill the entry with the selected value and hide the list
	popup.set_entry $win
	popup.hide $win
	focus $win.e1
}



#####
# popup.activate
#
# Convienience procedure to select the list item $index.
#
proc popup.activate {win index} {
	selection clear
	$win.top.lb selection set $index
	$win.top.lb activate $index
	$win.top.lb see $index
}



#####
# popup.set_entry
#
# Fill the entry with the active value
#
proc popup.set_entry {win} {
	$win.e1 delete 0 end
	$win.e1 insert 0 [$win.top.lb get active]
}



#####
# popup.get_index
#
# The procedure returns the index of the given item. If the item is not
# within the list, -1 will be returned.
#
proc popup.get_index {win item} {
	return [lsearch -exact [$win.top.lb get 0 end] $item]
}


####
# popup.insert
#
# Just a convienience procedure to insert one item before a given index.
#
proc popup.insert {win index item} {
	$win.top.lb insert $index $item
}
