%{
static char rcsid[] = "$Id: parse.y,v 1.1 1998/08/20 16:52:00 nickm Exp nickm $";
/*
 *
 *  NArray - a tcl extension for manipulating multidimensional arrays
 *
 *  Author: N. C. Maliszewskyj, NIST Center for Neutron Research, August 1998
 *          P. Klosowski        NIST Center for Neutron Research
 *  Original Author:
 *          S. L. Shen          Lawrence Berkeley Laboratory,     August 1994
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************
 *
 *
 * This software is copyright (C) 1994 by the Lawrence Berkeley Laboratory.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#include <stdio.h>
#include <assert.h>
#include "narray.h"
#include "narrayInt.h"

#ifdef YYDEBUG
#define YYPRINT(fp, c, v) yyprint(fp, c, v)
#endif

#define state narray_compile_state

%}

%token STRING
%token INT
%token FLOAT
%token ID
%token OR
%token AND
%token NEQ
%token EQ
%token LE
%token GE
%token PLUS_EQ
%token MINUS_EQ
%token MUL_EQ
%token DIV_EQ
%token '$'
%token '!'
%token '('
%token ')'
%token '['
%token ']'
%token ';'
%token FOR
%token IF
%token WHILE

%left '=' PLUS_EQ MINUS_EQ MUL_EQ DIV_EQ
%right '?' ':'
%left OR
%left AND
%left EQ NEQ
%left '>' '<' GE LE
%left '-' '+'
%left '*' '/'
%right UNARY

%start program
%%

program:
     statement_sequence { state->code = $1; }
     ;

statement_sequence:
     /* empty */ { $$ = NArray_VarMakeCode(OP_END); }
     | statement_sequence statement {
	 $$ = NArray_AppendCodeAndFree($1, $2);
     }
     ;

statement:
     ';' { $$ = NArray_VarMakeCode(OP_END); }
     | expression ';' { $$ = $1; }
     | FOR '{' opt_expression ';' opt_expression ';' opt_expression '}' '{' statement_sequence '}' {
	 int cond_len, body_len, post_len;
	 $$ = $3;
	 cond_len = NArray_CodeLength($5);
	 post_len = NArray_CodeLength($7);
	 body_len = NArray_CodeLength($10);
	 $$ = NArray_AppendCodeAndFree($$, $5);
	 $$ = NArray_AppendOps($$,
			       OP_NOT,
			       OP_JUMPT | (body_len + post_len + 2),
			       OP_END);
	 $$ = NArray_AppendCodeAndFree($$, $10);
	 $$ = NArray_AppendCodeAndFree($$, $7);
	 $$ = NArray_AppendOps($$,
			       OP_JUMP | ((-(body_len + post_len
					     + cond_len + 2))
					  & OPERAND_MASK),
			       OP_END);
     }
     | IF expression '{' statement_sequence '}' {
	 int body_len;
	 $$ = $2;
	 body_len = NArray_CodeLength($4);
	 $$ = NArray_AppendOps($$, OP_NOT, OP_JUMPT | (body_len + 1), OP_END);
	 $$ = NArray_AppendCodeAndFree($$, $4);
     }
     | WHILE expression '{' statement_sequence '}' {
	 int body_len, cond_len;
	 $$ = $2;
	 cond_len = NArray_CodeLength($2);
	 body_len = NArray_CodeLength($4);
	 $$ = NArray_AppendOps($$, OP_NOT, OP_JUMPT | (body_len + 2), OP_END);
	 $$ = NArray_AppendCodeAndFree($$, $4);
	 $$ = NArray_AppendOps($$,
			       OP_JUMP | ((-(body_len + cond_len + 2))
					  & OPERAND_MASK),
			       OP_END);
     }
     ;

opt_expression:
     /* empty */ { $$ = NArray_VarMakeCode(OP_END); }
     | expression
     ;

expression:
    '-' expression %prec UNARY {
	$$ = NArray_AppendOps($2, OP_NEG, OP_END);
    }
    | '!' expression %prec UNARY {
	$$ = NArray_AppendOps($2, OP_NOT, OP_END);
    }
    | '+' expression %prec UNARY {
        $$ = $2;
    }
    | '(' expression ')' {
        $$ = $2;
    } ;

expression:
    expression '*' expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_MUL, OP_END);
    }
    | expression '/' expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_DIV, OP_END);
    }
    | expression '+' expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_ADD, OP_END);
    }
    | expression '-' expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_SUB, OP_END);
    }
    | expression EQ expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_EQ, OP_END);
    }
    | expression NEQ expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_EQ, OP_NOT, OP_END);
    }
    | expression LE expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_LE, OP_END);
    }
    | expression GE expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_GE, OP_END);
    }
    | expression '<' expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_LT, OP_END);
    }
    | expression '>' expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_GT, OP_END);
    }
    | expression AND expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_AND, OP_END);
    }
    | expression OR expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_OR, OP_END);
    }
    | expression '?' expression ':' expression {
	int len_true, len_false;
	$$ = $1;
	len_true = NArray_CodeLength($3);
	len_false = NArray_CodeLength($5);
	$$ = NArray_AppendOps($$, OP_JUMPT | (len_false + 2), OP_END);
	$$ = NArray_AppendCodeAndFree($$, $5);
	$$ = NArray_AppendOps($$, OP_JUMP | (len_true + 1), OP_END);
	$$ = NArray_AppendCodeAndFree($$, $3);
    }
    | numeric_constant
    | ID { state->arity_sp++; } '(' fn_arguments ')' {
	int id = $1[2] & OPERAND_MASK;
	Code fn = NArray_LookupFn(id);
	if (fn == 0) {
	    state->use_error_msg = 1;
	    sprintf(state->error_msg, "unknown function \"%s\"",
		    state->closure->id_table[id].id);
	    YYERROR;
	}
	$$ = $4;
	$$ = NArray_AppendOps($$,
			      OP_FN | state->arity_stack[state->arity_sp],
			      NArray_LookupFn(id), OP_END);
	--state->arity_sp;
	NArray_UninternId(id);
	NArray_FreeCode($1);
    }
    | '$' var {
	$$ = NArray_AppendOps($2, OP_REF, OP_END);
    }
    | '$' array_ref {
	$$ = NArray_AppendOps($2, OP_REF, OP_END);
    }
    | '@' INT {
	$$ = $2;
	$2[2] = OP_IREF | ($2[2] & OPERAND_MASK);
    }
    | lvalue '=' expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
	$$ = NArray_AppendOps($$, OP_SET, OP_END);
    }
    | lvalue PLUS_EQ expression {
	$$ = $1;
	$$ = NArray_AppendOps($$, OP_DUPLV, OP_REF, OP_END);
	$$ = NArray_AppendCodeAndFree($$, $3);
	$$ = NArray_AppendOps($$, OP_ADD, OP_SET, OP_END);
    }
    | lvalue MINUS_EQ expression {
	$$ = $1;
	$$ = NArray_AppendOps($$, OP_DUPLV, OP_REF, OP_END);
	$$ = NArray_AppendCodeAndFree($$, $3);
	$$ = NArray_AppendOps($$, OP_SUB, OP_SET, OP_END);
    }
    | lvalue MUL_EQ expression {
	$$ = $1;
	$$ = NArray_AppendOps($$, OP_DUPLV, OP_REF, OP_END);
	$$ = NArray_AppendCodeAndFree($$, $3);
	$$ = NArray_AppendOps($$, OP_MUL, OP_SET, OP_END);
    }
    | lvalue DIV_EQ expression {
	$$ = $1;
	$$ = NArray_AppendOps($$, OP_DUPLV, OP_REF, OP_END);
	$$ = NArray_AppendCodeAndFree($$, $3);
	$$ = NArray_AppendOps($$, OP_DIV, OP_SET, OP_END);
    }
    ;

array_ref:
    ID '[' expression_list ']' {
	int id, i, ok;
	char* name;
	id = $1[2] & OPERAND_MASK;
	name = state->closure->id_table[id].id;
	ok = 0;
	for (i = 0; i < state->closure->n_arrays; i++) {
	    if (!strcmp(name, state->closure->array_table[i].name)) {
		ok = 1;
		break;
	    }
	}
	if (!ok) {
	    state->use_error_msg = 1;
	    sprintf(state->error_msg, "unknown array \"%s\"", name);
	    YYERROR;
	}
	$$ = NArray_VarMakeCode(OP_MARK, OP_END);
	$$ = NArray_AppendCodeAndFree($$, $3);
	$$ = NArray_AppendOps($$, OP_ARRAY | i, OP_END);
    }
    | '[' expression_list ']' {
	$$ = NArray_VarMakeCode(OP_MARK, OP_END);
	$$ = NArray_AppendCodeAndFree($$, $2);
	$$ = NArray_AppendOps($$, OP_THIS, OP_END);
    } ;

var:
    ID
    ;

lvalue:
    array_ref
    | var
    ;

expression_list:
    /* empty */ { $$ = NArray_VarMakeCode(OP_END); }
    | expression { $$ = $1; }
    | expression_list ',' expression {
	$$ = NArray_AppendCodeAndFree($1, $3);
    } ;

fn_arguments:
    /* empty */ {
	$$ = NArray_VarMakeCode(OP_END);
	state->arity_stack[state->arity_sp] = 0;
    }
    | fn_argument {
	$$ = $1;
	state->arity_stack[state->arity_sp] = 1;
    }
    | fn_arguments ',' fn_argument {
	$$ = NArray_AppendCodeAndFree($1, $3);
	state->arity_stack[state->arity_sp]++;
    } ;

fn_argument:
    expression
    | STRING
    ;

numeric_constant:
    INT
    | FLOAT ;

%%
