'\"
'\" Copyright (c) 2000 Neil McKay
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" $Header: /home/neil/src/tcl/hash/RCS/hash.n,v 1.2 2000/10/04 04:06:46 neil Exp $
'\" 
.so man.macros
.TH hash n 8.4 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Hash \- Hash-table operations
.SH SYNOPSIS
\fBhash::create \fIhashName \fR?\fIoptions\fR?
\fBhash::exists\fIhashName \fR
.SH DESCRIPTION
.PP
The \fBhash\fR commands are for creating and manipulating
hash tables from the Tcl command level. Hash tables allow
the creation of persistent array-like and struct-like
objects without using global arrays. Hash tables are created
with the \fBhash::create\fR command:
.CS
\fBhash::create hh\fR
.CE
will create a hash table called \fBhh\fR, which will be
accessible via the hash table's object command \fBhh\fR.
The command  \fBhash::exists\fR returns a non-zero value
if its argument is the name of a hash table, zero otherwise.

.SH "HASH OBJECT COMMANDS"
.PP
A hash table's object command can be used to
query and/or modify the hash table. Allowed subcommands are:
.TP
\fBconfigure \fR?\fIoptions\fR?
sets/retrieves hash table options.
.TP
\fBcontents \fR?\fIcontentsList\fR?
With no arguments, the \fBcontents\fR command returns the
contents of the hash table in the same style as the
Tcl \fBarray get\fR command, i.e. as a sequence of index-value
pairs. If the \fIcontentsList\fR argument is provided, then
the specified elements of the hash table will be set to
the values given in the list.
.TP
\fBdelete \fIentryName\fR
Deletes the hash-table entry with index \fIentryName\fR.
Returns an error if the entry doesn't exist.
.TP
\fBnames \fR?\fIpattern\fR?
Returns a list containing all hash table indices that match
\fIpattern\fR, or all indices if \fIpattern\fR is not given.
.TP
\fBset \fIname\fR ?\fB=\fR? ?\fIvalue\fR?
With no arguments, return the value stored at index \fIname\fR;
if \fIvalue\fR is given, set the value stored at index \fIname\fR
to \fIvalue\fR. (The ``='' is optional syntactic sugar.)
.TP
\fBunset \fIentryName\fR
This is identical to the \fBdelete\fR command.
.TP
\fB-> \fIname\fR ?=? ?\fIvalue\fR?
This is identical to the \fBset\fR command.
.SH OPTIONS
Options allowed for the \fBhash::create\fR command and the
\fBconfigure\fR hash table command are:
.TP
\fB-allowchanges \fIboolean\fR
If \fIboolean\fR is true, then allow creation and deletion
of new hash table entries; otherwise, only allow modification
of existing entries. Default is true.
.TP
\fB-deleteproc \fIdeleteProc\fR
\fIdeleteProc\fR will be executed when the hash is deleted.
It will be supplied with the hash table name as its single argument.
When this procedure is invoked, the hash still exists, so
its contents may be examined. Note that deleting the hash from
within  \fIdeleteProc\fR will not cause a reinvocation of
\fIdeleteProc\fR. This is useful for performing user-defined
cleanup when a hash is deleted.
.TP
\fB-missingentryproc \fIentryProc\fR
If access to a non-existent hash table entry occurs, execute
\fIentryProc\fR. \fIentryProc\fR will be supplied with two
arguments: the hash table name and the entry name. If
\fIentryProc\fR is the null string, then access to missing
entries will cause a Tcl error. (This is the default behavior.)

.SH EXAMPLES
To create a hash named foo containing entries x, y, and z:
.CS
hash::create foo
foo contents {x 1 y 2 z 3}
.CE
or, alternatively:
.CS
hash::create foo
foo set x 1
foo set y = 2
foo -> z = 3
.CE
To disallow creation and deletion of entries:
.CS
foo configure -allowchanges false
.CE
The command
.CS
foo names
.CE
should return the list \fBx y z\fR.
.PP
To create a hash that always returns the entry name except for
selected entries, we can use the \fB-missingentryproc\fR option.
First, create a proc that returns the entry name:
.CS
proc missing {table entry} {
    return $entry
}
.CE
Then specify that proc as the value of the  \fB-missingentryproc\fR option:
.CS
hash ident -missingentryproc missing
.CE
If we set the entry named \fBrule\fR, say:
.CS
ident -> rule = "exception"
.CE
then the commands \fBident set foo\fR and  \fBident set bar\fR
should return \fBfoo\fR and \fBbar\fR respectively, while
\fBident set rule\fR will return \fBexception\fR.

.SH KEYWORDS
Hash Map Struct

