# vim:ts=4 sw=4 ft=tcl
#
# $Id: benchmarks.tcl,v 1.1.1.1 2000/04/27 00:34:43 soul Exp $
#
# This file is part of Tcl Benchmarks
#  Copyright 2000 Laurent Duperval <lduperval@sprint.ca>
#
# This software is copyrighted by Laurent Duperval, 2000.
# The following terms apply to all files associated with the software 
# unless explicitly disclaimed in individual files.
# 
# The authors hereby grant permission to use, copy, modify, distribute,
# and license this software and its documentation for any purpose, provided
# that existing copyright notices are retained in all copies and that this
# notice is included verbatim in any distributions. No written agreement,
# license, or royalty fee is required for any of the authorized uses.
# Modifications to this software may be copyrighted by their authors
# and need not follow the licensing terms described here, provided that
# the new terms are clearly indicated on the first page of each file where
# they apply.
# 
# IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY
# FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
# ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
# DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
# 
# THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
# IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE
# NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
# MODIFICATIONS.
# 
# GOVERNMENT USE: If you are acquiring this software on behalf of the
# U.S. government, the Government shall have only "Restricted Rights"
# in the software and related documentation as defined in the Federal 
# Acquisition Regulations (FARs) in Clause 52.227.19 (c) (2).  If you
# are acquiring the software on behalf of the Department of Defense, the
# software shall be classified as "Commercial Computer Software" and the
# Government shall have only "Restricted Rights" as defined in Clause
# 252.227-7013 (c) (1) of DFARs.  Notwithstanding the foregoing, the
# authors grant the U.S. Government and others acting in its behalf
# permission to use and distribute the software in accordance with the
# terms specified in this license. 
# 

source "benchlib.tcl"

# Set some platform specific stuff

# Find available interpreters. If more than one version of an interpreter
# exists in the path, only the first one will be used.

puts -nonewline "Looking for tcl interpreters..."
set tclshInterps {}
foreach path [split $env(PATH) "$pathSep"] {
	regsub -all {\\} $path "/" path
	foreach interp [glob -nocomplain $path/tclsh*] {
		if {[lsearch $tclshInterps [file tail $interp]] == -1} {
			lappend tclshInterps [file tail $interp]
		}
	}
	putsn "..."
}
putsn "\n"
puts -nonewline "Looking for wish interpreters..."
set wishInterps {}
foreach path [split $env(PATH) "$pathSep"] {
	regsub -all {\\} $path "/" path
	foreach interp [glob -nocomplain $path/wish*] {
		if {[lsearch $wishInterps [file tail $interp]] == -1} {
			lappend wishInterps [file tail $interp]
		}
	}
	putsn "..."
}
puts "\n"

# Start all the tests

set filelist [glob tcl_*.bch]

foreach f $filelist {
	foreach interp $tclshInterps {
		catch {exec $interp $f $interp} output
		puts $output
	}
	puts "\n"
}

set filelist [glob wish_*.bch]

foreach f $filelist {
	foreach interp $wishInterps {
		puts "Running $interp"
		catch {exec $interp $f $interp} output
		puts $output
	}
	puts "\n"
}
