###############################################################################
###############################################################################
#                               Getleft
###############################################################################
###############################################################################
# copyright (C) 1999 Andres Garcia Garcia - ornalux@redestb.es
# Distributed under the terms of the GPL
###############################################################################
###############################################################################
# Version 0.6
###############################################################################
###############################################################################
#
# The following lines look for the most recent wish version in your path,
# keep in mind this program only works with version 8.1 or newer
#
# \
if which wish8.2>/dev/null; then
# \
    exec wish8.2 -f $0
# \
elif which wish8.1>/dev/null; then
# \
    exec wish8.1 -f $0
# \
else
# \
    exec wish -f $0
# \
fi

regsub {\.} $tcl_version {} version

if {$version<81} {
    wm withdraw .
    tk_messageBox -icon error -type ok -message "This program only works with\n\
            wish v 8.1 or better, yours is:\n\t $tcl_version" -title Error
    exit
}

set dirGetleft [file dirname [info script]]

source [file join "$dirGetleft" scripts Ccombinado.tcl]
source [file join "$dirGetleft" scripts Ventana.tcl]
source [file join "$dirGetleft" scripts Dialogos.tcl]
source [file join "$dirGetleft" scripts Herramientas.tcl]
source [file join "$dirGetleft" scripts Ayuda.tcl]

###############################################################################
# VerEnlaces
#    Show the links found in the last preprocessed page, it's only good for
#    debugging.
###############################################################################
proc VerEnlaces {} {
    global nEnlaces ficheroEnlace direccion directorio_base descripcionEnlace

    for {set i 1} {$i<$nEnlaces} {incr i} {
        puts "$i: $ficheroEnlace($i) $descripcionEnlace($i)"
    }
    return
}

#############################################################################
# fijar_coordenadas
#    Reads the coordinates of the upper left corner of a window and puts
#    then in 'coord'.
#
# Parameter:
#    windows whose position you want to know, defaults to the main program
#    window
#
# Side effect:
#    coord(x): x coordinate
#    coord(y): y one
#############################################################################
proc fijar_coordenadas {{cual .} } {
    global coord

    regexp {(?:\+)([0-9]+)(?:\+)([0-9]+)} [wm geometry $cual] \
            nada coord(x) coord(y)

    return
}

###############################################################################
# Adecentar_dir
#    Coge el path absoluto de un fichero y le quita cosas como '..' y '.'
#    Tambin le quita los parmetros si es una llamada a un cgi
#
# Parmetro:
#    Path del fichero
#
# Devuelve:
#    Path adecentado
###############################################################################
proc Adecentar_dir {path} {
    if {[regexp {\.$} $path]} {
        append path /
    }
    for {set a 1 ; set b 1} {($a>0)||($b>0)} {} {
        set a [regsub -all {/\./} $path {/} path]
        set b [regsub -all {([^./]+/\.\./)} $path {} path]
    }
    for {} {[regsub {^/\.\.} $path {} path]} {} {}

    return $path
}

###############################################################################
# InicializacionBajada
#    Se encarga de tareas previas al comienzo de la bajada de la direccion
#    pedida.
# Parametro:
#    pagina: la direccion de la pagina pedida
###############################################################################
proc InicializacionBajada {pagina} {
    global directorio_local directorio_base
    global direccion opciones fichero_a_bajar
    global labelTitles labelMessages

    if {[regexp -nocase {(?:http://)?([^/]+)((?:~[^/]*)?(?:[^\?]*))(?:/)(.*)} \
        $pagina nada direccion(www) direccion(dir) nombre_fichero]} {
    } else {
        tk_messageBox -type ok -title $labelTitles(initError) -icon error \
            -message $labelMessages(formatError)
        return
    }

    set directorio_base [Dialogos::SeleccionarDirectorio]
    if {![string compare $directorio_base ""]} {
        return
    }
    set directorio_local $directorio_base

    if {$nombre_fichero==""} {
        set nombre_fichero index.html
        set esHtml 1
    } else {
        set esHtml [regexp -nocase {html?$} $nombre_fichero]
    }

    set nombre_fichero [file join $direccion(dir) $nombre_fichero]
    set direccion(base) $direccion(dir)

    set fichero [AbrirFichero [Adecentar_nombres $nombre_fichero] ]

    if {$fichero!=1} {
        set result [Bajar $pagina $fichero]
    } else {
        tk_messageBox -type ok -title $labelTitles(initError) -icon error \
                -message [concat $labelMessages(notOpen) $nombre_fichero]
        return
    }

    if {$result==2} {
        tk_messageBox -icon error -type ok -title $labelTitles(error) \
                 -message "$Ventana::Rizo::mensaje_error"
        return
    }
    set fichero [file root $fichero]
    if {([regexp -nocase $Ventana::Rizo::meta(contenido) "text/html"])&&($esHtml==0)} {
        file rename -force $fichero $fichero.html
        exec touch $fichero
        return $fichero.html
    }

    return $fichero
}

###############################################################################
# Path_relativo
#    Esta funcin devuelve el path relativo desde el directorio actual, al
#    directorio raz.
# Parmetros:
#    El directorio en que se encuentra el fichero que va a ser preprocesado
# Devuelve:
#    El path relativo
###############################################################################
proc Path_relativo {path_absoluto} {
    global directorio_base

    set patron (?:$directorio_base/)(.*)
    regexp $patron $path_absoluto nada path
    if {![info exists path]} return

    set cuenta [regsub -all {/} $path {} ignorar]

    for {set i 0;set rel ""} {$i<$cuenta} {incr i} {
        append rel ../
    }
    return $rel
}

###############################################################################
# Preprocesado
#    Reads the Web page passed as a parameter and proccess it to extract
#    all links to local files and images it has
#
# Parameters:
#    file: file which contains the page to process
#
# Side efects:
#    'ficheroEnlace' keeps the links
#    'descripcionEnlace' the descripcion of the link
###############################################################################
proc Preprocesado {file} {
    global nEnlaces ficheroEnlace descripcionEnlace direccion directorio_local
    global opciones directorio_base vistos
    global labelTitles labelMessages labelDialogs

    if [string match $file ""] return
    set file [Adecentar_dir $file]
    set file [Adecentar_nombres $file]
puts "Fichero a preprocesar: $file"
    if [info exists vistos($file)] {
        set nEnlaces 0
        return
    }
    set vistos($file) 1
    set directorio_local [file dirname $file]
    if {[file exists $file.orig]} {
        set fichero $file.orig
    } else {
        set fichero $file
    }
    set nEnlaces  1
    set enlaces_absolutos 0
    set hay_url 0
    if [catch {open $fichero r} leer] {
        tk_messageBox -title $labelTitles(preError) -icon error\
            -message [concat $leer\n$labelMessages(notOpen)\n$fichero]
        set nEnlaces 0
        return
    }
    for {set cosa [gets $leer]} {(![eof $leer]) || ([string compare $cosa ""])} {if {![eof $leer]} {append cosa " " [gets $leer] " "} } {
#puts "\nCosa: $cosa\n"
        if {[regexp {^\ ?<!} $cosa]} {
            while {![regexp {(?:>)(.*)} $cosa nada cosa]} {
                append cosa " " [gets $leer]
            }
        }
        if {[regexp {^\ ?<script} $cosa]} {
            while {![regexp {(?:/script>)(.*)} $cosa nada cosa]} {
                append cosa " " [gets $leer]
            }
        }
        if {![regexp -nocase {(<)(a\ $|a\ +h|link|img|frame|area)} $cosa]} {
            set cosa ""
            continue
        }
        if [regexp -nocase  \
            {((?:<a[^>]+href *)|(?:<img[^>]+src *)|(?:<link[^>]+href *)|(?:<frame[^>]+src *))((?:= *)(?:\")?([^#\"\ >]+))(?:.*?>)(.*)} \
			    $cosa nada diff alt nombre_fichero cosa] {
#puts "\nNombre fichero\n"
            if {($opciones(filter)!="")&&([regexp -nocase "$opciones(filter)" $nombre_fichero])} {
                continue
            }
            if [info exists repetidos($nombre_fichero)] continue
            if {[regexp -nocase {^mailto:|^news:} $nombre_fichero]} continue
            if {([regexp {\?} $nombre_fichero])&&($opciones(cgi)==0)} continue
            if {[regexp {<!} $diff]} continue
            if [info exists vistos([Adecentar_nombres [Adecentar_dir [file join $directorio_base$direccion(dir) $nombre_fichero]]])] {
                continue
            }
            if [regexp -nocase {(?:http:)(/[^/].*)} $nombre_fichero nada nombre_fichero] {
                set hay_url 1
            }
            if {([string first :// $nombre_fichero]!=-1 ) } {
                regexp {(?:://)([^/]+)(?:/)?(.*)} $nombre_fichero nada direccion_www nombre_fichero
                if ![info exists direccion_www] {
                    tk_messageBox -title $labelTitles(error) -icon error \
                        -message [concat $labelMessages(noWWW) $nombre_fichero]
                    continue
                }
                if {[string compare [string tolower [string trimright $direccion(www) {/}]] [string tolower $direccion_www]]} continue
                set nombre_fichero /$nombre_fichero
                set hay_url 1
                set enlaces_absolutos 1
            }
            if {[regexp -nocase {href} $diff]==1} {
                if {($opciones(dir)==0)&&($direccion(base)!="")} {
                    if {![regexp -nocase "^(/)([string trimleft "$direccion(base)" "/"])"  \
                        [Adecentar_dir [file join $direccion(dir) $nombre_fichero]]]} {
                        continue
                    }
                }
                if {![regexp -nocase {^<area} $diff]} {
                    while {![regexp -nocase {(.*?)(</a *>)} $cosa nada descripcion]} {
                        append cosa " " [gets $leer]
                    }
                    set descripcionEnlace($nEnlaces) [Adecentar_descripcion $descripcion]
                } else {
                    set descripcionEnlace($nEnlaces) "Enlaces en un mapa"
                }
            } elseif [regexp -nocase {frame} $diff] {
                set descripcionEnlace($nEnlaces) "Marco: $nombre_fichero"
            } else {
                if {![regexp -nocase {(?:ALT *= *\")(.*?)(\")} $alt nada descrip]} {
                    if {![regexp -nocase {(?:src *= *\")(.*?)(\")} $alt nada descrip]} {
                        set descrip $nombre_fichero
                    }
	            }
                set descripcionEnlace($nEnlaces) "$labelDialogs(image): $descrip"
            }
            set ficheroEnlace($nEnlaces) [Adecentar_dir $nombre_fichero]
            set repetidos($nombre_fichero) 1

            if  [regexp {^/} $nombre_fichero] {
                set enlaces_absolutos 1
                set enlaces_completos($nEnlaces) $diff$nombre_fichero
            }
            incr nEnlaces
        } else {
             regexp -nocase {(?:[^<]*)(<.*)} $cosa nada cosa
        }
    }
    close $leer
#VerEnlaces
    Cambiar_pagina $file $hay_url

    return
}

###############################################################################
# Adecentar_nombres
#    Quita del path y nombre de un fichero cosas como '?' '~' '+' '-'
# Devuelve
#    El nombre sin esas cosas
###############################################################################
proc Adecentar_nombres {nombre} {

    regsub -all {~}  $nombre {} nombre
    regsub -all {\*} $nombre {} nombre

    if {[regexp {([^\?]+)(?:\?)(.*)} $nombre nada uno dos]} {
        regsub -all {\?} $dos {} dos
        regsub -all {\+} $dos {} dos
        regsub -all {\?} $dos {} dos
        regsub -all {/}  $dos {} dos
        regsub -all {\\} $dos {} dos
        set nombre $uno$dos
    }
    return $nombre
}

###############################################################################
# Adecentar_descripcion
#    Coge la descripcion en HTML del enlace y lo traduce para ojos humanos
# Parametros:
#    La descripcion a traducir
###############################################################################
proc Adecentar_descripcion {descripcion} {
    global labelDialogs

    if [regexp -nocase {^(<img)} $descripcion] {
        if {![regexp -nocase {(?:ALT *= *\")([^\"]+)} $descripcion nada descrip]} {
            regexp -nocase {(?:src *= *\")([^\"]+)} $descripcion nada descrip
        }
        set descripcion "$labelDialogs(linkImage): $descrip"
    }
    regsub -all {<.*?>}     $descripcion {}   descripcion
    regsub -all {&quot;}    $descripcion {\"} descripcion
    regsub -all {&#34;}     $descripcion {\"} descripcion
    regsub -all {&#39;}     $descripcion {'}  descripcion
    regsub -all {&lt;}      $descripcion {<}  descripcion
    regsub -all {&gt;}      $descripcion {>}  descripcion
    regsub -all {(&)(amp;)} $descripcion {\1} descripcion
    regsub -all {&ntilde;}  $descripcion {}  descripcion
    regsub -all {&aacute;}  $descripcion {}  descripcion
    regsub -all {&eacute;}  $descripcion {}  descripcion
    regsub -all {&iacute;}  $descripcion {}  descripcion
    regsub -all {&oacute;}  $descripcion {}  descripcion
    regsub -all {&uacute;}  $descripcion {}  descripcion

    return $descripcion
}

###############################################################################
# Elegidos
#    Seleccion automatica de los ficheros a bajar.
# Parametros:
#    patron: expresion regular que identifica el tipo de fichero.
#    cual: '1' para seleccionar, '0' para deseleccionar.
#    map: 1 en caso de estar con el mapa del site
###############################################################################
proc Elegidos {patron cual {map 0} } {
    global ficheroEnlace nEnlaces enlacesOk siteMap

    for {set i 1} {$i<$nEnlaces} {incr i} {
        if {$map==0} {
            if {[regexp -nocase $patron $ficheroEnlace($i)]} {
                set enlacesOk($i) $cual
            }
        } else {
            if {[regexp -nocase $patron $siteMap($i,1)]} {
                set enlacesOk($i) $cual
            }
        }
    }
    return
}

###############################################################################
# ElegirBajadas
#    Muestra un cuadro de dialogo con los ficheros con los que enlaza la pagina
#    para escoger cuales bajar.
#
# Parameter
#    map: '1' if we are getting the site map, defaults to '0'
#
# Efectos secundarios:
#    En la matriz 'enlacesOk' se guarda un '1' si ese fichero se ha de bajar y
#    un '0' en caso contrario.
###############################################################################
proc ElegirBajadas { {map 0} } {
    global ficheroEnlace nEnlaces enlacesOk descripcionEnlace
    global leido dirGetleft labelButton labelTitles labelDialogs
    global siteIndex siteMap

    if {$nEnlaces==1} "return 0"
    set elegir   [toplevel .elegir]
    set marco    [frame $elegir.marco]
    set marco_in [frame $elegir.marco.marco_interno]
    set botones  [frame $elegir.botones]
    set checks   [frame $elegir.checks]

    wm title $elegir $labelTitles(choose)

    set texto [text $marco_in.texto -yscrollcommand [list $marco_in.yscroll set] \
            -xscrollcommand [list $marco.xscroll set] -wrap none]
    set aceptar [button $botones.aceptar   -text $labelButton(ok)     -width 9 \
            -command "set leido 1"]
    set cancelar [button $botones.cancelar -text $labelButton(cancel) -width 9 \
            -command "set leido 0" ]

    set mas   [image create bitmap  -file [file join $dirGetleft images mas]]
    set menos [image create bitmap  -file [file join $dirGetleft images menos]]
    set lhtml [label  $checks.lhtml -text "  $labelDialogs(html)"]
    set htmla [button $checks.htmla -image $mas   -width 8 -height 8 \
            -command "Elegidos {(html$)|(htm$)|(/$)} 1 $map"]
    set htmle [button $checks.htmle -image $menos -width 8 -height 8 \
            -command "Elegidos {(html$)|(htm$)|(/$)} 0 $map"]
    set lima  [label $checks.lima   -text "  $labelDialogs(images)"]
    set imaa  [button $checks.imaa  -image $mas   -width 8 -height 8 \
            -command "Elegidos {(gif$)|(jpg$)|(bmp$)|(xbm$)|(tiff$)} 1 $map"]
    set imae  [button $checks.imae  -image $menos -width 8 -height 8 \
            -command "Elegidos {(gif$)|(jpg$)|(bmp$)|(xbm$)|(tiff$)} 0 $map"]
    set lcom  [label $checks.lcom   -text "  $labelDialogs(archives)"]
    set coma  [button $checks.cona  -image $mas   -width 8 -height 8 \
            -command "Elegidos {(tar$)|(gz$)|(z$)|(zip$)} 1 $map"]
    set come  [button $checks.cone  -image $menos -width 8 -height 8 \
            -command "Elegidos {(tar$)|(gz$)|(z$)|(zip$)} 0 $map"]
    set ltodo [label $checks.ltodo  -text "  $labelDialogs(all)"]
    set todoa [button $checks.todoa -image $mas   -width 8 -height 8 \
            -command "Elegidos {.} 1 $map"]
    set todoe [button $checks.todoe -image $menos -width 8 -height 8 \
            -command "Elegidos {.} 0 $map"]

    set color [$texto cget -background]

    if {$map==1} {
        set nEnlaces $siteIndex
    }
    for {set i 1} {$i<$nEnlaces} {incr i} {
        checkbutton $texto.enlaces$i -variable enlacesOk($i) -background $color
        set enlacesOk($i) 1

        $texto window create $i.0 -window $texto.enlaces$i
        if {$map==0} {
            $texto insert insert $descripcionEnlace($i)\n
        } else {
            for {set j 0 ; set spc "   " ; set pre ""} {$j<$siteMap($i,0)} {incr j} {
                append pre $spc
            }
            $texto insert insert $pre$siteMap($i,2)\n
        }
    }

    set barray [scrollbar $marco_in.yscroll -orient vertical \
        -command [list $texto yview]]
    set barrax [scrollbar $marco.xscroll -orient horizontal  \
        -command [list $texto xview]]

    pack $texto $barray -side left -fill y
    pack $barrax -side bottom -fill x
    pack $marco_in $marco
    pack $lhtml $htmla $htmle $lima $imaa $imae $lcom $coma $come \
        $ltodo $todoa $todoe -side left
    pack $aceptar $cancelar -side left
    pack $botones $checks -side bottom

    tkwait visibility $elegir

    grab $elegir
    tkwait variable leido
    grab release $elegir
    destroy $elegir

    return $leido
}

###############################################################################
# AbrirFichero
#    Creates, if needed, the directory in which the link will be saved.
#
# Parameter:
#    fichero: file name
#
# Returns:
#    Local file name
#    1: In case of error
###############################################################################
proc AbrirFichero {fichero} {
    global directorio_local directorio_base
    global labelTitles labelMessages

    if [regexp {(?:^/)(.*)} $fichero nada fichero] {
        set directorio_a_usar $directorio_base
    } else {
        set directorio_a_usar $directorio_local
    }

    set directorio [file dirname $fichero]
    if [file exists [file join $directorio_a_usar $directorio]] {
        if {![file isdirectory [file join $directorio_a_usar $directorio]]} {
            puts "La hemos fastidiado con los nombres: $fichero"
            return 1
        }
     } else {
        if [catch {file mkdir [file join $directorio_a_usar $directorio]} error] {
            tk_messageBox -title $labelTitles(error) -icon error \
                    -message $error
            return 1
        }
     }
     set fichero_a_bajar \
        [file join $directorio_a_usar ${fichero}.$labelMessages(downloading)]

     return $fichero_a_bajar
}

###############################################################################
# Bajar
#    Baja un enlace
# Parametro:
#    enlace:  enlace a bajar
#    fichero: handle al fichero en el que se va a guardar
#
# Devuelve:
#    - '2' si hay un error
#    - '1' si es una pagina HTML
#    - '0' si no
###############################################################################
proc Bajar {enlace fichero} {
    global direccion opciones

    set fichero [Adecentar_dir $fichero]
    set enlace  [Adecentar_dir $enlace]

    Ventana::Bajando_encabezamiento $enlace
    if {($::Ventana::Rizo::curlError!="")||($Ventana::Rizo::meta(codigo)>=400)} {
        ::Herramientas::ErrorLog $fichero $enlace
        return 2
    }

    if [string match $Ventana::Rizo::meta(contenido) "text/html"] {
        set esHtml 1
    } else {
        set esHtml 0
        if {$opciones(onlyHtml)==1} {
            return 0
        }
    }

    set Ventana::Rizo::informe(parar) 0
    Ventana::Bajando_archivo $fichero $enlace

    catch {tkwait window .bajando}
    if {$::Ventana::Rizo::curlError!=""} {
        ::Herramientas::ErrorLog $fichero $enlace
        return 2
    }

    set root [file rootname $fichero]
    catch {file rename -force $fichero $root}
    if {$esHtml==1} {
        catch {file delete $root.orig}
    }

    return $esHtml
}

###############################################################################
# Cambiar_pagina
#    Altera el contenido de una pgina de Web para que haya consistencia con
#    los directorios
#
# Parmetros
#    pagina: fichero con la pgina a cambiar
#    hay_url: '1' si hay que poner las direcciones de Web, '0' en caso contrario
###############################################################################
proc Cambiar_pagina {pagina hay_url} {
    global direccion ficheroEnlace nEnlaces
    global directorio_base

    set path_relativo [Path_relativo $pagina]
    set script [open "$directorio_base/script.sed" w+]
    if {$hay_url==1} {
        puts $script "s#http://$direccion(www)##g"
        puts $script "s#ftp://$direccion(www)##g"
        puts $script {s#\(http:/\)\([^/]\)#/\2#g}
    }

    if [string match $direccion(dir) "/"] {
        set dir ""
    } else {
        set dir $direccion(dir)
    }
    for {set i 1} {$i<$nEnlaces} {incr i} {
        if [regsub -all {~|\?|\*} $ficheroEnlace($i) {} nuevo_enlace] {
            regsub {\*|\?} $ficheroEnlace($i) {\\&} tmp
            regsub {&} $nuevo_enlace {\\\&} nuevo_enlace
            puts $script "s#=\"*$tmp\"*#=\"$nuevo_enlace\"#g"
        }
        if {![regexp {^/} $ficheroEnlace($i)]} {
            set tmp [Adecentar_dir [Adecentar_dir $dir]/[Adecentar_dir $ficheroEnlace($i)]]
            set conAmper $tmp
            if {![string match $tmp $ficheroEnlace($i)]} {
                regsub {&} $tmp {\\\&} tmp
                if [regexp {^\./} $ficheroEnlace($i)] {
                    puts $script "s#=\"*\\\$ficheroEnlace($i)\"*#=\"[Adecentar_nombres $tmp]\"#g"
                } else {
                    puts $script "s#=\"*$ficheroEnlace($i)\"*#=\"[Adecentar_nombres $tmp]\"#g"
                }
            }
            set ficheroEnlace($i) $conAmper
        }
    }
    puts $script "s#=\"/#=\"$path_relativo#g"
    puts $script "s#=/#=$path_relativo#g"

    close $script

    if {![file exists $pagina.orig]} {
        file copy $pagina $pagina.orig
        InvocarSed $pagina
    }

    return
}

###############################################################################
# InvocarSed
#    Call 'sed' to do the dirty job of changing the web pages.
#
# Parameters:
#    pagina: file containing the page to be changed.
#    expr:   (opcional), regular expression to be passed to 'sed'. If not given
#            'sed' will use the file 'script.sed'.
###############################################################################
proc InvocarSed {pagina {expr {}}} {
    global directorio_base
    global labelTitles

    if {$expr!=""} {
        set file [open "$directorio_base/script.sed" w+]
        puts $file $expr
        close $file
    }
    if [catch {exec sed -f "$directorio_base/script.sed"  $pagina > "$directorio_base/sed_temp"} error] {
        tk_messageBox -title $labelTitles(error) -message $error -type ok -icon error
    } else {
        file rename -force "$directorio_base/sed_temp" $pagina
    }
    file delete "$directorio_base/script.sed"

    return
}

###############################################################################
# ChangeLinkList
#    Changes or removes one link form the list that contains all the links of
#    one page
#
# Parameters:
#    linkList: list with the links
#    oldLink: link to change or remove
#    newLink: the new links, defaults to none to remove the old one.
#
# Returns
#    The new list
###############################################################################
proc ChangeLinkList {linkList oldLink {newLink {} } } {

    set index   [lsearch -exact $linkList $oldLink]
    if {$newLink!=""} {
        set linkList [lreplace $linkList $index $index $newLink]
    } else {
        set linkList [lreplace $linkList $index $index]
    }

    return $linkList
}

###############################################################################
# SaveSedExp
#    Saves one line of the sed script that will change the links to active
#    pages to the resulting page
#
# Parameter
#    exp: sed expresion to be saved
###############################################################################
proc SaveSedExp {exp} {
    global directorio_base

    set handle [open [file join $directorio_base script.sed] a+]
    puts $handle $exp
    close $handle

    return
}

###############################################################################
# ControlarBajar
#    Envia a 'Bajar' los ficheros escogidos uno a uno
#
# Parametros:
#    listaEnlaces: lista con los enlaces que hay que bajarse
#    nivelActual: nivel maximo de recursin
#    paginaMadre: pagina de la que sali la lista de enlaces
###############################################################################
proc ControlarBajar {listaEnlaces nivelActual paginaMadre} {
    global direccion directorio_local nEnlaces directorio_base
    global opciones

    set n_oks [llength $listaEnlaces]
    if {$n_oks==0} return

    set cosa ""
    set invocarSed 0

    set j 0
    foreach enlace  $listaEnlaces {
        update
        incr j

        if [regexp {/$} $enlace] {
            set fichero_a_abrir [file join [Adecentar_nombres $enlace] index.html]
            set es_html($j) 1
            set listaEnlaces [ChangeLinkList $listaEnlaces $enlace \
                    [file join $enlace index.html]]
        } else {
            set fichero_a_abrir [Adecentar_nombres $enlace]
        }
        set fichero [AbrirFichero $fichero_a_abrir]
        if {$fichero==1} {
            continue
        }
        if [regexp -nocase {(htm|html)$} $fichero_a_abrir] {
            set sufijo 1
        } else {
            set sufijo 0
        }
        if {[file exists [file root $fichero]]} {
            set es_html($j) $sufijo
            if {$sufijo==0} {
                if [file exists [file root $fichero].html] {
                    set es_html($j) 1
                    set listaEnlaces [ChangeLinkList $listaEnlaces \
                            $enlace $enlace.html]
                    SaveSedExp "s#\\($fichero_a_abrir\\)\\(\\ \\|\\\"\\)#$fichero_a_abrir.html\\2#g"
                    set invocarSed 1
                } else continue
            }
        } else {
            if [regexp {/$} $enlace] {
                set es_html($j) [Bajar $direccion(www)$enlace $fichero]
            } else {
                set dir_a_bajar $direccion(www)$enlace
                set es_html($j) [Bajar $dir_a_bajar $fichero]
                if {($es_html($j)==1)&&($sufijo==0)} {
                    set raiz_fichero [file rootname $fichero]
                    catch {file rename $raiz_fichero $raiz_fichero.html}
                    exec touch $raiz_fichero
                    set listaEnlaces [ChangeLinkList $listaEnlaces \
                            $enlace $enlace.html]
                    set enlace [file tail $enlace]
                    SaveSedExp "s#\\($enlace\\)\\(\\ \\|\\\"\\)#$enlace.html\\2#g"
                    set invocarSed 1
                }
            }
            if {$es_html($j)==2} {
                set listaEnlaces [ChangeLinkList $listaEnlaces $enlace]
                incr j -1
            }
        }
        if {$opciones(stopFile)==1} {
            return
        }
    }

    if {$invocarSed==1} {
        InvocarSed [Adecentar_nombres $paginaMadre]
    }

    set j 1
    foreach enlace $listaEnlaces {
        if {$es_html($j)==1} {
            set tmp_url   $direccion(dir)
            set tmp_local $directorio_local
            set dir_enlace [Adecentar_dir [file dirname $enlace]]
            if {$dir_enlace != "."} {
                set direccion(dir) [Adecentar_dir $dir_enlace]
            }
            set pagina_a_tratar "$directorio_base$enlace"
            if {(($nivelActual<$opciones(niv))||($opciones(niv)==-1))\
                    &&($opciones(stopFile)==0)&&($opciones(stopPage)==0)} {
                Preprocesado $pagina_a_tratar
                if {$nEnlaces!=1} {
                    Elegidos {.} 1
                    set nextLevel [expr $nivelActual +1]
                    ControlarBajar [PrepararBajar $nextLevel] $nextLevel \
                             $pagina_a_tratar
                }
            }
            set direcion(dir)    $tmp_url
            set directorio_local $tmp_local
        }
        incr j
    }
    return
}

###############################################################################
# PrepararBajar
#    Prepares the list of files to download
#
# Parameter
#    nivelActual: level of recursion
###############################################################################
proc PrepararBajar {nivelActual } {
    global ficheroEnlace nEnlaces descripcionEnlace enlacesOk
    global siteIndex siteMap opciones

    for {set i 1 ; set listaEnlaces ""} {$i<$nEnlaces} {incr i} {
        if {$enlacesOk($i)==1} {
            if {[lsearch $listaEnlaces $ficheroEnlace($i)] == -1} {
                lappend listaEnlaces $ficheroEnlace($i)
            }
        }
    }

    if {$opciones(map)==1} {
        for {set i 1} {$i<$nEnlaces} {incr i} {
            if {![info exists siteMap($ficheroEnlace($i))]} {
                set siteMap($siteIndex,0) $nivelActual
                set siteMap($siteIndex,1) $ficheroEnlace($i)
                set siteMap($siteIndex,2) $descripcionEnlace($i)
                set siteMap($ficheroEnlace($i)) 1
                incr siteIndex
            }
        }
    }

    return $listaEnlaces
}

###############################################################################
# Leer_sel
#    Saca del portapapeles la direccion a tratar
# Devuelve
#    La seleccion a sacar
###############################################################################
proc Leer_sel {} {
    if {[catch {selection get -selection CLIPBOARD} cosa]} {
        if {[catch {selection get} cosa]} return
    }
    return $cosa
}

###############################################################################
# IntroducirUrl
#    Creates a dialog box where you can write or paste the desired url.
###############################################################################
proc IntroducirUrl {} {
    global intro vistos nEnlaces opciones historial elementos ok
    global directorio_local hisIndex coord errorsFound
    global labelButton labelTitles labelMessages

    fijar_coordenadas

    set intro [toplevel .introducir]
    wm title $intro $labelTitles(enterUrl)
    wm resizable $intro 0 0
    wm geometry $intro +[expr $coord(x)+100]+[expr $coord(y)+50]

    set ok                 0
    set errorsFound        0
    set opciones(stopPage) 0
    set opciones(stopFile) 0

    set marcoEx [frame $intro.marcoEx]
    set marco   [frame $marcoEx.marco -bd 2 -relief groove]

    for {set i 0; set elementos ""} {$i<9} {incr i} {
        if [info exists historial($i)] {
            lappend elementos $historial($i)
        } else {
            break
        }
    }
    cuadro_combinado $marco.pagina [Leer_sel]

    set pagina $marco.pagina
    set botones  [frame $marcoEx.botones]
    set empezar  [button $intro.empezar  -text $labelButton(start) \
            -width 8 -command {set ok 1}]
    set cancelar [button $intro.cancelar -text $labelButton(cancel) \
            -width 8 -command {set ok 0}]

    bind $pagina.e <Return> "$empezar invoke"
    bind $pagina.e <Button-3> {
        Leer_sel %W
    }
    bind $empezar <Return> "$empezar invoke"

    pack $pagina -padx 20 -pady 20
    pack $marcoEx -ipadx 10 -ipady 5
    pack $marco -side bottom
    pack $cancelar -side right -padx 9 -pady 5
    pack $empezar -side right  -pady 5
    pack $botones -side right

    focus $pagina.e
    tkwait variable ok

    if {$ok==0} {
        destroy $intro
        return
    }

    set pagina_objetivo [$pagina.e get]
    destroy $intro
    if {$hisIndex==9} {
        set hisIndex 0
    } else {
        incr hisIndex
    }
    if {![EnHistorial $pagina_objetivo]} {
        set historial($hisIndex) $pagina_objetivo
        GuardarConfig
    }
    if [info exists vistos] {
        unset vistos
    }
    set nombre_fichero [InicializacionBajada $pagina_objetivo]
    if {![string compare $nombre_fichero ""]} return
    if {($opciones(niv)==0)||(![regexp -nocase "text/html" $Ventana::Rizo::meta(contenido)])} {
        tk_messageBox -icon info -title $labelTitles(theEnd) -type ok \
                -message $labelMessages(theEnd)
        return
    }
    set pagina_a_tratar [Adecentar_nombres $nombre_fichero]
    Preprocesado $pagina_a_tratar
    if {$nEnlaces==1} {
        tk_messageBox -icon info -title $labelTitles(noLinks) -type ok \
                -message $labelMessages(noLinks)
        return
    }
    set leido [ElegirBajadas]
    if {$leido==1} {
        ControlarBajar [PrepararBajar 0] 1 $pagina_a_tratar
        if {$opciones(map)==0} {
            tk_messageBox -icon info -title $labelTitles(theEnd) -type ok \
                    -message $labelMessages(theEnd)
            if {$errorsFound==1} {
                ::Herramientas::ShowErrorLog
            }
        }
    }
    unset vistos

    return
}

###############################################################################
# GetSiteMap
#    Downloads the html pages in a site, to extract the site map from them
###############################################################################
proc GetSiteMap {} {
    global siteIndex siteMap opciones
    global direccion enlacesOk labelMessages labelTitles errorsFound

    set opciones(map)       1
    set opciones(onlyHtml)  1
    set siteIndex           1
    catch {unset siteMap}

    IntroducirUrl

    set opciones(onlyHtml)  0
    set opciones(map)       0

    if {$siteIndex==1} {
        return
    }

    set leido [ElegirBajadas 1]
    set tmp $opciones(niv)
    set $opciones(niv) 0

    if {$leido==1} {
        for {set i 1} {$i<$siteIndex} {incr i} {
            if {$enlacesOk($i)==1} {
                set enlace $siteMap($i,1)
                if [regexp {/$} $enlace] {
                    set ficheroAbrir [file join [Adecentar_nombres $enlace] index.html]
                } else {
                    set ficheroAbrir [Adecentar_nombres $enlace]
                }
                set fichero [AbrirFichero $ficheroAbrir]
                if {$fichero==1} {
                    continue
                }
                if {[file exists [file root $fichero]]} {
                    continue
                } else {
                    Bajar $direccion(www)$enlace $fichero
               }
                if {$opciones(stopFile)==1} {
                    break
               }
            }
        }
        tk_messageBox -icon info -title $labelTitles(theEnd) -type ok \
                -message $labelMessages(theEnd)
    }
    if {$errorsFound==1} {
        ::Herramientas::ShowErrorLog
    }
    unset siteMap
    set opciones(niv) $tmp

    return
}

###############################################################################
# LeerConfig
#    Reads the configuration file
###############################################################################
proc LeerConfig {} {
    global historial hisIndex dirGetleft opciones
    global env tcl_platform

    if [regexp {Windows} $tcl_platform(os)] {
        set ficherorc [file join "$dirGetleft" getleft.ini]
    } else {
        set ficherorc [file join $env(HOME) .Getleft]
    }

    if [catch {open $ficherorc r} fichero] {
        exec touch $ficherorc
        set opciones(lang) en
        set hisIndex 0
        return 0
    }

    for {set enHistorial 0} {![eof $fichero]} {} {
        set linea [gets $fichero]
        if [regexp {^\[historial\]$} $linea] {
            gets $fichero
            for {set i 0} {$i<10} {incr i} {
                set historial($i) [gets $fichero]
                if [string match $historial($i) ""] {
                unset historial($i)
                break
                }
            }
            set enHistorial [incr i -1]
        }

        if [regexp {^\[hisIndex\]$} $linea] {
            gets $fichero
            set hisIndex [gets $fichero]
        }

        if [regexp {^\[proxy\]$} $linea] {
            gets $fichero
            set opciones(dirProxy) [gets $fichero]
            set opciones(proxy) 1
        }

        if [regexp {^\[language\]$} $linea] {
            gets $fichero
            set opciones(lang) [gets $fichero]
        }
    }
    close $fichero

    if {![info exists opciones(lang)]} {
        set opciones(lang) en
    }
    if {![info exists hisIndex]} {
        set hisIndex 0
    }

    return $enHistorial
}

###############################################################################
# GuardarConfig
#   Saves the configuration
###############################################################################
proc GuardarConfig {} {
    global historial hisIndex dirGetleft opciones
    global env tcl_platform
    global labelMessages labelTitles

    if [regexp {Windows} $tcl_platform(os)] {
        set ficherorc [file join $dirGetleft getleft.ini]
    } else {
        set ficherorc [file join $env(HOME) .Getleft]
    }

    if [catch {open  $ficherorc w+} fichero] {
        tk_messageBox -title $labelTitles(error) -icon Error \
            -message $labelMessages(saveConfig)
        return
    }

    puts $fichero "\[historial\]\n"
    for {set i 0} {$i<10} {incr i} {
        if {![catch {set historial($i)} ]} {
            puts $fichero $historial($i)
        }
    }

    puts $fichero "\n\[hisIndex\]\n"
    puts $fichero $hisIndex

    if [info exists opciones(dirProxy)] {
        puts $fichero "\n\[proxy\]\n"
        puts $fichero "$opciones(dirProxy)"
    }

    puts $fichero "\n\[language\]\n"
    puts $fichero "$opciones(lang)"

    close $fichero

    return
}

###############################################################################
# MostrarHistorial
#    Shows the url history
###############################################################################
proc MostrarHistorial {} {
    global historial hisIndex

    for {set i 0} {$i<10} {incr i} {
        if {![catch {set historial($i)} ]} {
            puts "$i: $historial($i)"
        }
    }
    return
}

###############################################################################
# EnHistorial
#    Checks whether the given url is already in the url history
#
# Parameter:
#    pagina: given url
#
# Returns:
#    1 if it is.
#    0 if it is not
###############################################################################
proc EnHistorial {pagina} {
    global historial

    for {set i 0} {$i<10} {incr i} {
        if [catch {regsub {(http://)||(ftp://)} $historial($i) {} una}] {
            return 0
        }
        regsub {(http://)||(ftp://)} $pagina {} dos

        if [string match $una $dos] {
            return 1
        }
    }
    return 0
}

###############################################################################
# ChangeLanguage
#    Changes the default language for the program
#
# Parameters:
#    lang: language to be used
###############################################################################
proc ChangeLanguage {lang} {
    global opciones

    set opciones(lang) $lang
    MenusEtiquetas $lang

    GuardarConfig

    return
}

###############################################################################
# MenusEtiquetas
#    Puts the labels into the menus.
#
# Parameters:
#    labFile: file with the labels in the, hopefully, desired language
###############################################################################
proc MenusEtiquetas {{labFile ""}} {
    global menus dirGetleft
    global labelButton labelTitles labelMessages labelDialogs labelMonths

    if {$labFile==""} {
        set labFile en
    }

    source [file join $dirGetleft Languages menus.$labFile]

    .menus      entryconfigure 1 -label $labelMenus(1)      ;   # File
    $menus(1)   entryconfigure 0 -label $labelMenus(1,0)    ;   # Intro Url
    $menus(1)   entryconfigure 1 -label $labelMenus(1,1)    ;   # Site Map
    $menus(1)   entryconfigure 3 -label $labelMenus(1,3)    ;   # Stop
    $menus(1,3) entryconfigure 0 -label $labelMenus(1,3,0)  ;   # After page
    $menus(1,3) entryconfigure 1 -label $labelMenus(1,3,1)  ;   # After file
    $menus(1)   entryconfigure 5 -label $labelMenus(1,5)    ;   # Exit

    .menus      entryconfigure 2 -label $labelMenus(2)      ;   # Options
    $menus(2)   entryconfigure 0 -label $labelMenus(2,0)    ;   # Up links
    $menus(2,0) entryconfigure 0 -label $labelMenus(2,0,0)  ;   # Follow
    $menus(2,0) entryconfigure 1 -label $labelMenus(2,0,1)  ;   # Ignore
    $menus(2)   entryconfigure 1 -label $labelMenus(2,1)    ;   # Levels
    $menus(2,1) entryconfigure 0 -label $labelMenus(2,1,0)  ;   # No limit
    $menus(2)   entryconfigure 2 -label $labelMenus(2,2)    ;   # Files filter
    $menus(2,2) entryconfigure 0 -label $labelMenus(2,2,0)  ;   # Only Html
    $menus(2,2) entryconfigure 1 -label $labelMenus(2,2,1)  ;   # Choose Filter
    $menus(2)   entryconfigure 3 -label $labelMenus(2,3)    ;   # CGI
    $menus(2)   entryconfigure 4 -label $labelMenus(2,4)    ;   # Use proxy

    .menus      entryconfigure 3 -label $labelMenus(3)      ;   # Tools
    $menus(3)   entryconfigure 0 -label $labelMenus(3,0)    ;   # Purge  files
    $menus(3)   entryconfigure 1 -label $labelMenus(3,1)    ;   # Restore orig
    $menus(3)   entryconfigure 2 -label $labelMenus(3,2)    ;   # Config proxy
    $menus(3)   entryconfigure 3 -label $labelMenus(3,3)    ;   # Language
    $menus(3,0) entryconfigure 0 -label $labelMenus(3,3,0)  ;   # Espaol
    $menus(3,0) entryconfigure 1 -label $labelMenus(3,3,1)  ;   # English
    $menus(3)   entryconfigure 4 -label $labelMenus(3,4)    ;   # Resource
    $menus(3)   entryconfigure 5 -label $labelMenus(3,5)    ;   # Resource2

    .menus      entryconfigure 4 -label $labelMenus(4)      ;   # Help
    $menus(4)   entryconfigure 0 -label $labelMenus(4,0)    ;   # Manual
    $menus(4)   entryconfigure 2 -label $labelMenus(4,2)    ;   # License
    $menus(4)   entryconfigure 4 -label $labelMenus(4,4)    ;   # About

    return
}

###############################################################################
# CrearMenus
#   Creates the menus, without putting the labels
###############################################################################
proc CrearMenus {} {
    global opciones dirGetleft menus

    menu .menus -relief flat

    set menus(1) [menu .menus.fichero      -tearoff 0]
    .menus add cascade -menu $menus(1) -underline 0
    set menus(2) [menu .menus.editar       -tearoff 0]
    .menus add cascade -menu $menus(2) -underline 0
    set menus(3) [menu .menus.herramientas -tearoff 0]
    .menus add cascade -menu $menus(3) -underline 0
    set menus(4) [menu .menus.help         -tearoff 0]
    .menus add cascade -menu $menus(4) -underline 0

    $menus(1) add command -command IntroducirUrl
    $menus(1) add command -command GetSiteMap
    $menus(1) add separator
    $menus(1) add cascade -menu $menus(1).stop
    $menus(1) add separator
    $menus(1) add command -command exit

    set menus(1,3) [menu $menus(1).stop -tearoff 0]
    $menus(1,3) add command -command "set opciones(stopPage) 1"
    $menus(1,3) add command -command "set opciones(stopFile) 1"

    $menus(2) add cascade -menu $menus(2).directorios
    $menus(2) add cascade -menu $menus(2).levels
    $menus(2) add cascade -menu $menus(2).filters
    $menus(2) add check   -variable opciones(cgi)   -onvalue 1 -offvalue 0
    $menus(2) add check   -variable opciones(proxy) -onvalue 1 -offvalue 0

    set opciones(cgi)  0

    set menus(2,0) [menu $menus(2).directorios -tearoff 0]
    $menus(2,0) add radio -variable opciones(dir) -value 1
    $menus(2,0) add radio -variable opciones(dir) -value 0
    set opciones(dir) 1

    set menus(2,1) [menu $menus(2).levels -tearoff 0]
    $menus(2,1) add radio -variable opciones(niv) -value -1
    for {set i 0} {$i<6} {incr i} {
        $menus(2,1) add radio -label $i -variable opciones(niv) -value $i
    }

    set menus(2,2) [menu $menus(2).filters -tearoff 0]
    $menus(2,2) add check -variable opciones(onlyHtml) -onvalue 1 -offvalue 0
    $menus(2,2) add command -command Herramientas::FilterFiles

    set opciones(niv) -1

    $menus(3) add command -command Herramientas::PurgarFicheros
    $menus(3) add command -command Herramientas::RestaurarOriginales
    $menus(3) add command -command Herramientas::ConfProxy
    $menus(3) add cascade -menu $menus(3).idiomas
    $menus(3) add command -command \
            "catch {source [file join $dirGetleft Getleft.tcl]}"
    $menus(3) add command -command "source [file join $dirGetleft Getleft.tcl]"

    set menus(3,0) [menu $menus(3).idiomas -tearoff 0]
    $menus(3,0) add command -command "ChangeLanguage es"
    $menus(3,0) add command -command "ChangeLanguage en"

    $menus(4) add command -command Ayuda::Manual
    $menus(4) add separator
    $menus(4) add command -command Ayuda::Licencia
    $menus(4) add separator
    $menus(4) add command -command Ayuda::AcercaDe

    MenusEtiquetas $opciones(lang)

    return
}

###############################################################################
#				PROGRAMA PRINCIPAL
############################################################################### 
wm title . "Getleft v 0.6"
wm geometry . 300x0
. config -menu .menus

LeerConfig
set opciones(filter) ""
set opciones(map) 0

CrearMenus
