###############################################################################
###############################################################################
#####                               Ccombinado.tcl
###############################################################################
# Este arhivo contiene un widget que hace de combobox
###############################################################################
# Copyright 1999 Jess, Andrs Garca. Licenced under the terms of the
# GNU license
###############################################################################

###############################################################################
# Cuadro_texto
#    Este procedimiento pone en el cuadro de texto el
#    valor seleccionado en el cuadro de lista desplegable borrando 
#    primero el elemento que hubiese en el cuadro de texto
###############################################################################
proc Cuadro_texto { v t } {
    if { [set idx [$v curselection ]]!="" } {
        $t delete 0 end
        $t insert 0 [$v get $idx]
    }
    return
}

###############################################################################
# Retira_lista
#    Este procedimiento elimina la ventana donde se 
#    pone el cuadro de lista desplegable
###############################################################################
proc Retira_lista { w } {
    grab release $w
    wm withdraw [winfo toplevel $w]
}

###############################################################################
# Saca_lista
#    Este procedimiento despliega la ventana donde se 
#    encuentra el cuadro de lista desplegable
#    Se le pasa como parametro el nombre de la ventana
###############################################################################
proc Saca_lista {w} {
    global elementos

#Guarda en 'd' el nombre de la ventana

    set d ${w}_desplegable
    set l $d.listado

#Si la ventana del cuadro de lista desplegable exite entonces la 
#elimina es decir la borra

    if {[winfo ismapped $d]} {
        grab release $d
        wm withdraw $d
    } else {
# Calcula la posicin donde se va a desplegar la lista a partir de
#la posicion donde esta ahora el cuadro combinado
        set x1 [expr [winfo rootx ${w}.fondo.boton]-\
                [winfo reqwidth $l.cuadro]]
        set y1 [expr [winfo rooty ${w}.fondo.boton]+\
                [winfo height ${w}.fondo.boton]]

#Pone la ventana en la poscion calculada antes y activa la ventana
        wm geometry $d +$x1+$y1
        wm deiconify $d
        raise $d
        focus $l.cuadro
        wm geometry $d +$x1+$y1
        update
        grab -global $d
    }
}

###############################################################################
# Seleccionado
#    Este procedimiento se ejecuta al pinchar dos veces seguidas en el
#    elemento que deseamos seleccionar y lo que hace es poner ese elemento
#    en el cuadro de texto y eliminar la ventana con el cuadro de lista
#    desplegable
###############################################################################
proc Seleccionado { w y } {

#Guarda en 'd' el nombre de la ventana

    set d ${w}_desplegable
    set l $d.listado

#Primero se suelta la ventana

    grab release $d

#Se borra todo lo del rectangulo y despues se inserta lo seleccionado

    ${w}.e delete 0 end
    ${w}.e insert 0 [$l.cuadro get [$l.cuadro nearest $y]]

#Se enfoca el rectangulo

    focus ${w}.e

#Se elimina la ventana desplegable

    Retira_lista $l

    return
}

###############################################################################
# Pulsada_tecla
#    Este procedimiento se ejecuta cuando teniendo el cuadro de lista ya
#    desplegado se pulsa la tecla return, con lo que el elemento que se
#    encuentra seleccionado en ese momento pasa al cuadro de texto y 
#    luego elimina la ventana desplegada
###############################################################################
proc Pulsada_tecla { w tipo } {

    set d ${w}_desplegable
    set l $d.listado

#Si 'tipo' es uno indica que la tecla pulsada es 'Return' y por lo
#tanto se debe poner el valor seleccionado en el cuadro de texto sino
#se considera que es 'Escape' y por lo tanto no se modifica el cuadro
#de texto

    if { $tipo==1 } {
        Cuadro_texto $l.cuadro ${w}.e
    }

#Enfoca el cuadro de texto del cuadro combinado y elimina la ventana
#deplegable

    focus ${w}.e
    Retira_lista $d

    return
}

###############################################################################
# Barra_desplazamiento
#    Este procedimiento elimina la barra de scroll si no
#    es necesaria en el cuadro de lista desplegable
###############################################################################
proc Barra_desplazamiento { listbox scrollbar } {

    set items [$listbox index end]
    set size [$listbox cget -height]
    if {$items <= $size} {
        pack forget $scrollbar
        $listbox configure -height $items
    } else {
        pack $scrollbar -side right -fill y
    }
}

###############################################################################
# cuadro_combinado
#    Este procedimiento crea el cuadro combinado que es aquel en le que se
#    puede introducir informacion directamente, o bien activar el cuadro 
#    de lista desplegable para seleccionar una de sus entradas.
#
# Parmetros:
#    w: nombre que va a tener el cuadro combinado
#    nombre: valor que va a aparecer preseleccionado
#
# Variable global:
#    elementos: lista con cada item a poner en la lista desplegable
###############################################################################
proc cuadro_combinado { w {nombre ""}} {
    global datos_lista elementos

#Lo primero que hace es determinar el cuadro combinado que es donde
#van a ir el cuadro de texto y el boton para el despiege del cuadro de
#lista

    set datos_lista(relief) raised
    set resultado [frame $w -relief sunken -bd 1]
    rename $w _$w

#Lo que hacemos es poner la variable ancho al valor que queremos que
#tengan el cuadro de texto y el cuadro de lista
   #====================
   # ANCHO DE LA LISTBOX
   #====================
    set ancho 50
    if { $resultado != {} } {
        if {[info comm flecha] == {}} {
            set flecha {
                #define flecha_width 15
                #define flecha_height 15
                static char flecha_text_bits[] = {
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0xf8, 0x03, 0xf0, 0x01, 0xe0, 0x00, 0x40, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00
                }
            }
            image create bitmap flecha -data [set flecha]
            unset flecha
        }

#Definicion de la ranura donde van a ir representados los datos
#Para cambiar el tamao del cuadro de texto se pone unicamente aqui en
#entry un width con el ancho deseado sino no se pone nada

        entry $w.e -bd 1 -relief flat -width $ancho -bg white
        frame $w.fondo -bg gray
        $w.e  insert 0 $nombre
        $w.e  selection range 0 end	
#Definicion de boton de despliegue del cuadro de lista 

        button $w.fondo.boton -image flecha -relief raised \
            -command "Saca_lista $w" -width 8 -height 10
        pack $w.e -side left -pady 1 -padx 1 -fill x
        pack $w.fondo -side right
        pack $w.fondo.boton -side bottom -pady 1 

#Aqui se definen las caracteristicas de la ventana que se va a usar
#como cuadro de lista desplegable. Se define como una ventan de alto
#nivel, despues con las tres formas de 'wm' se define que no se ponga
#una barra de titulo a la ventana, que es una ventana temporal y por
#ultimo que en estos momentos no se debe desplegar hasta que se mande

        set d ${w}_desplegable
        toplevel $d -relief raised -bd 1 -bg White
        wm overrideredirect $d 1
        wm transient $d
        wm withdraw $d

#En 'l' se guarda el nombre donde van a ir los elementos del listado
#y la barra de desplazamiento dentro de la ventana 'd'

        set l $d.listado
        frame $l 
        pack $l -expand yes -fill y

#Ahora se crea el cuadro de lista propiamente dicho es decir donde van
#a ir los elementos que podemos seleccionar as como la barra de 
#desplazamiento vertical

        scrollbar $l.barra -bd 1 -command "$l.cuadro yview"

#En este se define el ancho que queremos para la lista si se quiere
#el estandard no se pone el width con el ancho

        listbox $l.cuadro -yscroll "$l.barra set" -setgrid 1 -bg White \
            -relief sunken -width $ancho
        pack $l.barra -side right -fill y
        pack $l.cuadro -side left -expand 1 -fill both

#Pone una etiqueta a la ventana que se usa como cuadro de lista 
#desplegable, a la parte usada para poner los elementos y a la
#barra de desplazamiento

        set etiqueta [winfo name $w]_listado
        foreach q "$d $l $l.cuadro $l.barra" {
             bindtags $q [concat ${etiqueta} [bindtags $q]]
        }
        set numero [llength $elementos]
        if {$elementos != ""} {
            $l.cuadro delete 0 end
            foreach q $elementos {
                $l.cuadro insert end $q
                if { $q==$nombre } {
                    set i [lsearch $elementos $q]
                    $l.cuadro yview moveto [expr (double($i))/$numero]
                    tkListboxMotion $l.cuadro \ $i
                }
            }
        }
        bind $l.cuadro <Motion> "
            set datos_lista(y) %y
            tkListboxMotion %W \[%W index @%x,%y]
        "
        bind $l.cuadro <Enter> {
            tkCancelRepeat
        }
        bind $etiqueta <ButtonPress>  {
            foreach q {rootx rooty width height} {
                set $q [winfo $q %W]
            }
            if {(%X < $rootx) || (%X > ($rootx+$width)) || \
                     (%Y < $rooty) || (($rooty+$height) < %Y)} {
                Retira_lista %W
            }
        }
        bind $etiqueta <Return> "Pulsada_tecla [list $w] 1"
        bind $etiqueta <Escape> "Pulsada_tecla [list $w] 0"
        bind $l.cuadro <1> "Seleccionado [list $w] %y"
        bind ${w}.e <Down> "Saca_lista ${w}"
        bind $l.cuadro <Configure> "
            Barra_desplazamiento $l.cuadro $l.barra
        "
    }
}