###############################################################################
###############################################################################
##                        Herramientas.tcl
##
## Includes procedures to implement the commands in the 'Tools' and 'Options'
## menus.
##
## (c) 1999 Andrs Garca Garca.
## Distributed under the term of the GNU licence
###############################################################################
###############################################################################

namespace eval Herramientas {

###############################################################################
# ExtensionsDialog
#    Creates a dialog box to choose file extensions
#
# Parameters:
#    title: title of the dialog box
#
# Side effect:
#    Global variable 'bot' will contain the choosen extensions
#
# Returns:
#    1: if cancelled
###############################################################################
proc ExtensionDialog {title} {
    variable botonPulsado
    global coord labelButton labelTitles

    fijar_coordenadas

    set ext [toplevel .extDialog]
    wm title $ext $title
    wm resizable $ext 0 0
    wm geometry $ext +[expr $coord(x)+100]+[expr $coord(y)+50]

    set marcoExt [frame $ext.marcoext]
    set marcoRel [frame $marcoExt.marcoint -bd 2 -relief groove]
    set marcoInt [frame $marcoRel.marcoInt]
    set marcoIzq [frame $marcoInt.marcoIzq]
    set marcoCen [frame $marcoInt.marcoCen]
    set marcoDer [frame $marcoInt.marcoDer]
    set marcoBot [frame $ext.marcoBot]

    set izqArr   [frame $marcoIzq.arr]
    set izqCen   [frame $marcoIzq.cen]
    set izqAbj   [frame $marcoIzq.abj]
    set izqBot1  [checkbutton $izqArr.bot1 -variable bot(1) -onvalue "*.jpg" -offvalue ""]
    set izqEtq1  [label $izqArr.etq1 -text "*.jpg" -justify left]
    set izqBot2  [checkbutton $izqCen.bot2 -variable bot(2) -onvalue "*.gif" -offvalue ""]
    set izqEtq2  [label $izqCen.etq2 -text "*.gif"]
    set izqBot3  [checkbutton $izqAbj.bot3 -variable bot(3) -onvalue "*.ps" -offvalue ""]
    set izqEtq3  [label $izqAbj.etq3 -text "*.ps"]

    set cenArr   [frame $marcoCen.arr]
    set cenCen   [frame $marcoCen.cen]
    set cenAbj   [frame $marcoCen.abj]
    set cenBot1  [checkbutton $cenArr.bot4 -variable bot(4) -onvalue "*.pdf" -offvalue ""]
    set cenEtq1  [label $cenArr.etq4 -text "*.pdf"]
    set cenBot2  [checkbutton $cenCen.bot5 -variable bot(5) -onvalue "*.txt" -offvalue ""]
    set cenEtq2  [label $cenCen.etq5 -text "*.txt"]
    set cenBot3  [checkbutton $cenAbj.bot6 -variable bot(6) -onvalue "*.mov" -offvalue ""]
    set cenEtq3  [label $cenAbj.etq6 -text "*.mov"]

    set derArr   [frame $marcoDer.arr]
    set derCen   [frame $marcoDer.cen]
    set derAbj   [frame $marcoDer.abj]
    set derBot1  [checkbutton $derArr.bot7 -variable bot(7) -onvalue "*.avi" -offvalue ""]
    set derEtq1  [label $derArr.etq1 -text "*.avi"]
    set derBot2  [checkbutton $derCen.bot8 -variable bot(8) -onvalue "*.zip" -offvalue ""]
    set derEtq2  [label $derCen.etq2 -text "*.zip"]
    set derBot3  [checkbutton $derAbj.bot9 -variable bot(9) -onvalue "*.tgz" -offvalue ""]
    set derEtq3  [label $derAbj.etq3 -text "*.tgz"]

    if {$title!=$labelTitles(exclude)} {
        foreach {index cadena} {1 *.jpg 2 *.gif 3 *.ps 4 *.pdf 5 \
                *.txt 6 *.mov 7 *.avi 8 *.zip 9 *.tgz} {
            set ::bot($index) $cadena
        }
    } else {
        for {set i 1} {$i<10} {incr i} {
            set ::bot($i) ""
        }
    }

    set aceptar  [button $marcoBot.aceptar  -text $labelButton(ok)    \
		-width 8 -command "set Herramientas::botonPulsado 1"]
    set cancelar [button $marcoBot.cancelar -text $labelButton(cancel) \
		-width 8 -command "set Herramientas::botonPulsado 0"]

    bind  $aceptar  <Key-Return> "$aceptar  invoke"
    bind  $cancelar <Key-Return> "$cancelar invoke"

    pack $marcoExt -ipadx 10 -ipady 5
    pack $marcoRel -ipadx 15 -side bottom
    pack $marcoInt
    pack $marcoIzq -pady 15 -side left
    pack $marcoCen -pady 15 -padx 10 -side left
    pack $marcoDer -pady 15 -side left

    pack $izqArr $izqCen $izqAbj -fill x
    pack $izqBot1 $izqEtq1 -side left
    pack $izqBot2 $izqEtq2 -side left
    pack $izqBot3 $izqEtq3 -side left

    pack $cenArr $cenCen $cenAbj -fill x
    pack $cenBot1 $cenEtq1 -side left
    pack $cenBot2 $cenEtq2 -side left
    pack $cenBot3 $cenEtq3 -side left

    pack $derArr $derCen $derAbj -fill x
    pack $derBot1 $derEtq1 -side left
    pack $derBot2 $derEtq2 -side left
    pack $derBot3 $derEtq3 -side left

    pack $marcoBot
    pack $aceptar $cancelar -side left -pady 5 -padx 5

    tkwait variable Herramientas::botonPulsado
    destroy $ext
    if {$botonPulsado==0} {
        return 1
    }

    return
}

###############################################################################
# PurgarFicherosDir
#    Sweeps a directory turning files to size 0
#
# Parameters:
#    dir: directory to be processed
#    purgarCmd: extensions of the files to minimize
###############################################################################
proc PurgarFicherosDir {dir purgarCmd} {
    global dirGetleft tcl_platform

    cd $dir
    set archivos ""
    foreach ext $purgarCmd {
        set archivos [concat $archivos [glob -nocomplain $ext]]
    }

    foreach file $archivos {
        file stat $file estado
        if {$estado(size)!=0} {
            file delete -force $file
            if [regexp {Windows} $tcl_platform(os)] {
                exec [file join $dirGetleft touch] $file
            } else {
                exec touch $file
            }
        }
    }

    set archivos [glob -nocomplain *]
    set directorios ""
    foreach file $archivos {
        if [file isdirectory $file] {
            lappend directorios $file
        }
    }

    foreach dir $directorios {
	  update
        PurgarFicherosDir $dir $purgarCmd
        cd ..
    }
    return
}

###############################################################################
# PurgarFicheros
#    The procedures takes care of recursively clean directories of files
#    with certain extensions *.jpg, *.gif, etc.
###############################################################################
proc PurgarFicheros {} {
    global labelTitles labelMessages

    if {[ExtensionDialog $labelTitles(purge)]==1} {
        return
    }

    set dir [Dialogos::SeleccionarDirectorio]
    if {![string compare $dir ""]} {
        return
    }

    set dirTmp [pwd]
    for {set i 1;set purgarCmd ""} {$i<10} {incr i} {
        append purgarCmd $::bot($i) " "
    }

    PurgarFicherosDir $dir $purgarCmd

    tk_messageBox -title $labelTitles(theEnd) -icon info \
        -message $labelMessages(purged)

    cd $dirTmp

    return
}

###############################################################################
# RestaurarOriginalesDir
#    Recursively restores the original files.
#
# Parameter:
#    dir: directory in which it will begin to restore.
###############################################################################
proc RestaurarOriginalesDir {dir} {

    cd $dir
    set directorio [glob -nocomplain *.orig]
    foreach fichero $directorio {
        file rename -force $fichero [file root $fichero]
    }

    set listaFicheros [glob -nocomplain *]
    set directorios ""
    foreach fichero $listaFicheros {
        if [file isdirectory $fichero] {
            lappend directorios $fichero
        }
    }
 
    foreach dir $directorios {
	    RestaurarOriginalesDir $dir
        cd ..
    }
    return
}

###############################################################################
# RestaurarOriginales
#    Starts the process of restoring the original files downloaded from Web
#    pages.
###############################################################################
proc RestaurarOriginales {} {
    global labelTitles labelMessages

    set dir [Dialogos::SeleccionarDirectorio]
    if {![string compare $dir ""]} {
        return
    }
    set dirTmp [pwd]
    RestaurarOriginalesDir $dir

    tk_messageBox -title $labelTitles(theEnd) -icon info \
            -message $labelMessages(restored)

    cd $dirTmp

    return
}

###############################################################################
# ConfProxy
#    Allows the user to enter his proxy data.
###############################################################################
proc ConfProxy {} {
    global ok coord opciones labelButton labelTitles
    variable ip
    variable n
    variable p

    fijar_coordenadas

    set proxy [toplevel .proxy]
    wm title $proxy $labelTitles(proxy)
    wm resizable $proxy 0 0
    wm geometry  $proxy +[expr $coord(x)+100]+[expr $coord(y)+50]

    set ok 0

    set marcoEx [frame $proxy.marcoEx]
    set marco   [frame $marcoEx.marco -bd 2 -relief groove]
    set marcoIn [frame $marco.marcoIn]

    set ip(1)  [entry $marcoIn.1 -width 3 -bg white -justify  right]
    set ip(2)  [entry $marcoIn.2 -width 3 -bg white -justify  right]
    set ip(3)  [entry $marcoIn.3 -width 3 -bg white -justify  right]
    set ip(4)  [entry $marcoIn.4 -width 3 -bg white -justify  right]
    set ip(5)  [entry $marcoIn.5 -width 4 -bg white]
    set punto1 [label $marcoIn.punto1 -text \n. -width 1]
    set punto2 [label $marcoIn.punto2 -text \n. -width 1]
    set punto3 [label $marcoIn.punto3 -text \n. -width 1]
    set colon  [label $marcoIn.colon  -text : -width 2]

    set botones  [frame  $proxy.botones]
    set aceptar  [button $botones.aceptar  -text $labelButton(ok)     \
            -width 8 -command {set ok 1}]
    set cancelar [button $botones.cancelar -text $labelButton(cancel) \
            -width 8 -command {set ok 0}]

    pack $cancelar -side right -padx 9 -pady 5
    pack $aceptar  -side right -pady 5
    pack $botones  -side bottom -fill x

    pack $ip(1) $punto1 $ip(2) $punto2 $ip(3) $punto3 $ip(4) $colon $ip(5) -side left
    pack $marcoIn -padx 10 -pady 10
    pack $marco -side bottom
    pack $marcoEx -ipadx 10 -ipady 5

    focus $ip(1)

    bind $aceptar  <Return> "$aceptar invoke"
    bind $cancelar <Return> "$cancelar invoke"

    for {set i 1;set n 2} {$i<6} {incr i;incr n} {
        if {$i!=5} {
            bind $ip($i) <Return> "focus $ip($n)"
            bind $ip($i) <Key-Right> {
                %W selection range 0 0
                set indice [%W index insert]
                set final  [%W index end]
                if {($indice==3)||($indice==$final)} {
                    focus $::Herramientas::ip([expr [winfo name %W] +1])
                }
            }
            bind $ip($i) <KeyRelease> {
                if {("%K"=="Left")||("%K"=="Right")||("%K"=="Tab")} {
                    break
                }
                if {[%W index insert]==3} {
                    focus $::Herramientas::ip([expr [winfo name %W] +1])
                }
            }
            bind $ip($i) <KeyPress> {
                if {[%W index end]==3} {
                    if {("%K"!="Left")&&("%K"!="Right")&&("%K"!="Return")&&("%K"!="Tab")&&("%K"!="Delete")&&("%K"!="BackSpace")} {
                        break
                    }
                }
            }
        } else {
            bind $ip($i) <KeyPress> {
                if {[%W index end]==4} {
                    if {("%K"!="Left")&&("%K"!="Return")&&("%K"!="Tab")&&("%K"!="Delete")&&("%K"!="BackSpace")} {
                        break
                    }
                }
            }
            bind $ip($i) <KeyRelease> {
                if {[%W index insert]==4} {
                    focus .proxy.botones.aceptar
                }
            }
            bind $ip($i) <Return> "
                focus $aceptar
            "
        }
        if {$i!=1} {
            bind $ip($i) <Key-Left> {
                %W selection range 0 0
                if {[%W index insert]==0} {
                    focus $::Herramientas::ip([expr [winfo name %W] -1])
                }
            }
        }
        bind $ip($i) <FocusIn> "$ip($i) selection range 0 end"
    }

    if [info exists opciones(dirProxy)] {
        regexp {([^\.]+)(?:\.)([^\.]+)(?:\.)([^\.]+)(?:\.)([^\.]+)(?::)(.*)} \
                 $opciones(dirProxy) nada ip1 ip2 ip3 ip4 ip5
        $ip(1) insert insert $ip1
        $ip(2) insert insert $ip2
        $ip(3) insert insert $ip3
        $ip(4) insert insert $ip4
        $ip(5) insert insert $ip5
    }

    tkwait variable ok

    if {$ok==1} {
        for {set i 1} {$i<6} {incr i} {
            set dirProxy($i) [$ip($i) get]
        }
        set opciones(dirProxy) "$dirProxy(1).$dirProxy(2).$dirProxy(3).$dirProxy(4):$dirProxy(5)"
        GuardarConfig
    }

    destroy $proxy
    return
}

###############################################################################
# FilterFiles
#    You can choose which file extensions will be ignored while downloading a
#    Web site.
#
# Side effects:
#    If a filter is chosen the global variable 'options(onlyHtml)' is reset,
#    while 'options(filter)' will contain a regular expression that will be
#    used to filter the links.
###############################################################################
proc FilterFiles {} {
    global opciones labelTitles labelMessages

    if {[ExtensionDialog $labelTitles(exclude)]==1} {
        return
    }

    set opciones(onlyHtml) 0

    for {set i 1;set filter ""} {$i<10} {incr i} {
        if {$::bot($i)!=""} {
            append filter ($::bot($i)$) "|"
        }
    }
    regsub -all {(\*\.)} $filter {} filter
    regexp {(.*)(\|)} $filter nada filter

    set opciones(filter) $filter

    return
}

###############################################################################
# ErrorLog
#    Logs in the file 'Geterror.log' the error messages returned by 'curl'
#
# Parameters
#    file: file in which the error occured
#    link: link that we where trying to download
###############################################################################
proc ErrorLog {file link} {
    global dirGetleft env tcl_platform errorsFound
    global labelDialogs labelMonths

    if [regexp {Windows} $tcl_platform(os)] {
        set errorLog [file join "$dirGetleft" Geterror.log]
    } else {
        set errorLog [file join $env(HOME) Geterror.log]
    }

    set handle [open $errorLog a+]
    set seconds [clock seconds]
    set month $labelMonths([clock format $seconds -format %B])
    puts $handle "[clock format $seconds -format "%d-$month-%Y -- %H:%M"]"
    puts $handle "$labelDialogs(errorLink) $link"
    puts $handle "$labelDialogs(errorFile) [file root $file]"
    if {$Ventana::Rizo::meta(codigo)>=400} {
        puts -nonewline $handle  \
                "$labelDialogs(errorCode) $::Ventana::Rizo::meta(codigo), "
        puts $handle "$labelDialogs(errorMess) $::Ventana::Rizo::meta(error)"
    } else {
        puts -nonewline $handle  \
                "$labelDialogs(errorCode) $::Ventana::Rizo::curlError, "
        puts $handle "$labelDialogs(errorMess) $::Ventana::Rizo::mensaje_error"
    }
    puts $handle ""

    close $handle

    set errorsFound 1

    return
}

###############################################################################
# EraseErrorLog
#    Deletes the error log.
###############################################################################
proc EraseErrorLog {} {
    global dirGetleft env tcl_platform

    if [regexp {Windows} $tcl_platform(os)] {
        set errorLog [file join "$dirGetleft" Geterror.log]
    } else {
        set errorLog [file join $env(HOME) Geterror.log]
    }

    file delete $errorLog

    return
}

###############################################################################
# ShowErrorLog
#    In case of error during a download, this procedures show a window with
#    the contents of the error log.
###############################################################################
proc ShowErrorLog {} {
    global dirGetleft env tcl_platform
    global labelDialogs labelMonths labelTitles

    if [regexp {Windows} $tcl_platform(os)] {
        set errorLog [file join "$dirGetleft" Geterror.log]
    } else {
        set errorLog [file join $env(HOME) Geterror.log]
    }

    if [file exists $errorLog] {
        Ayuda::CrearVentana $labelTitles(errorLog) $errorLog 1
    }
    return
}

}
