##############################################################################
##############################################################################
#                               Rizo.tcl
# If this file are implemented the procedures to actually do the downloading
# by executing 'curl'.
##############################################################################
# Copyright 1999 Andrs Garca Garca. Licenced under the terms of the GPL
# license
##############################################################################
##############################################################################
namespace eval Rizo {
    variable mensaje_error ""
    variable meta
    variable informe

##############################################################################
# Comun
#    Este procedimiento se encarga de inicializar las variables y de invocar
#    a 'curl' para todos los tipos de peticiones
#
# Parmetros:
#    args: argumentos que se pasarn a curl
#    tipo: el tipo de la operacin que se va a realizar:
#           - cab: baja en encabezamiento del enlace
#           - dat: baja el enlace en s
##############################################################################
    proc Comun {args tipo} {
        variable error 0
        variable informe
        variable rizo
        variable meta
        global opciones

        set informe(largo)          0
        set informe(detener)        0
        set informe(fin)            0
        set informe(largo)          0
        set informe(velocidad)      0
        set curlError               0

        if {$opciones(proxy)==1} {
            set curlCmd [concat curl -x $opciones(dirProxy) $args]
        } else {
            set curlCmd [concat curl $args]
        }
puts $curlCmd
        eval {set pipe [open "| $curlCmd |& cat" r]}

        fileevent $pipe readable [list [namespace code Lector] $pipe $tipo]
        fconfigure $pipe -blocking 0

        return
    }

###############################################################################
# Cabeza
#    Realiza una peticin HEAD al servidor de que se trate
#
# Parmetros:
#    enlace: url de enlace a bajar
###############################################################################
    proc Cabeza {enlace} {
        variable rizo
        variable meta
        variable informe

        set meta(contenido) ""
        set meta(bytes_total) 0

        set args [list -I $enlace]
        Comun $args cab

        return
    }

###############################################################################
# Datos
#   Se baja una url dada
#
# Parmetros:
#   fichero: nombre absoluto del fichero donde se guardarn los datos
#   enlace: url del enlace a bajar
###############################################################################
    proc Datos {fichero enlace} {
        variable rizo
        variable informe

        set informe(porcentaje) 0

        set args [list -o $fichero $enlace]
        Comun $args dat

        return
    }

###############################################################################
# Reanudar
#    Reanuda, si el servidor lo permite, la bajada de un enlace
#
# Parmetros
#    fichero: nombre absoluto del fichero donde se va a guardar
#    enlace: url del enlace a bajar
###############################################################################
    proc Reanudar {fichero enlace} {
        variable rizo

        set args [list -c -o $fichero $enlace]
        Comun $args dat

        return
    }

###############################################################################
# Lector
#   Procedimiento que se encarga de controlar la bajada de los ficheros, se le
#   invoca cada vez que haya algo que procesar.
#
# Parmetros:
#   pipe: tuberia que se utiliz para invocar a 'curl'
#   tipo: tipo de la peticin al servidor
###############################################################################
    proc Lector {pipe tipo} {
        variable meta
        variable informe
        variable curlError
        global errorCode
	  global dirGetleft 

        if {([eof $pipe]) || ($informe(parar)==1) || ($informe(detener)==1)} {
            if {[eof $pipe]} {
                set informe(fin) 1
                set informe(parar) 1
                set informe(velocidad) 0
            }
		set errorCode ""
            catch {close $pipe}
            set curlError [lindex $errorCode 2]
            if {$curlError!=""} {
                puts "Cdigo de error: $curlError"
            }
            return
        }
        if {[gets $pipe line]>=0} {
            if {[string first curl $line]!=-1} {
                set Ventana::Rizo::mensaje_error $line
                return
            }
            if [string match $line ""] return
            if {$tipo=="cab"} {
puts $line
                regexp -nocase {^(?:HTTP/)([0-9].[0-9])(?:\ )([0-9]*)(.*)} \
                        $line nada meta(version) meta(codigo) meta(error)
                regexp -nocase {^(?:Location: )(.*)}                   \
                        $line nada meta(situacion)
                regexp -nocase {^(?:Date: )(.*)}                       \
                        $line nada meta(fecha)
                regexp -nocase {^(?:Content-Length: )(.*)}             \
                        $line nada meta(bytes_total)
                regexp -nocase {^(?:Content-Type: )(.*)}               \
                        $line nada meta(contenido)
            } else {
                if {[string first % $line]!=-1} {
                    set informe(largo) 1
                    return
                }
                if {$informe(largo)==1} {
                    set informe(porcentaje) [lindex $line 0]
                    set informe(velocidad)  [lindex $line 6]
                } else {
                    regexp {(^.*?)(?: )(?:.*\()(.*)( )} $line nada informe(van_bytes) informe(velocidad)
                    if [catch {expr $informe(van_bytes)*100.0/$meta(bytes_total)} informe(porcentaje)] {
                        set informe(porcentaje) 0
                    } else {
			            set informe(porcentaje) [expr round($informe(porcentaje))]
                    }
                    if {$informe(van_bytes)<512} {
                        set informe(van_bytes) "[format "%.0f" $informe(van_bytes)] bytes"
                    } elseif {$informe(van_bytes)<1048576} {
                        set informe(van_bytes) "[format "%.2f" [expr $informe(van_bytes)/1024.0]] k"
                    } else {
                        set informe(van_bytes) "[format "%.2f" [expr $informe(van_bytes)/1048576.0]] M"
                    }
                }
                if {![regexp {/} $informe(velocidad)]} {
                    if {($informe(velocidad)>512)} {
                        set informe(velocidad) "[format "%.2f" [expr $informe(velocidad)/1024.0]] k/s"
                    } else {
                        set informe(velocidad) "[format "%.2f" $informe(velocidad)] bytes/s"
                    }
                }
                if {$informe(largo)==1} {
                    set informe(queda) "[lindex $line 4] ( $informe(velocidad) )"
                } else {
                    set informe(queda) "$informe(van_bytes) ( $informe(velocidad) )"
                }
            }
        }
    }
    return
}
