##############################################################################
##############################################################################
#####                            Ventana.tcl
##############################################################################
##### Creates the window which will provide some information to the user 
##### while a file is being downloaded.
##############################################################################
##### Copyright 1999 Andrs Garca Garca
##### The contents of this file are distributed under the terms of the GNU
##### license
##############################################################################

namespace eval Ventana {

source [file join $dirGetleft scripts Rizo.tcl]

variable estadoVentana 1

##############################################################################
# RecortarCadena
#    Recorta el nombre del fichero o del enlace para que cuadre con el espacio
#    que hay para escribirlos.
#
# Parmetros
#    cadena: cadena con el nombre a recortar
#    long: longitud en la que tiene que quedar
#
# Devuelve:
#    La cadena recortada
##############################################################################
proc RecortarCadena {cadena long} {

    set longitud_cadena [string length $cadena]
    if {$longitud_cadena>$long} {
        set index [expr round($long/2)-2]
        set fin   [expr $longitud_cadena-$index]
        set primer [string range $cadena 0 $index]
        set segun  [string range $cadena $fin end]
        append tmp $primer "..." $segun
        return $tmp
    } else {
        return $cadena
    }
}

##############################################################################
# CrearVentana
#    Creates the window, in which some info about the downloading will be
#    displayed.
##############################################################################
proc CrearVentana {} {
    global Ventana::Rizo::meta Ventana::Rizo::mensaje_error
    global file link coord labelButton labelTitles labelDialogs
    variable estadoVentana

    set bajando [toplevel .bajando]
    wm title $bajando $labelTitles(download)

    fijar_coordenadas
    wm geometry $bajando 290x155+[expr $coord(x)+200]+[expr $coord(y)+75]
    wm resizable $bajando 0 0

    if {$estadoVentana==0} {
        wm iconify $bajando
    }

    set marco     [frame $bajando.marco]
    set marco_in  [frame $bajando.marco.marco_interno]
    set marco_url [frame $marco_in.url]
    set marco_fic [frame $marco_in.fic]
    set marco_por [frame $marco_in.por]
    set marco_que [frame $marco_in.que]
    set marco_bar [frame $marco_in.bar]
    set botones   [frame $bajando.botones]

    set etq_url [label $marco_url.etq_url -text "$labelDialogs(url) "]
    set etq_fic [label $marco_fic.etq_fic -text "$labelDialogs(file) "]
    set etq_por [label $marco_por.etq_por -text "%: "]

    set Ventana::Rizo::informe(cual) "$labelDialogs(left) "
    set etq_que  [label $marco_que.etq_que -textvariable Ventana::Rizo::informe(cual)]
    set etq_url2 [label $marco_url.etq_url2 -bd 2 -relief sunken -width 45 -anchor w]
    set etq_fic2 [label $marco_fic.etq_fic2 -anchor w]
    set etq_por2 [label $marco_por.etq_por2 -textvariable Ventana::Rizo::informe(porcentaje) -width 5 -anchor w]
    set etq_que2 [label $marco_que.etq_que2 -textvariable Ventana::Rizo::informe(queda) -width 30 -anchor w]

    set barra [canvas $marco_bar.lienzo -width 275 -height 10 -bg white -bd 2 -relief sunken]

    set pausa [button $botones.pausa -text $labelButton(pause)    \
        -command "Ventana::Bajando_parar pausa $file $link" -width 8]
    set cancelar [button $botones.cancelar -text $labelButton(cancel) \
        -command "set Ventana::Rizo::informe(parar) 1" -width 8]

    pack $marco   -side top    -fill x -expand true
    pack $botones -side bottom -fill x -expand true -padx 7
    pack $marco_in -padx 10 -pady 10
    pack $marco_url $marco_in $marco_fic $marco_por $marco_que $marco_bar -fill x -expand true
    pack $etq_url $etq_url2 -side left
    pack $etq_fic $etq_fic2 -side left
    pack $etq_por $etq_por2 -side left
    pack $etq_que $etq_que2 -side left
    pack $barra

    pack $cancelar $pausa -side right -padx 3 -pady 5

    bind $cancelar <Unmap> {
        set Ventana::estadoVentana 0
    }
    bind $cancelar <Visibility> {
        set Ventana::estadoVentana 1
    }
    bind $pausa  <Return> "
        $pausa invoke
    "
    bind $cancelar <Return> "
        $cancelar invoke
    "
    return
}

##############################################################################
# Bajando_archivo
#   Crea una bonita ventana con informacin de cmo va la bajada de un fichero
#
# Parmetros:
#    fichero: fichero donde se va a guardar el fichero a bajar
#    enlace: url del fichero.
##############################################################################
proc Bajando_archivo {fichero enlace} {
    global file link tcl_platform directorio_base
    variable estadoVentana

    if {![winfo exists .bajando]} {
        set file $fichero
        set link $enlace
        CrearVentana
    } else {
        if {$estadoVentana==1} {
            wm deiconify .bajando
	  } else {
            wm iconify .bajando
        }
    }        

    set Ventana::Rizo::informe(fin)          0
    set Ventana::Rizo::informe(largo)        1
    set Ventana::Rizo::informe(queda)        ""
    set Ventana::Rizo::informe(detener)      0

    if [regexp {Windows} $tcl_platform(os)] {
        set anchoEnt 46
        set anchoEtq 42
    } else {
        set anchoEnt 37
        set anchoEtq 33
    }

    set etqUrl .bajando.marco.marco_interno.url.etq_url2
    $etqUrl configure -text [RecortarCadena $enlace $anchoEnt]

    regexp (?:$directorio_base)(.*) [file rootname $fichero] nada tmp

    set etqFic .bajando.marco.marco_interno.fic.etq_fic2
    $etqFic configure -text [RecortarCadena $tmp $anchoEtq]

    Ventana::Rizo::Datos $fichero $enlace

    Barra_actualizar .bajando.marco.marco_interno.bar.lienzo

    return
}

############################################################################
# Bajando_encabezamiento
#    Solicita al servidor el encabezamiento de la pgina
#
# Parmetros
#    La pgina a bajar
############################################################################
proc Bajando_encabezamiento {enlace} {

    set Ventana::Rizo::informe(parar) 0
    Ventana::Rizo::Cabeza $enlace
    tkwait variable Ventana::Rizo::informe(parar)

    return
}

#############################################################################
# Bajando_parar
#    Dirige las operaciones en caso de que se cancele una bajada.
#
# Parmetros:
#    cual: 'pausa' se hace una pausa temporal.
#          'cancelar' se para definitivamente todo el proceso.
#    fichero: fichero en el que se est guardando.
#    enlace: url que se est bajando.
#############################################################################
proc Bajando_parar {cual fichero enlace} {
    global labelButton

    switch $cual {
        pausa {
            set Ventana::Rizo::informe(detener) 1
            set boton ".bajando.botones.pausa"
            $boton configure -text $labelButton(resume) -command "
                set Ventana::Rizo::informe(detener) 0
                .bajando.botones.pausa configure -text labelButton(pause) \
                    -command \"Bajando_parar pausa $fichero $enlace\"
                .bajando.marco.marco_interno.bar.lienzo create rect 0 0 280 15 -fill white
                Ventana::Rizo::Reanudar $fichero $enlace
                Ventana::Barra_actualizar .bajando.marco.marco_interno.bar.lienzo
            "
        }
    }
    return
}

#############################################################################
# Barra_actualizar
#    Actualiza la barra de progreso.
#
# Parmetros:
#    barra: path de la barra de progreso
#############################################################################
proc Barra_actualizar {barra} {
    global Ventana::Rizo::informe
    global labelDialogs

    if [string match $informe(porcentaje) ""] return
    set hecho [expr 2.75 * $informe(porcentaje)]

    if {($informe(largo)==0)} {
        set Ventana::Rizo::informe(cual) "$labelDialogs(got) "
    } else {
        set Ventana::Rizo::informe(cual) "$labelDialogs(left) "
    }
    $barra create rect 0 0 $hecho 15 -fill blue
    if {$informe(detener)==0} {
        if {($informe(fin)==0) && ($informe(parar)!=1)} {
            after 1000 Ventana::Barra_actualizar $barra
        } else {
            destroy .bajando
        }
    }
    return
}

}