#############################################################################
###############################################################################
#####                            Ventana.tcl
###############################################################################
##### Creates the window which will provide some information to the user 
##### while a file is being downloaded.
###############################################################################
##### Copyright 1999-2000 Andrs Garca Garca - andresgarci@retemail.es
##### The contents of this file are distributed under the terms of the GPL
###############################################################################

namespace eval Ventana {

source [file join "$dirGetleft(scripts)" Rizo.tcl]

###############################################################################
# PauseDownloading
#    Pauses the downloading according to the menu entries.
#
# Parameter
#    which: either 'file' or 'page'
###############################################################################
proc Pause {which} {
    global options labelTitles labelMessages

    set windowState [wm state .bajando]
    if {$windowState=="iconic"} {
        wm deiconify .bajando
    }
    wm withdraw .bajando
    tk_messageBox -title $labelTitles(paused) -icon info -type ok \
         -message $labelMessages(paused)
    if {$which=="file"} {
        tkwait variable options(pauseFile)
    } else {
        tkwait variable options(pausePage)
    }
    wm deiconify .bajando
    if {$windowState=="iconic"} {
        wm iconify .bajando
    }

    return
}

###############################################################################
# CancelDownloading
#    This procedure is invoked from the downloading window when you click on
#    the 'cancel' button or you want to close the window
#
# Parameter:
#    skip: if skip is 'skip' the current file will be skipped and the next one
#    will begin to be downloaded. If there is no parameter, the downloading
#    will be stopped
###############################################################################
proc CancelDownloading {{skip {} }} {
    global labelTitles labelMessages
    global getleftState
    global ::Ventana::Rizo::curlReport
    variable afterId

    set what [tk_messageBox -type yesno -icon question \
            -title $labelTitles(confirm) -message $labelMessages(stopDownload)]

    if {$what=="no"} {
        return
    }
    catch {after cancel $afterId}

    Rizo::Lector $::Ventana::Rizo::pipe stopNow

    if {($skip=="")||($getleftState(filesChosen)==0)} {
        set ::options(stopFile) 1
        set Rizo::curlReport(stop) 1
        catch {destroy .bajando}
        set getleftState(downloading) 0
    } else {
        incr curlReport(nextFile)
    }

    return
}

###############################################################################
# RecortarCadena
#    Recorta el nombre del fichero o del enlace para que cuadre con el espacio
#    que hay para escribirlos.
#
# Parmetros
#    cadena: cadena con el nombre a recortar
#    long: longitud en la que tiene que quedar
#
# Devuelve:
#    La cadena recortada
###############################################################################
proc RecortarCadena {cadena long} {
    variable window

#puts "Fuente usada: [set font [$window(dir) cget -font]]"
#set cadenaBase "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
#puts "Longitud base: [font measure $font -displayof .bajando $cadenaBase]"
#puts "Cadena: $cadena"
#puts "Longitud de la cadena: [font measure $font -displayof .bajando $cadena]"

    set longitud_cadena [string length $cadena]
    if {$longitud_cadena>$long} {
        set index  [expr round($long/2)-2]
        set fin    [expr $longitud_cadena-$index]
        set primer [string range $cadena 0 $index]
        set segun  [string range $cadena $fin end]
        append tmp $primer "..." $segun
        return $tmp
    } else {
        return $cadena
    }
}

###############################################################################
# FileStrings
#    Controls the strings that will be put in the downloading window, to
#    show the name and directory of the file being processed or downloaded
#
# Parameter:
#    url to be downloaded or preprocessed
###############################################################################
proc FileStrings {url} {
    global directories siteUrl labelMessages
    variable window
    variable labelWidth

    set fileName  [UrlToFile $url]
    set parsedUrl [HtmlParser::ParseUrl $url]
    set domain    [lindex $parsedUrl 1]

    regexp "(.*)(\.$labelMessages(downloading))" $fileName nada fileName
    regexp "(?:$directories(base))(.*)" $fileName nada tmp
    regexp {(.*)(?:/)(.*)} $tmp nada tmpDir tmpFile

    $window(url)  configure -text [RecortarCadena $domain $labelWidth(url)]
    $window(dir)  configure -text [RecortarCadena $tmpDir  $labelWidth(dir)]
    $window(file) configure -text [RecortarCadena $tmpFile $labelWidth(dir)]

    return
}

###############################################################################
# DefineWindow
#    Creates the window, in which some info about the downloading will be
#    displayed.
#
# Parameter:
#    url: url of the file to be processed or downloaded.
###############################################################################
proc DefineWindow {url} {
    global file link mother labelButtons labelDialogs
    global tcl_platform
    variable window
    variable labelWidth

    set coord(x) [winfo rootx .]
    set coord(y) [winfo rooty .]

    set bajando [toplevel .bajando]
    wm geometry $bajando 290x155+[expr $coord(x)+200]+[expr $coord(y)+15]
    wm resizable $bajando 0 0

# This is a kludge that will have to be mended
    if [regexp {Windows} $tcl_platform(os)] {
	    set labelWidth(url) 46
        set labelWidth(dir) 40
    } else {
	    set labelWidth(url) 37
        set labelWidth(dir) 31
    }

    set marco     [frame $bajando.marco]
    set marco_in  [frame $bajando.marco.marco_interno]
    set marco_url [frame $marco_in.url]
    set marco_dir [frame $marco_in.dir]
    set marco_fil [frame $marco_in.fil]
    set marco_que [frame $marco_in.que]
    set marco_bar [frame $marco_in.bar]
    set botones   [frame $bajando.botones]

    set etq_url  [label $marco_url.etq_url  -text "$labelDialogs(url) "]
    set etq_dir  [label $marco_dir.etq_dir  -text "$labelDialogs(dir): "]
    set etq_file [label $marco_fil.etq_file -text "$labelDialogs(file) "]

    set window(which) "$labelDialogs(left) "
    set etq_que   [label $marco_que.etq_que   \
            -textvariable Ventana::window(which)]
    set etq_url2  [label $marco_url.etq_url2  -width 45 -anchor w \
            -bd 2 -relief sunken]
    set etq_dir2  [label $marco_dir.etq_dir2  -width 45 -anchor w]
    set etq_file2 [label $marco_fil.etq_file2 -width 45 -anchor w]
    set etq_que2  [label $marco_que.etq_que2  -width 30 -anchor w \
            -textvariable Ventana::Rizo::curlReport(left)]

    set barra1 [canvas $marco_bar.lienzo1 -width 275 -height 12 -bg white \
            -bd 2 -relief sunken -highlightthickness 0]
    set barra2 [canvas $barra1.lienzo2    -bg blue -highlightthickness 0]

    set window(top)  .bajando
    set window(url)  $etq_url2
    set window(dir)  $etq_dir2
    set window(file) $etq_file2
    set window(left) $etq_que2
    set window(bar1) $barra1
    set window(bar2) $barra2

    set pause    [button $botones.pause    -textvariable labelButtons(pause)\
        -command ::Ventana::PauseDownloading  -width 8]
    set cancelar [button $botones.cancelar -textvariable labelButtons(skip) \
        -command "::Ventana::CancelDownloading skip" -width 8]
    set window(cancelar) $cancelar

    pack $marco     -side top    -fill x -expand true
    pack $botones   -side bottom -fill x -expand true -padx 6
    pack $marco_in  -padx 10 -pady 10
    pack $marco_url $marco_in $marco_dir $marco_fil $marco_que $marco_bar \
            -fill x -expand true
    pack $etq_url   $etq_url2  -side left
    pack $etq_dir   $etq_dir2  -side left
    pack $etq_file  $etq_file2 -side left
    pack $etq_que   $etq_que2  -side left
    pack $barra1

    pack $cancelar $pause -side right -padx 3 -pady 5

    wm protocol $bajando WM_DELETE_WINDOW ::Ventana::CancelDownloading

    return
}

###############################################################################
# ShowWindow
#   Is needed, maps the downloading window, and sets its title bar
#
# Parameter
#   which: either 'down' or 'process', depending on the action taking place
#   url: url of the link.
###############################################################################
proc ShowWindow {which url} {
    global labelTitles
    variable window

    if {![winfo exists .bajando]} {
        DefineWindow $url
    } else {
        set state [wm state .bajando]
        if {($state=="withdrawn")&&($which=="down")} {
            wm deiconify .bajando
        }
    }
    if {$which=="down"} {
        wm title .bajando $labelTitles(download)
        $window(cancelar) configure -state normal
    } else {
        wm title .bajando $labelTitles(process)
        $window(cancelar) configure -state disabled
    }

    return
}

###############################################################################
# FileDownloading
#   Creates a nice window to show info about how the downloading goes
#
# Parameters:
#    fichero: file in which the link will be saved.
#    enlace:  file url.
#    madre:   referer page for the link
###############################################################################
proc FileDownloading {fichero enlace madre} {
    global file link mother directories
    global getleftState
    global labelTitles
    variable window
    variable labelWidth
    global Ventana::Rizo::meta
    global Ventana::Rizo::curlReport

    if {$getleftState(downloading)==0} {
puts "Pues no bajamos nada"
        return
    }

    set file   $fichero
    set link   $enlace
    set mother $madre

    ShowWindow down $enlace
    FileStrings $enlace

    set curlReport(end)   0
    set curlReport(long)  1
    set curlReport(pause) 0

    if {([file exists $fichero])&&($meta(versionServer)>=1.1)} {
        if {![catch {set meta(totalBytes)}]} {
            set size [file size $fichero]
            if {$size>$meta(totalBytes)} {
                file delete $fichero
            } elseif {$size==$meta(totalBytes)} {
                after 1000 "set ::Ventana::Rizo::curlReport(nextFile) 1"
                return
            }
        }
        Ventana::Rizo::ResumeRequest $fichero $enlace $madre
    } else {
        Ventana::Rizo::DataRequest $fichero $enlace $madre
    }

    BarUpdate $window(bar1)

    return
}

###############################################################################
# HeadDownloading
#    Gets the headers of the url from the server.
#
# Parameters:
#    enlace: url to download
#    madre:  referer page of the link
###############################################################################
proc HeadDownloading {enlace madre} {
    global siteUrl

    set Ventana::Rizo::curlReport(end) 0
    Ventana::Rizo::HeadRequest $enlace $madre
    tkwait variable Ventana::Rizo::curlReport(end)

    if {$siteUrl(prot)=="ftp"} {
        set Rizo::meta(versionServer) 1.1
    }
    if [regexp (ftp://) $enlace] {
        set Rizo::meta(totalBytes) 0
    }
    return
}

###############################################################################
# PauseDownloading
#    Takes control when you click on the 'Pause' button
###############################################################################
proc PauseDownloading {} {
    global file link mother
    global labelButtons
    variable window

    set Ventana::Rizo::curlReport(pause) 1
    set boton ".bajando.botones.pause"
    $boton configure -textvariable labelButtons(resume) -command "
        set Ventana::Rizo::curlReport(pause) 0
        .bajando.botones.pause configure -textvariable labelButtons(pause) \
                -command ::Ventana::PauseDownloading
        place forget $window(bar2)
        Ventana::Rizo::ResumeRequest \"$file\" $link \"$mother\"
        Ventana::BarUpdate $window(bar1)
    "
    return
}

###############################################################################
# BarUpdate
#    Updates the progress bar.
#
# Parameters:
#    barra: the full path of the progress bar.
###############################################################################
proc BarUpdate {barra} {
    global Ventana::Rizo::curlReport
    global Ventana::Rizo::curlError
    global Ventana::Rizo::meta
    global labelDialogs
    global file link mother options
    variable window
    variable afterId
    variable uno
    variable dos

    if [string match $curlReport(percentage) ""] return
    set hecho [expr 2.66 * $curlReport(percentage)]

    if {($curlReport(long)==0)} {
        set window(which) "$labelDialogs(got) "
    } else {
        set window(which) "$labelDialogs(left) "
    }

    place $barra.lienzo2 -in $barra -x 2 -y 2 -bordermode inside -width $hecho \
            -height 12
    if [info exists uno] {
        $barra delete $uno
        $barra.lienzo2 delete $dos
    }
    set uno [$barra create         text 137.5 9 -text $curlReport(percentage)% \
            -fill black -anchor c]
    set dos [$barra.lienzo2 create text 134.5 7 -text $curlReport(percentage)% \
            -fill white -anchor c]

    if {$curlReport(pause)==0} {
        if {($curlReport(end)==0) && ($curlReport(stop)!=1)} {
            set afterId [after 1000 Ventana::BarUpdate $barra]
        } else {
            if {($meta(totalBytes)!=0)&&($options(checkSize)==1)} {
                if {($curlError=="")||($curlError==0)} {
                    if {![catch [list file stat "$file" fileData] ]} {
                        if {$fileData(size)!=$meta(totalBytes)} {
                            if {($options(resume)==1)&&($curlReport(stop)!=1)} {
                                $barra create rect 0 0 280 15 -fill white
                                FileDownloading $file $link $mother
                                return
                            } else {
                                catch {error "Fichero Incompleto" GETLEFT \
                                    "Getleft \"$labelDialogs(fileIncom)\" 001"}
                            }
                        }
                    }
                }
            }
            place $barra.lienzo2 -in $barra -x 2 -y 2 -bordermode inside \
                    -width 266 -height 12
            update
            after 75
            place forget $barra.lienzo2
            $barra delete $uno
            set ::Ventana::Rizo::curlReport(left) ""
            $window(dir)  configure -text ""
            $window(file) configure -text ""
            incr curlReport(nextFile)
        }
    }
    return
}

}
