###############################################################################
###############################################################################
##                        Herramientas.tcl
###############################################################################
###############################################################################
## Includes procedures to implement the commands in the 'Tools' and 'Options'
## menus.
###############################################################################
###############################################################################
## (c) 1999-2000 Andrs Garca Garca. andresgarci@retemail.es
## Distributed under the terms of the GPL licence
###############################################################################
###############################################################################

namespace eval Herramientas {

###############################################################################
# ExtensionsDialog
#    Creates a dialog box to choose file extensions
#
# Parameters:
#    title: title of the dialog box
#
# Side effect:
#    Global variable 'bot' will contain the choosen extensions
#
# Returns:
#    1: if cancelled
###############################################################################
proc ExtensionDialog {title} {
    global labelButtons labelTitles done2

    set coord(x) [winfo rootx .]
    set coord(y) [winfo rooty .]

    set ext [toplevel .extDialog]
    wm title $ext $title
    wm resizable $ext 0 0
    wm geometry $ext +[expr $coord(x)+100]+[expr $coord(y)+15]

    set marcoExt [frame $ext.marcoext]
    set marcoRel [frame $marcoExt.marcoint -bd 2 -relief groove]
    set marcoInt [frame $marcoRel.marcoInt]
    set marcoIzq [frame $marcoInt.marcoIzq]
    set marcoCen [frame $marcoInt.marcoCen]
    set marcoDer [frame $marcoInt.marcoDer]
    set marcoBot [frame $ext.marcoBot]

    set izqArr   [frame $marcoIzq.arr]
    set izqCen   [frame $marcoIzq.cen]
    set izqAbj   [frame $marcoIzq.abj]
    set izqBot1  [checkbutton $izqArr.bot1 -variable bot(1) -onvalue "*.jpg" -offvalue ""]
    set izqEtq1  [label $izqArr.etq1 -text "*.jpg" -justify left]
    set izqBot2  [checkbutton $izqCen.bot2 -variable bot(2) -onvalue "*.gif" -offvalue ""]
    set izqEtq2  [label $izqCen.etq2 -text "*.gif"]
    set izqBot3  [checkbutton $izqAbj.bot3 -variable bot(3) -onvalue "*.ps" -offvalue ""]
    set izqEtq3  [label $izqAbj.etq3 -text "*.ps"]

    set cenArr   [frame $marcoCen.arr]
    set cenCen   [frame $marcoCen.cen]
    set cenAbj   [frame $marcoCen.abj]
    set cenBot1  [checkbutton $cenArr.bot4 -variable bot(4) -onvalue "*.pdf" -offvalue ""]
    set cenEtq1  [label $cenArr.etq4 -text "*.pdf"]
    set cenBot2  [checkbutton $cenCen.bot5 -variable bot(5) -onvalue "*.txt" -offvalue ""]
    set cenEtq2  [label $cenCen.etq5 -text "*.txt"]
    set cenBot3  [checkbutton $cenAbj.bot6 -variable bot(6) -onvalue "*.mov" -offvalue ""]
    set cenEtq3  [label $cenAbj.etq6 -text "*.mov"]

    set derArr   [frame $marcoDer.arr]
    set derCen   [frame $marcoDer.cen]
    set derAbj   [frame $marcoDer.abj]
    set derBot1  [checkbutton $derArr.bot7 -variable bot(7) -onvalue "*.avi" -offvalue ""]
    set derEtq1  [label $derArr.etq1 -text "*.avi"]
    set derBot2  [checkbutton $derCen.bot8 -variable bot(8) -onvalue "*.zip" -offvalue ""]
    set derEtq2  [label $derCen.etq2 -text "*.zip"]
    set derBot3  [checkbutton $derAbj.bot9 -variable bot(9) -onvalue "*.tgz" -offvalue ""]
    set derEtq3  [label $derAbj.etq3 -text "*.tgz"]

    if {$title!=$labelTitles(exclude)} {
        foreach {index cadena} {1 *.jpg 2 *.gif 3 *.ps 4 *.pdf 5 \
                *.txt 6 *.mov 7 *.avi 8 *.zip 9 *.tgz} {
            set ::bot($index) $cadena
        }
    } else {
        for {set i 1} {$i<10} {incr i} {
            set ::bot($i) ""
        }
    }

    set aceptar  [button $marcoBot.aceptar  -textvariable labelButtons(ok)    \
		-width 8 -command "set done2 1"]
    set cancelar [button $marcoBot.cancelar -textvariable labelButtons(cancel)\
		-width 8 -command "set done2 0"]

    bind $ext <Escape> "$cancelar invoke"

    pack $marcoExt -ipadx 10 -ipady 5
    pack $marcoRel -ipadx 15 -side bottom
    pack $marcoInt
    pack $marcoIzq -pady 15 -side left
    pack $marcoCen -pady 15 -padx 10 -side left
    pack $marcoDer -pady 15 -side left

    pack $izqArr $izqCen $izqAbj -fill x
    pack $izqBot1 $izqEtq1 -side left
    pack $izqBot2 $izqEtq2 -side left
    pack $izqBot3 $izqEtq3 -side left

    pack $cenArr $cenCen $cenAbj -fill x
    pack $cenBot1 $cenEtq1 -side left
    pack $cenBot2 $cenEtq2 -side left
    pack $cenBot3 $cenEtq3 -side left

    pack $derArr $derCen $derAbj -fill x
    pack $derBot1 $derEtq1 -side left
    pack $derBot2 $derEtq2 -side left
    pack $derBot3 $derEtq3 -side left

    pack $marcoBot
    pack $aceptar $cancelar -side left -pady 5 -padx 5

    grab $ext
    tkwait variable done2
    grab release $ext
    destroy $ext
    if {$done2==0} {
        return 1
    }

    return
}

###############################################################################
# PurgeFilesDir
#    Sweeps a directory turning files to size 0
#
# Parameters:
#    dir: directory to be processed
#    purgarCmd: extensions of the files to minimize
###############################################################################
proc PurgeFilesDir {dir purgarCmd} {
    global dirGetleft tcl_platform

    cd $dir
    set archivos ""
    foreach ext $purgarCmd {
        set archivos [concat $archivos [glob -nocomplain $ext]]
    }

    foreach file $archivos {
        file stat $file estado
        if {$estado(size)!=0} {
            file delete -force $file
            if [regexp {Windows} $tcl_platform(os)] {
                exec [file join $dirGetleft(main) touch] $file
            } else {
                exec touch $file
            }
        }
    }

    set archivos [glob -nocomplain *]
    set directorios ""
    foreach file $archivos {
        if [file isdirectory $file] {
            lappend directorios $file
        }
    }

    foreach dir $directorios {
	  update
        PurgeFilesDir $dir $purgarCmd
        cd ..
    }
    return
}

###############################################################################
# PurgeFiles
#    The procedures takes care of recursively clean directories of files
#    with certain extensions *.jpg, *.gif, etc.
###############################################################################
proc PurgeFiles {} {
    global labelTitles labelMessages

    if [winfo exists .extDialog] {
        return
    }

    if {[ExtensionDialog $labelTitles(purge)]==1} {
        return
    }

    set dir [Dialogos::SelectDirectory]
    if {![string compare $dir ""]} {
        return
    }

    set dirTmp [pwd]
    for {set i 1;set purgarCmd ""} {$i<10} {incr i} {
        append purgarCmd $::bot($i) " "
    }

    PurgeFilesDir $dir $purgarCmd

    tk_messageBox -title $labelTitles(theEnd) -icon info \
        -message $labelMessages(purged)

    cd $dirTmp

    return
}

###############################################################################
# RestoreOriginalsDir
#    Recursively restores the original files.
#
# Parameter:
#    dir: directory in which it will begin to restore.
###############################################################################
proc RestoreOriginalsDir {dir} {

    cd $dir
    set directorio [glob -nocomplain *.orig]
    foreach fichero $directorio {
        file rename -force $fichero [file root $fichero]
    }

    set listaFicheros [glob -nocomplain *]
    set directorios ""
    foreach fichero $listaFicheros {
        if [file isdirectory $fichero] {
            lappend directorios $fichero
        }
    }

    foreach dir $directorios {
	    RestoreOriginalsDir $dir
        cd ..
    }
    return
}

###############################################################################
# RestoreOriginals
#    Starts the process of restoring the original files downloaded from Web
#    pages.
###############################################################################
proc RestoreOriginals {} {
    global labelTitles labelMessages

    set dir [Dialogos::SelectDirectory]
    if {![string compare $dir ""]} {
        return
    }
    set dirTmp [pwd]
    RestoreOriginalsDir $dir

    tk_messageBox -title $labelTitles(theEnd) -icon info \
            -message $labelMessages(restored)

    cd $dirTmp

    return
}

###############################################################################
# SameProxy
#    Disables or enables the entries for the ftp proxy, depending on
#    the checkbutton
###############################################################################
proc SameProxy {} {
    global options
    variable ip

    for {set i 6} {$i<11} {incr i} {
        if {$options(sameProxy)==1} {
            $ip($i) configure -state disabled
        } else {
            $ip($i) configure -state normal
        }
    }

    return
}

###############################################################################
# ConfProxy
#    Allows the user to enter his proxy data.
###############################################################################
proc ConfProxy {} {
    global done options labelButtons labelTitles
    variable ip
    variable n

    if [winfo exists .proxy] {
        return
    }

    set coord(x) [winfo rootx .]
    set coord(y) [winfo rooty .]

    set proxy [toplevel .proxy]
    wm title $proxy $labelTitles(proxy)
    wm resizable $proxy 0 0
    wm geometry  $proxy +[expr $coord(x)+100]+[expr $coord(y)+50]

    set done 0

    set marcoEx   [frame $proxy.marcoEx]
    set marco     [frame $marcoEx.marco -bd 2 -relief groove]
    set marcoIn   [frame $marco.marcoIn]
    set marcoHttp [frame $marcoIn.marcoHttp]
    set marcoFtp  [frame $marcoIn.marcoFtp]

    set label1 [label $marcoHttp.label -textvariable labelDialogs(http)]
    set ip(1)  [entry $marcoHttp.1 -width 3 -bg white -justify  right]
    set ip(2)  [entry $marcoHttp.2 -width 3 -bg white -justify  right]
    set ip(3)  [entry $marcoHttp.3 -width 3 -bg white -justify  right]
    set ip(4)  [entry $marcoHttp.4 -width 3 -bg white -justify  right]
    set ip(5)  [entry $marcoHttp.5 -width 4 -bg white]
    set punto1 [label $marcoHttp.punto1 -text \n. -width 1]
    set punto2 [label $marcoHttp.punto2 -text \n. -width 1]
    set punto3 [label $marcoHttp.punto3 -text \n. -width 1]
    set colon1 [label $marcoHttp.colon1 -text : -width 2]

    set label2 [label $marcoFtp.label  -textvariable labelDialogs(ftp)]
    set ip(6)  [entry $marcoFtp.6  -width 3 -bg white -justify  right]
    set ip(7)  [entry $marcoFtp.7  -width 3 -bg white -justify  right]
    set ip(8)  [entry $marcoFtp.8  -width 3 -bg white -justify  right]
    set ip(9)  [entry $marcoFtp.9  -width 3 -bg white -justify  right]
    set ip(10) [entry $marcoFtp.10 -width 4 -bg white]
    set punto4 [label $marcoFtp.punto4 -text \n. -width 1]
    set punto5 [label $marcoFtp.punto5 -text \n. -width 1]
    set punto6 [label $marcoFtp.punto6 -text \n. -width 1]
    set colon2 [label $marcoFtp.colon2 -text : -width 2]

    set check  [checkbutton $marcoIn.check -textvariable labelDialogs(sameProxy) \
            -variable options(sameProxy) -command ::Herramientas::SameProxy]

    set botones  [frame  $proxy.botones]
    set borrar   [button $botones.borrar   -textvariable labelButtons(clear) \
            -width 6 -command {set done 2}]
    set aceptar  [button $botones.aceptar  -textvariable labelButtons(ok)    \
            -width 6 -command {set done 1}]
    set cancelar [button $botones.cancelar -textvariable labelButtons(cancel)\
            -width 6 -command {set done 0}]

    pack $cancelar -side right -padx 9 -pady 5
    pack $aceptar  -side right -pady 5
    pack $borrar   -side right -padx 9
    pack $botones  -side bottom -fill x

    pack $label1 $label2 -side left
    pack $ip(5)  $colon1 $ip(4) $punto3 $ip(3) $punto2 $ip(2) $punto1 $ip(1) -side right
    pack $ip(10) $colon2 $ip(9) $punto6 $ip(8) $punto5 $ip(7) $punto4 $ip(6) -side right
    pack $marcoHttp $marcoFtp $check -fill x
    pack $marcoIn -padx 10 -pady 10
    pack $marco -side bottom
    pack $marcoEx -ipadx 10 -ipady 5

    focus $ip(1)

    bind $proxy <Escape> "$cancelar invoke"
    for {set i 1;set n 2} {$i<11} {incr i;incr n} {
        if {($i!=5)&&($i!=10)} {
            bind $ip($i) <Return>   "focus $ip($n)"
            bind $ip($i) <KP_Enter> "focus $ip($n)"
            bind $ip($i) <Key-Right> {
                %W selection range 0 0
                set indice [%W index insert]
                set final  [%W index end]
                if {$indice==$final} {
                    focus $::Herramientas::ip([expr [winfo name %W] +1])
                }
            }
            bind $ip($i) <KeyRelease> {
                if {("%K"=="Left")||("%K"=="Right")||("%K"=="Tab")} {
                    break
                }
                if {[%W index insert]==3} {
                    focus $::Herramientas::ip([expr [winfo name %W] +1])
                }
            }
            bind $ip($i) <KeyPress> {
                if {[%W index end]==3} {
                    if {("%K"!="Left")&&("%K"!="Right")&&("%K"!="Return")&&("%K"!="Tab")&&("%K"!="Delete")&&("%K"!="BackSpace")} {
                        break
                    }
                }
            }
        } else {
            if {$i==5} {
                bind $ip(5) <Key-Right> {
                    %W selection range 0 0
                    set indice [%W index insert]
                    set final  [%W index end]
                    if {$indice==$final} {
                        focus $::Herramientas::ip(6)
                    }
                }
                bind $ip(5) <KeyRelease> {
                    if {[%W index insert]==4} {
                        focus $::Herramientas::ip(6)
                    }
                }
                bind $ip(5) <Return> "
                    focus $ip(6)
                "
                bind $ip($i) <KP_Enter> "
                    focus $ip(6)
                "
            } else {
                bind $ip($i) <KeyRelease> {
                    if {[%W index insert]==4} {
                        focus .proxy.botones.aceptar
                    }
                }
                bind $ip($i) <Return> "
                    focus $ip(6)
                "
                bind $ip($i) <KP_Enter> "
                    focus $ip(6)
                "
            }
            bind $ip($i) <KeyPress> {
                if {[%W index end]==4} {
                    if {("%K"!="Left")&&("%K"!="Return")&&("%K"!="Tab")&&("%K"!="Delete")&&("%K"!="BackSpace")} {
                        break
                    }
                }
            }
        }
        if {$i!=1} {
            bind $ip($i) <Key-Left> {
                %W selection range 0 0
                if {[%W index insert]==0} {
                    focus $::Herramientas::ip([expr [winfo name %W] -1])
                }
            }
        }
        bind $ip($i) <FocusIn> "$ip($i) selection range 0 end"
    }

    if [info exists options(httpProxy)] {
        regexp {([^\.]+)(?:\.)([^\.]+)(?:\.)([^\.]+)(?:\.)([^\.]+)(?::)(.*)} \
                 $options(httpProxy) nada ip1 ip2 ip3 ip4 ip5
        $ip(1) insert insert $ip1
        $ip(2) insert insert $ip2
        $ip(3) insert insert $ip3
        $ip(4) insert insert $ip4
        $ip(5) insert insert $ip5
    }
    if [info exists options(ftpProxy)] {
        regexp {([^\.]+)(?:\.)([^\.]+)(?:\.)([^\.]+)(?:\.)([^\.]+)(?::)(.*)} \
                 $options(ftpProxy) nada ip6 ip7 ip8 ip9 ip10
        $ip(6)  insert insert $ip6
        $ip(7)  insert insert $ip7
        $ip(8)  insert insert $ip8
        $ip(9)  insert insert $ip9
        $ip(10) insert insert $ip10
    }

    SameProxy
    tkwait variable done

    if {$done==1} {
        for {set i 1} {$i<11} {incr i} {
            set dirProxy($i) [$ip($i) get]
        }
        set options(httpProxy) "$dirProxy(1).$dirProxy(2).$dirProxy(3).$dirProxy(4):$dirProxy(5)"
        if {$options(sameProxy)==0} {
            set options(ftpProxy) "$dirProxy(6).$dirProxy(7).$dirProxy(8).$dirProxy(9):$dirProxy(10)"
        } else {
            set options(ftpProxy) $options(httpProxy)
        }
        SaveConfig
    } elseif {$done==2} {
        for {set i 1} {$i<6} {incr i} {
            $ip($i) delete 0 end
        }
        catch {unset options(httpProxy)}
        catch {unset options(ftpProxy)}
        SaveConfig
    }

    destroy $proxy
    return
}

###############################################################################
# FilterFiles
#    You can choose which file extensions will be ignored while downloading a
#    Web site.
#
# Side effects:
#    If a filter is chosen the global variable 'options(onlyHtml)' is reset,
#    while 'options(filter)' will contain a regular expression that will be
#    used to filter the links.
###############################################################################
proc FilterFiles {} {
    global options labelTitles labelMessages

    if [winfo exists .extDialog] {
        return
    }

    if {[ExtensionDialog $labelTitles(exclude)]==1} {
        return
    }

    set options(onlyHtml) 0

    for {set i 1;set filter ""} {$i<10} {incr i} {
        if {$::bot($i)!=""} {
            append filter ($::bot($i)$) "|"
        }
    }
    regsub -all {(\*\.)} $filter {} filter
    regexp {(.*)(\|)} $filter nada filter

    set options(filter) $filter

    return
}

###############################################################################
# ErrorLog
#    Logs in the file 'Geterror.log' the error messages returned by 'curl'
#
# Parameters
#    file: file in which the error occured
#    link: link that we where trying to download
###############################################################################
proc ErrorLog {file link} {
    global dirGetleft getleftState
    global labelDialogs labelMonths supportedLang options
    global errorCode

    set errorLog [file join $dirGetleft(conf) Geterror.log]

    set handle  [open $errorLog a+]
    fconfigure $handle -encoding $supportedLang($options(lang))

    set seconds [clock seconds]
    set month $labelMonths([clock format $seconds -format %B])

    puts $handle "[clock format $seconds -format "%d-$month-%Y -- %H:%M"]"
    puts $handle "$labelDialogs(errorLink) $link"
    puts $handle "$labelDialogs(errorFile) [file root $file]"

#puts "En ErrorLog: $errorCode"
    if {[lindex $errorCode 0]!="Getleft"} {
        puts -nonewline $handle \
                "$labelDialogs(errorCode) $::Ventana::Rizo::curlError, "
        puts $handle "$labelDialogs(errorMess) $::Ventana::Rizo::errorMessage"
    } else {
        puts $handle "$labelDialogs(errorMess) [lindex $errorCode 1]"
    }

    puts $handle ""
    close $handle
    set getleftState(errorFound) 1

    return
}

###############################################################################
# EraseErrorLog
#    Deletes the error log.
###############################################################################
proc EraseErrorLog {} {
    global dirGetleft

    set errorLog [file join "$dirGetleft(conf)" Geterror.log]

    file delete $errorLog

    return
}

###############################################################################
# ShowErrorLog
#    In case of error during a download, this procedures show a window with
#    the contents of the error log.
###############################################################################
proc ShowErrorLog {} {
    global dirGetleft
    global labelDialogs labelMonths labelTitles

    set errorLog [file join "$dirGetleft(conf)" Geterror.log]

    if [file exists $errorLog] {
        Ayuda::DefineWindow $labelTitles(errorLog) $errorLog 1
    }
    return
}

proc DummyProc {newSock addr port} {
    variable proxyIp

    regexp {(.*)(\.)} $addr nada myIp

    set proxyIp $myIp.1

    return
}

proc GuessProxyIp {} {
    variable proxyIp

    set serverSocket [socket -server ::Herramientas::DummyProc 11453]

    set channel [socket [info hostname] 11453]

    tkwait variable ::Herramientas::proxyIp

    close $serverSocket

    puts "La direccion: $proxyIp"

    return
}

proc GuessProxyPort {} {
    variable proxyIp
    variable proxyPort

    package require http

    http::config -proxyhost $proxyIp
    for {set i 80} {$i<=10000} {incr i} {
        http::config -proxyport $i
        if {[catch {http::geturl http://freshmeat.net/appindex/1999/07/17/932219913.html} token]} {
            continue
        }
        if {[::http::status $token]=="ok"} {
            regexp {( [0-9][0-9][0-9] )} [::http::code $token] code
            if {$code==200} {
                set proxyPort $i
                break
            }
        }
    }
    if {$i<=1000} {
    tk_messageBox -message "El proxy: es $proxyIp:$proxyPort" -type ok -icon info
    } else {
    tk_messageBox -message "No se encontr el proxy" -type ok -icon info
    }
    package forget http

    return
}

}
