#!/bin/sh
# the next line restarts using wish \
exec wish8.0 "$0" "$@"
#
#   - simple tcl/tk software installation GUI -
#
#   Required:	tcl/tk8.0b1
#
#   Created:	07/97 
#   Changed:	10/98 
#   Version:    0.11
#
#   Copyright (C) 1997, Steffen Traeger
#	EMAIL:	Steffen.Traeger@t-online.de
#	URL:	http://home.t-online.de/home/Steffen.Traeger
#
#   This program is free software; you can redistribute it and/or 
#   modify it. 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
########################################################################

# package library information
set inst(PkgName) FTP
set inst(PkgVersion) 1.2
set inst(PkgFilename) ftp_lib.tcl

# set palette under X
if { [string range [winfo server .] 0 0] == "X" } {
	option add *background			LightGray
	tk_setPalette LightGray
	option add *Text.foreground		black
	option add *Text.background		[option get . selectBackground Listbox]
	option add *Listbox.background		[option get . selectBackground Listbox]
	option add *Listbox.selectBackground 	[option get . insertBackground Listbox]
	option add *Listbox.selectForeground  	white    
	option add *Entry.background		[option get . selectBackground Listbox]
	option add *Entry.selectBackground 	[option get . insertBackground Listbox]
	option add *Entry.selectForeground  	white
	option add *borderWidth			2
}    

# main window
wm title . "$inst(PkgName) $inst(PkgVersion) Software Installation"
wm iconname . "$inst(PkgName) $inst(PkgVersion)"

# split area in control and installation window
frame .control -bd 1 -relief raised
  pack .control -in . -side bottom -fill x
frame .inst -bd 1 -relief raised
  pack .inst -in . -side top -expand 1 -fill both

# installation
image create photo logo -file [file join $tk_library demos images tcllogo.gif]
label .inst.image -image logo -relief sunken
pack .inst.image -in .inst -side left -padx 3m -pady 2m
frame .inst.install -height 250 -width 400
pack .inst.install -in .inst -side right -padx 3m -pady 2m -expand 1 -fill x
pack propagate .inst.install 0


# control
button .control.back -width 8 -text "< Back" -under 2
button .control.next -width 8 -text "Next >" -under 0
label .control.space  
button .control.cancel -width 8 -text "Exit" -under 0 -command Cancel
pack .control.cancel .control.space .control.next .control.back -in .control -side right -padx 2m -pady 2m

update idletasks


# Directory Browser
proc Browse {currentdir title} {
global inst auto_path tcl_platform
    
	set dirname [tk_getSaveFile -initialdir $currentdir -title $title]
	if {[string compare {} $dirname]} {
		if [file isdir $dirname] {
			set inst(LibDir) $dirname
		} elseif [file isdir [file dirname $dirname]] {
			set inst(LibDir) [file dirname $dirname]
 		}
    	}
  
  	# long filename autopath bei Windows
	if { $tcl_platform(platform) == "windows" } {
		set path {}
		foreach i $auto_path {
			lappend path [file attributes $i -longname]
		}
	} else {
		set path $auto_path 	
	}
	
	set index [lsearch -exact $path $inst(LibDir)] 
	if {$index == "-1"} {
		tk_messageBox -title Install -message "WARNING!\nThe destination directory is not in the search \
path for automatic loading!\n\nauto_path=$path" -type ok
		
	}
}

# Set up new installation screen 
proc NewScreen {screen_nr} {
global inst

	# Delete previous screen
	set w .inst.install
	foreach win [winfo children $w] {
		destroy $win
	}

	# Prepare for special button handling
	switch $screen_nr {
	
		1	{
			    .control.back configure -state disabled
	                    .control.cancel configure -text "Exit"
	                 }
	                 
		2	{
			    .control.back configure -state normal
			    .control.cancel configure -text "Cancel"
			}
			
			
		5	{
			  .control.back configure -state disabled
			  .control.next configure -text "Finish"	
			  .control.cancel configure -state disabled
			}
	}		
	
	.control.back configure -command "NewScreen [expr $screen_nr - 1]"	
        .control.next configure -command "NewScreen [expr $screen_nr + 1]"
	focus .control.next	

	eval Screen$screen_nr $w
	update idletasks
}  

proc Screen1 {w} {
global inst

	label $w.header -text "Welcome!" -justify left -font {Times 24 italic}
	label $w.l1 -text "
This installation program will install $inst(PkgName) $inst(PkgVersion)."  -justify left  -font {Times 12}
	label $w.l2 -text "Press the Next button to start the installation. \
You can press Exit button now if you do not want to install $inst(PkgName) $inst(PkgVersion) \
at this time." -justify left -wraplength 300 -font {Times 12}

	pack $w.header $w.l1 $w.l2 -in $w -side top -anchor w -padx 3m -pady 3m

}

proc Screen2 {w} {
global inst

	label $w.header -text "Select Destination Directory" -justify left  -font {Times 24 italic}
	label $w.l1 -text "Please select the directory where the $inst(PkgName) $inst(PkgVersion) \
library package files are to be installed." -justify left -wraplength 300 -font {Times 12}

	frame $w.libdir -bd 2 -relief groove
	label $w.libdir.dirname -textvariable inst(LibDir)
	button $w.libdir.browse -width 8 -text "Browse" \
		 -command {Browse $inst(LibDir) "Select Destination Directory"} 
	pack $w.libdir.dirname  -in $w.libdir -side left -anchor w -padx 2m -pady 2m
	pack  $w.libdir.browse -in $w.libdir -side right -anchor w -padx 2m -pady 2m

	pack $w.header $w.l1 -in $w -side top -anchor w -padx 3m -pady 3m
	pack $w.libdir -in $w -side top -anchor w -fill x -padx 3m -pady 3m 
}

proc Screen3 {w} {
global inst

	label $w.header -text "Ready to Install!" -justify left  -font {Times 24 italic}
	label $w.l1 -text "You are now ready to install  $inst(PkgName) $inst(PkgVersion)." \
		-justify left -wraplength 300 -font {Times 12}

	label $w.l2 -text "Press the Next button to begin the installation or the Back button \
to reenter the installation information" -justify left -wraplength 300 -font {Times 12}

	pack $w.header $w.l1 $w.l2 -in $w -side top -anchor w -padx 3m -pady 3m
}

proc Screen4 {w} {
global inst tcl_platform

	label $w.header -text "Installing:" -justify left -font {Times 24 italic}
	text $w.text -font {Times 12}

	pack $w.header -in $w -side top -anchor w -padx 3m -pady 3m
	pack $w.text -in $w -side top -anchor w -fill x -padx 3m -pady 3m
	
	bind $w.text <1> {# nichts}
	.control.back configure -state disabled
	.control.next configure -state disabled
	
	# making directory for the library package
	set dir [file join $inst(LibDir) $inst(PkgName)]
	if { [file exists $dir] && ![file isdir $dir] } {
		tk_messageBox -title Install -message "$inst(PkgName) $inst(PkgVersion) destination \
directory \"$dir\" already exists and is not a directory!\n\nPlease remove the file and then restart \
installation" -type ok
		return
	} else {
		$w.text insert end "Creating destination directory ..." 
		update idletasks
		file mkdir $dir
		$w.text insert end "OK!\n" 
		update idletasks
	}
	    
	$w.text insert end "Copying library package files ..." 
	update idletasks
	file copy -force $inst(PkgFilename) $dir	
	$w.text insert end "OK!\n" 
	update idletasks

	if { $tcl_platform(platform) == "unix" } {
		$w.text insert end "Setting permissions ..." 
		update idletasks
		file attributes $dir -permissions 0755
		file attributes [file join $dir $inst(PkgFilename)] -permissions 0644
		$w.text insert end "OK!\n" 
		update idletasks
	}

	$w.text insert end "Building autoload index ..." 
	update idletasks
	set f [open [file join $dir pkgIndex.tcl] w]
	puts $f {# Tcl package index file, version 1.1
# This file is *not* generated by the "pkg_mkIndex" command.
# This file is generated by an installation procedure.
# It is sourced either when an application starts up or
# by a "package unknown" script.  It invokes the
# "package ifneeded" command to set up package-related
# information so that packages will be loaded automatically
# in response to "package require" commands.  When this
# script is sourced, the variable $dir must contain the
# full path name of this file's directory.
	}
	puts $f "package ifneeded $inst(PkgName) $inst(PkgVersion) \[list source \[file join \$dir $inst(PkgFilename)\]\]"
	close $f

	$w.text insert end "OK!\n" 
	update idletasks

	$w.text insert end "\nInstallation completed!\n" 
	update idletasks

	$w.text configure -state disabled
	.control.next configure -state normal
	
}

proc Screen5 {w} {
global inst

	label $w.header -text "Installation Completed!" -justify left -font {Times 24 italic}
	label $w.l1 -text "$inst(PkgName) $inst(PkgVersion) has been successfully installed." \
		-justify left -wraplength 300 -font {Times 12}
	label $w.l2 -text "Press the Finish button to exit this installation." -justify left -wraplength 300 -font {Times 12}

	pack $w.header $w.l1 $w.l2 -in $w -side top -anchor w -padx 3m -pady 3m
}

# Quit
proc Screen6 {w} {
	destroy .	
}

proc Install {} {
	
}	

proc Cancel {} {
	set rc [tk_messageBox -title Install -message "Do you want to abort this installation?" \
		-type yesno -default yes]
	if { $rc == "yes" } {
		destroy .
	}
}	

# main
if { $tcl_platform(platform) == "windows" } {
	set inst(LibDir) [file dirname [file attributes [lindex $auto_path 0] -longname]]
} else {
	set inst(LibDir) [file dirname [lindex $auto_path 0]]
}
NewScreen 1




