#
# $Source: /home/nlfm/Zircon/lib/RCS/Info.tcl,v $
# $Date: 1999/02/01 09:32:04 $
# $Revision: 1.18.1.40 $
#
package provide zircon 1.18
#
# Build a Zircon Information Window.
#
proc MainInfo {} {
    if {![winfo exists .@inf]} {
	global zlayout zInfo
	set zInfo [Window .@inf -title {Zircon Information} -resizable {1 1}]
	set w [$zInfo name]
	catch {wm geometry .@inf $zlayout(default,info)}
        grid columnconfigure .@inf 0 -weight 1 -minsize 50
    }
    return .@inf
}
#
proc Info {args} {
    global BF Fg Bg Ft Bl OType defChan zInfo zII zNOII zInfo
    set name [makeObj {Channel Info} $args]
    upvar #0 $name idata
    set net $idata(net)
    set w [switchFrame [MainInfo] $name [$net name] 0 -handles]
    $zInfo register $name {} "deleteFrame [MainInfo] $name"
    set df [getDefault defChan $net]
    $name configure -hpos 0 -open [$idata(net) popInfo] \
      -close [$df close] -jump 1 -quiet 0 -draw 0 \
      -msg [$df msg] -actionmode 0 \
      -actions 0 -patterns {} -logfile {} -history [$df history] \
      -closetime [$df closetime] -log {} -menu 0 -join 0 \
      -ops {} -keep 1 -monitor 0 -wid $zInfo -window $w \
      -ircIImode [$net ircIImode]
    grid rowconfigure $w 0 -weight 1
    grid columnconfigure $w 0 -weight 1
    frame $w.cmd -borderwidth 0
    grid columnconfigure $w.cmd 0 -weight 1
    scrollbar $w.cmd.hs -orient horizontal -command "$w.cmd.entry xview"
    emacsEntry $w.cmd.entry -xscrollcommand "ghsSet $w.cmd.hs" \
      -relief sunken -state disabled
    button $w.cmd.clear -text [trans clear] -command "$name clear" -width 5 \
      -borderwidth 2 -highlightthickness 2 -pady 0
    grid $w.cmd.entry $w.cmd.clear -sticky ew
    grid $w.cmd.hs - -sticky ew
    if {[$net command]} { grid $w.cmd -row 1 -columnspan 2 -sticky ew }
    doInfoBindings $w.cmd.entry $name
    bind $w.cmd.entry <Return> "$name doCmd %W"
    set idata(text) [set oft $w.info]
    scrollbar $w.vscroller -command "$oft yview"
    text $oft -height 10 -width 80 \
      -yscrollcommand "setScroll $name $oft $w.vscroller" -borderwidth 2
    rebind $oft $idata(net)
    bind $oft <Configure> {%W see end ; notIdle %W}
    bind $w <Visibility> {notIdle %W}
    grid $w.vscroller -row 0 -column 1 -sticky ns
    grid $oft -row 0 -column 0 -sticky nsew
    set BF($name) [getOValue $name  $oft font boldFont Font]
    set Fg($name) [getOValue $name $oft foreground foreground Foreground]
    set Bg($name) [getOValue $name $oft background background Background]
    set Ft($name) [getOValue $name $oft font font Font]
    set Bl($name) [option get $oft bell Bell]
    confTag $oft {} $Fg($name) $Bg($name) $Ft($name) $BF($name)
    $name defaultTags
    return $name
}
#
proc info_delete {this} { mcnDelete $this ITO[$this net] info }
#
proc info_onShow {this} { }
#
proc info_clear {this args} {
   [$this text] delete 1.0 end
   update idletasks
}
#
proc info_send {this string args} {
    if {[[$this net] raw]} {
	$this configure -hpos 0
	$this addText {} ":>$string"
	$this addHist $string
	[$this net] sendRaw $string
    } { bell }
}
#
proc info_doCmd {this w} { [$this net] doMisc2 $this $w }
#
proc info_call {this op pars} {
    upvar #0 $this idata
    switch $op {
    lname { return $this }
    crypt { return {} }
    control { return [$idata(net) control] }
    command {
	    if {[lindex $pars 0]} {
		grid $idata(window).cmd
	    } {
		grid forget $idata(window).cmd
	    }
	    return
	}
    users { return [$idata(net) users] }
    }
    if {[info exists idata($op)]} { return $idata($op) }
    switch {} [info procs info_$op] {return [objCall channel $this $op $pars]}
    return [eval info_$op $this $pars]
}
#
proc info_popup {this} {
    [$this wid] expose [$this net]
    handleOn [$this net] POPINFO [list [$this lname]]
    return $this
}
#
proc info_insert {this text} {
    switch {} $text return
    set ent [$this window].cmd.entry
    while {[regexp "(\[^\n\]*)\n(.*)" $text d line text]} {
	switch {} $line continue
	tkEntryInsert $ent $line
	$this doCmd $ent
	$ent delete 0 end
    }
    switch {} $text {} default {
	$ent insert insert $text
	tkEntrySeeInsert $ent
    }
}
#
proc info_flagState {this state} {
    [$this window].cmd.entry configure -state $state
}
#
proc info_close {this} {
    $this flagState disabled
}
