# convert_to_html.tcl --
#    Script to convert the lessons to "equivalent" pure HTML files
#

# split_lesson --
#     Split a lesson file into individual HTML files
# Arguments:
#     overview_file    Overview file
#     filename         Name of the lesson file
# Result:
#     None
# Side effects:
#     The procedure creates three HTML files, one for each level
#     and adds the lesson's title to the overview file
# Notes:
#     The output is not gathered yet in this version!
#

proc puts2file {fl str} {
    global really
    if {$really} {
	puts $fl $str
    }
}

proc split_lesson { overview_file filename } {

    set infile   [open $filename]
    set file   [file root $filename].html

    set outfile($file) [open $file "w"]
    puts $outfile($file) "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">
<html>
<head>
"

    set out {}

    # TODO
    set this     [file tail $file]
    set number   [string range [file root $this] 3 end]
    set previous "Tcl[expr {$number-1}]"
    set next     "Tcl[expr {$number+1}]"

    if { ! [file exists "$previous.lsn"] } {
       set previous ""
    } else {
       set previous "$previous.html"
    }

    if { ! [file exists "$next.lsn"] } {
       set next ""
    } else {
       set next "$next.html"
    }

    set code     0
    # really determines if we really print the stuff out or not.
    global really
    set really 1

    while { [gets $infile line] >= 0 } {
        #
        # Clean up the keyword, then see if there is one ...
        set word ""
	regsub "^;\#.*" $line "" line
        regexp {^:+[^:]*:+} $line word
	set word [string trim $word]

        switch -- $word {
            ":TITLE:" {

                set level 0
                set title [string trim [string map {:TITLE: {}} $line]]


		puts2file $outfile($file) "<title>$title</title>
    <link rel=\"stylesheet\" href=\"style.css\">
</head>
<body>

<h2 class=\"title\">$title</h2>"

		set navbar "<div class=\"nav\">"
		if { $previous != "" } {
		    append navbar \
			"<a href=\"$previous\">Previous lesson</a> | "
		}
		append navbar "<a href=\"tcltutorial.html\">Index</a>"
		if { $next != "" } {
		    append navbar \
			" | <a href=\"$next\">Next lesson</a>"
		}
		append navbar "</div>\n"
		puts2file $outfile($file) $navbar
		incr level

               puts2file $overview_file "<a href=\"$file\">$title</a><br>"
            }

            ":LESSON_TEXT_START_LEVEL 0:" {
		set really 0
            }

            ":LESSON_TEXT_START_LEVEL 1:" {
		set really 1
                set out [list $file]
            }

            ":LESSON_TEXT_START_LEVEL 2:" {
		set really 0
            }

            ":CODE_START:" {
		set really 1
                set code 1
		puts2file $outfile($file) {
		    <hr>
		    <h3>Example</h3>
		    <pre class="example">}
            }

            ":TEXT_END:" {
                if { $code == 1 } {
		    puts2file $outfile($file) "</pre>"
                   set code 0
                }
                set really 0
            }

	    "::CMD::" {
		set really 0
	    }

            "" {
		regsub -all "<CODE>(\[^<\]*)</CODE>" $line "<code class=\"keyword\">\\1</code>" line
		regsub -all "<P>" $line "</p><p>" line
		puts2file $outfile($file) $line
            }
            default {
                # Ignore
            }
        }
    }

    puts $outfile($file) $navbar

    puts $outfile($file) "</body></html>"
    close $outfile($file)
}

# main code
#
set overview_file [open "tcltutorial.html" "w"]
puts $overview_file "<html><title>Tcl Tutor</title><body>"

foreach file [lsort -dictionary [glob *.lsn]] {
    puts "$file ..."
    split_lesson $overview_file $file
}


puts $overview_file "</body></html>"
close $overview_file
