#!/bin/sh
# the next line restarts using tclsh \
    exec tclsh "$0" "$@"

# $Id: makeindex.tcl,v 1.2 2004/12/09 09:57:42 davidw Exp $

package require htmlparse

# makeindex.tcl takes the .html files and creates a nice index for
# them.

# Usage: cd html ; makeindex.tcl

proc gethtml {filename} {
    set fl [open $filename]
    set data [read $fl]
    close $fl
    return $data
}

set FileName {}
array set file2title {}

proc gettitle {tag slash param text} {
    global FileName
    global file2title
    if { [string match -nocase title $tag] && $slash == "" } {
	set file2title($FileName) [string trim $text]
    }
}

proc gettemplate {} {
    set fl [open [file join [file dirname [info script]] \
		      indextemplate.tml]]
    set data [read $fl]
    close $fl
    return $data
}

proc main {} {
    global FileName
    global file2title
    set files [lsort -dictionary [glob Tcl*.html]]
    foreach f $files {
	set FileName $f
	htmlparse::parse -cmd gettitle [gethtml $f]
    }
    set template [gettemplate]
    set links "<ul>\n"
    foreach f [lsort -dictionary [array names file2title]] {
	append links "<li><a href=\"$f\">$file2title($f)</a></li>\n"
    }
    append links "</ul>\n"
    set template [subst -nobackslashes -nocommands $template]
    set fl [open tcltutorial.html w]
    puts $fl $template
    close $fl
}

proc ::htmlparse::PrepareHtml {html} {
    # Remove the following items from the text:
    # - A leading	<!DOCTYPE...> declaration.
    # - All comments	<!-- ... -->
    #
    # Also normalize the line endings (\r -> \n).

    set html [string map [list \r \n] $html]

    regsub -- "^.*<!DOCTYPE\[^>\]*>"       $html {}     html
    set html [string map [list "-->" "\001"] $html]
    regsub -all -- "<!--\[^\001\]*\001" $html {}     html

    # Protect characters special to tcl (braces, slashes) by
    # converting them to their escape sequences.

    return [string map [list "\{" "&\#123;" "\}" "&\#125;" "\\" "&bsl;"] $html]
}


main